package drr.standards.iosco.cde.version1.quantity.reports;

import cdm.base.math.UnitType;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.qualification.product.functions.IsFXOption;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForTrade;
import drr.base.trade.quantity.functions.GetTradeForQuantity;
import drr.standards.iosco.cde.version1.quantity.functions.OptionAmountAndCurrency;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.functions.ConvertNonISOToISOCurrency;
import javax.inject.Inject;


@ImplementedBy(CallCurrencyRule.CallCurrencyRuleDefault.class)
public abstract class CallCurrencyRule implements ReportFunction<TransactionReportInstructionBase, ISOCurrencyCodeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected GetTradeForQuantity getTradeForQuantity;
	@Inject protected IsFXOption isFXOption;
	@Inject protected OptionAmountAndCurrency optionAmountAndCurrency;
	@Inject protected ProductForTrade productForTrade;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ISOCurrencyCodeEnum evaluate(TransactionReportInstructionBase input) {
		ISOCurrencyCodeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstructionBase input);

	public static class CallCurrencyRuleDefault extends CallCurrencyRule {
		@Override
		protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstructionBase input) {
			ISOCurrencyCodeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstructionBase input) {
			final MapperS<Product> thenArg0 = MapperS.of(productForTrade.evaluate(getTradeForQuantity.evaluate(input)));
			final MapperS<Product> thenArg1 = thenArg0
				.filterSingleNullSafe(item -> isFXOption.evaluate(item.get()));
			final MapperS<FieldWithMetaString> thenArg2 = MapperS.of(optionAmountAndCurrency.evaluate(MapperS.of(economicTermsForProduct.evaluate(thenArg1.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get(), OptionTypeCode.CALL)).<UnitType>map("getUnit", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getUnit()).<FieldWithMetaString>map("getCurrency", unitType -> unitType.getCurrency());
			output = thenArg2
				.mapSingleToItem(item -> {
					final FieldWithMetaString fieldWithMetaString = item.get();
					return MapperS.of(convertNonISOToISOCurrency.evaluate((fieldWithMetaString == null ? null : fieldWithMetaString.getValue())));
				}).get();
			
			return output;
		}
	}
}
