package drr.standards.iosco.cde.version3.underlier.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.TransactionReportInstructionBase;
import javax.inject.Inject;


@ImplementedBy(UnderlierIDOtherSourceRule.UnderlierIDOtherSourceRuleDefault.class)
public abstract class UnderlierIDOtherSourceRule implements ReportFunction<TransactionReportInstructionBase, ProductIdTypeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected UnderlierProductIdentifierOtherRule underlierProductIdentifierOtherRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ProductIdTypeEnum evaluate(TransactionReportInstructionBase input) {
		ProductIdTypeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ProductIdTypeEnum doEvaluate(TransactionReportInstructionBase input);

	public static class UnderlierIDOtherSourceRuleDefault extends UnderlierIDOtherSourceRule {
		@Override
		protected ProductIdTypeEnum doEvaluate(TransactionReportInstructionBase input) {
			ProductIdTypeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ProductIdTypeEnum assignOutput(ProductIdTypeEnum output, TransactionReportInstructionBase input) {
			output = MapperC.<ProductIdentifier>of(underlierProductIdentifierOtherRule.evaluate(input)).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource())
				.first().get();
			
			return output;
		}
	}
}
