package drr.standards.iosco.uti.functions;

import cdm.base.staticdata.identifier.AssignedIdentifier;
import cdm.base.staticdata.identifier.TradeIdentifierTypeEnum;
import cdm.event.common.TradeIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.ValuationDetails;
import drr.regulation.common.ValuationReportInstruction;
import drr.regulation.common.ValuationTradeInformation;
import drr.regulation.common.functions.GetRegimeSpecificIdentifiers;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(UniqueTransactionIdentifierForValuation.UniqueTransactionIdentifierForValuationDefault.class)
public abstract class UniqueTransactionIdentifierForValuation implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetRegimeSpecificIdentifiers getRegimeSpecificIdentifiers;

	/**
	* @param valuationReportInstruction 
	* @param supervisoryBody 
	* @return uti 
	*/
	public String evaluate(ValuationReportInstruction valuationReportInstruction, List<SupervisoryBodyEnum> supervisoryBody) {
		String uti = doEvaluate(valuationReportInstruction, supervisoryBody);
		
		return uti;
	}

	protected abstract String doEvaluate(ValuationReportInstruction valuationReportInstruction, List<SupervisoryBodyEnum> supervisoryBody);

	public static class UniqueTransactionIdentifierForValuationDefault extends UniqueTransactionIdentifierForValuation {
		@Override
		protected String doEvaluate(ValuationReportInstruction valuationReportInstruction, List<SupervisoryBodyEnum> supervisoryBody) {
			if (supervisoryBody == null) {
				supervisoryBody = Collections.emptyList();
			}
			String uti = null;
			return assignOutput(uti, valuationReportInstruction, supervisoryBody);
		}
		
		protected String assignOutput(String uti, ValuationReportInstruction valuationReportInstruction, List<SupervisoryBodyEnum> supervisoryBody) {
			final MapperS<String> thenArg = MapperC.<String>of(getRegimeSpecificIdentifiers.evaluate(MapperS.of(valuationReportInstruction).<ReportableInformation>map("getReportableInformation", _valuationReportInstruction -> _valuationReportInstruction.getReportableInformation()).get(), supervisoryBody, TradeIdentifierTypeEnum.UNIQUE_TRANSACTION_IDENTIFIER)).getMulti().isEmpty() ? MapperS.of(MapperS.of(valuationReportInstruction).<ValuationDetails>map("getValuationDetails", _valuationReportInstruction -> _valuationReportInstruction.getValuationDetails()).<ValuationTradeInformation>map("getTradeInformation", valuationDetails -> valuationDetails.getTradeInformation()).<TradeIdentifier>map("getUniqueTradeIdentifier", valuationTradeInformation -> valuationTradeInformation.getUniqueTradeIdentifier()).<AssignedIdentifier>mapC("getAssignedIdentifier", tradeIdentifier -> tradeIdentifier.getAssignedIdentifier()).<FieldWithMetaString>map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier()).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).get()) : MapperS.of(MapperC.<String>of(getRegimeSpecificIdentifiers.evaluate(MapperS.of(valuationReportInstruction).<ReportableInformation>map("getReportableInformation", _valuationReportInstruction -> _valuationReportInstruction.getReportableInformation()).get(), supervisoryBody, TradeIdentifierTypeEnum.UNIQUE_TRANSACTION_IDENTIFIER)).get());
			uti = MapperS.of(distinct(thenArg).get()).get();
			
			return uti;
		}
	}
}
