/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.price;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="PriceNotationEnum")
public enum PriceNotationEnum {
    MONETARY("Monetary", null),
    PERCENTAGE("Percentage", null),
    DECIMAL("Decimal", null),
    BASIS("Basis", null);

    private static Map<String, PriceNotationEnum> values;
    private final String rosettaName;
    private final String displayName;

    private PriceNotationEnum(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static PriceNotationEnum fromDisplayName(String name) {
        PriceNotationEnum value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, PriceNotationEnum> map = new ConcurrentHashMap<String, PriceNotationEnum>();
        for (PriceNotationEnum instance : PriceNotationEnum.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

