/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.quantity.reports;

import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=CommodityFixedPriceQuantityRuleDefault.class)
public abstract class CommodityFixedPriceQuantityRule
implements ReportFunction<TradeLot, PriceQuantity> {
    @Inject
    protected ModelObjectValidator objectValidator;

    public PriceQuantity evaluate(TradeLot input) {
        PriceQuantity output;
        PriceQuantity.PriceQuantityBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceQuantity.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceQuantity.PriceQuantityBuilder doEvaluate(TradeLot var1);

    public static class CommodityFixedPriceQuantityRuleDefault
    extends CommodityFixedPriceQuantityRule {
        @Override
        protected PriceQuantity.PriceQuantityBuilder doEvaluate(TradeLot input) {
            PriceQuantity.PriceQuantityBuilder output = PriceQuantity.builder();
            return this.assignOutput(output, input);
        }

        protected PriceQuantity.PriceQuantityBuilder assignOutput(PriceQuantity.PriceQuantityBuilder output, TradeLot input) {
            MapperC thenArg = MapperS.of((Object)input).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.notExists((Mapper)item.map("getObservable", priceQuantity -> priceQuantity.getObservable())).get());
            output = (PriceQuantity.PriceQuantityBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((PriceQuantity)thenArg.get())).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

