/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.underlier.functions;

import cdm.base.staticdata.asset.common.IndexReferenceInformation;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import cdm.product.asset.CreditIndexReferenceInformation;
import cdm.product.asset.ReferenceObligation;
import cdm.product.qualification.functions.Qualify_BaseProduct_IRSwap;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.qualification.product.functions.IsFRA;
import drr.base.qualification.product.functions.IsProductETD;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.underlier.functions.FilterProductIdentifier;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=UnderlierProductIdentifierDefault.class)
public abstract class UnderlierProductIdentifier
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected FilterProductIdentifier filterProductIdentifier;
    @Inject
    protected IsFRA isFRA;
    @Inject
    protected IsProductETD isProductETD;
    @Inject
    protected Qualify_BaseProduct_IRSwap qualify_BaseProduct_IRSwap;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public List<? extends ProductIdentifier> evaluate(Product product, ProductIdTypeEnum identifierType) {
        List productId;
        List<ProductIdentifier.ProductIdentifierBuilder> productIdBuilder = this.doEvaluate(product, identifierType);
        if (productIdBuilder == null) {
            productId = null;
        } else {
            productId = productIdBuilder.stream().map(ProductIdentifier::build).collect(Collectors.toList());
            this.objectValidator.validate(ProductIdentifier.class, productId);
        }
        return productId;
    }

    protected abstract List<ProductIdentifier.ProductIdentifierBuilder> doEvaluate(Product var1, ProductIdTypeEnum var2);

    protected abstract MapperS<? extends Payout> productPayout(Product var1, ProductIdTypeEnum var2);

    protected abstract MapperS<? extends Payout> underlierPayout(Product var1, ProductIdTypeEnum var2);

    protected abstract MapperC<? extends ReferenceObligation> cdsProduct(Product var1, ProductIdTypeEnum var2);

    protected abstract MapperC<? extends ReferenceObligation> cdsUnderlying(Product var1, ProductIdTypeEnum var2);

    protected abstract MapperS<? extends CreditIndexReferenceInformation> cdsIndexUnderlying(Product var1, ProductIdTypeEnum var2);

    protected abstract MapperS<? extends CreditIndexReferenceInformation> cdsIndex(Product var1, ProductIdTypeEnum var2);

    protected abstract MapperC<? extends IndexReferenceInformation> floatingRateIndex(Product var1, ProductIdTypeEnum var2);

    protected abstract MapperC<? extends IndexReferenceInformation> inflationRateIndex(Product var1, ProductIdTypeEnum var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> cdsProductID(Product var1, ProductIdTypeEnum var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> underlierProductID(Product var1, ProductIdTypeEnum var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> etdProductID(Product var1, ProductIdTypeEnum var2);

    protected abstract MapperC<? extends ProductIdentifier> otcProductID(Product var1, ProductIdTypeEnum var2);

    protected abstract MapperC<? extends ProductIdentifier> indexProductId(Product var1, ProductIdTypeEnum var2);

    protected abstract MapperS<? extends ProductIdentifier> indexNoProductId(Product var1, ProductIdTypeEnum var2);

    protected abstract MapperC<? extends ReferenceWithMetaProductIdentifier> basketProductId(Product var1, ProductIdTypeEnum var2);

    protected abstract MapperC<? extends ProductIdentifier> basketNoProductId(Product var1, ProductIdTypeEnum var2);

    public static class UnderlierProductIdentifierDefault
    extends UnderlierProductIdentifier {
        @Override
        protected List<ProductIdentifier.ProductIdentifierBuilder> doEvaluate(Product product, ProductIdTypeEnum identifierType) {
            ArrayList<ProductIdentifier.ProductIdentifierBuilder> productId = new ArrayList<ProductIdentifier.ProductIdentifierBuilder>();
            return this.assignOutput(productId, product, identifierType);
        }

        protected List<ProductIdentifier.ProductIdentifierBuilder> assignOutput(List<ProductIdentifier.ProductIdentifierBuilder> productId, Product product, ProductIdTypeEnum identifierType) {
            MapperC thenArg = MapperC.of((MapperBuilder[])new MapperBuilder[]{this.cdsProductID(product, identifierType).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()), this.underlierProductID(product, identifierType).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()), this.etdProductID(product, identifierType).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()), this.otcProductID(product, identifierType), this.indexProductId(product, identifierType), this.indexNoProductId(product, identifierType), this.basketProductId(product, identifierType).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()), this.basketNoProductId(product, identifierType)});
            MapperC ifThenElseResult = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)identifierType)).getOrDefault(Boolean.valueOf(false)) != false ? MapperC.of(Collections.singletonList(this.filterProductIdentifier.evaluate(thenArg.getMulti(), identifierType))) : thenArg;
            productId.addAll(this.toBuilder(ifThenElseResult.getMulti()));
            return Optional.ofNullable(productId).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends Payout> productPayout(Product product, ProductIdTypeEnum identifierType) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout());
        }

        @Override
        protected MapperS<? extends Payout> underlierPayout(Product product, ProductIdTypeEnum identifierType) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getPayout", economicTerms -> economicTerms.getPayout());
        }

        @Override
        protected MapperC<? extends ReferenceObligation> cdsProduct(Product product, ProductIdTypeEnum identifierType) {
            return this.productPayout(product, identifierType).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation());
        }

        @Override
        protected MapperC<? extends ReferenceObligation> cdsUnderlying(Product product, ProductIdTypeEnum identifierType) {
            return this.underlierPayout(product, identifierType).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation());
        }

        @Override
        protected MapperS<? extends CreditIndexReferenceInformation> cdsIndexUnderlying(Product product, ProductIdTypeEnum identifierType) {
            return this.underlierPayout(product, identifierType).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation());
        }

        @Override
        protected MapperS<? extends CreditIndexReferenceInformation> cdsIndex(Product product, ProductIdTypeEnum identifierType) {
            return this.productPayout(product, identifierType).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getIndexReferenceInformation", generalTerms -> generalTerms.getIndexReferenceInformation());
        }

        @Override
        protected MapperC<? extends IndexReferenceInformation> floatingRateIndex(Product product, ProductIdTypeEnum identifierType) {
            return this.productPayout(product, identifierType).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation());
        }

        @Override
        protected MapperC<? extends IndexReferenceInformation> inflationRateIndex(Product product, ProductIdTypeEnum identifierType) {
            return this.productPayout(product, identifierType).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()).map("getRateOption", inflationRateSpecification -> inflationRateSpecification.getRateOption()).map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).map("getIndexReferenceInformation", floatingRateOption -> floatingRateOption.getIndexReferenceInformation());
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> cdsProductID(Product product, ProductIdTypeEnum identifierType) {
            MapperC<? extends ReferenceObligation> thenArg0 = ExpressionOperatorsNullSafe.exists(this.cdsProduct(product, identifierType)).getOrDefault(Boolean.valueOf(false)) != false ? this.cdsProduct(product, identifierType) : (ExpressionOperatorsNullSafe.exists(this.cdsUnderlying(product, identifierType)).getOrDefault(Boolean.valueOf(false)) != false ? this.cdsUnderlying(product, identifierType) : MapperC.ofNull());
            MapperListOfLists thenArg1 = thenArg0.mapItemToList(item -> {
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getSecurity", referenceObligation -> referenceObligation.getSecurity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).mapC("getProductIdentifier", security -> security.getProductIdentifier());
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getLoan", referenceObligation -> referenceObligation.getLoan())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getLoan", referenceObligation -> referenceObligation.getLoan()).mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
                }
                return MapperC.ofNull();
            });
            return thenArg1.flattenList();
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> underlierProductID(Product product, ProductIdTypeEnum identifierType) {
            MapperS thenArg = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.underlierForProduct.evaluate(product))).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.underlierForProduct.evaluate(product)) : MapperS.ofNull();
            return thenArg.mapSingleToList(item -> {
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getSecurity", _product -> _product.getSecurity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getSecurity", _product -> _product.getSecurity()).mapC("getProductIdentifier", security -> security.getProductIdentifier());
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getLoan", _product -> _product.getLoan())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getLoan", _product -> _product.getLoan()).mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getIndex", _product -> _product.getIndex())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getIndex", _product -> _product.getIndex()).mapC("getProductIdentifier", index -> index.getProductIdentifier());
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getCommodity", _product -> _product.getCommodity())).andNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isProductETD.evaluate(product)))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier());
                }
                return MapperC.ofNull();
            });
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> etdProductID(Product product, ProductIdTypeEnum identifierType) {
            Boolean _boolean = this.isProductETD.evaluate(product);
            if (_boolean != null && _boolean.booleanValue()) {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity0 -> referenceWithMetaCommodity0 == null ? null : referenceWithMetaCommodity0.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity1 -> referenceWithMetaCommodity1 == null ? null : referenceWithMetaCommodity1.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier());
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.underlierForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getIndex", _product -> _product.getIndex())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.underlierForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getIndex", _product -> _product.getIndex()).mapC("getProductIdentifier", index -> index.getProductIdentifier());
                }
                return MapperC.ofNull();
            }
            return MapperC.ofNull();
        }

        @Override
        protected MapperC<? extends ProductIdentifier> otcProductID(Product product, ProductIdTypeEnum identifierType) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getContractualProduct", _product -> _product.getContractualProduct()).mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getContractualProduct", _product -> _product.getContractualProduct()).mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue());
            }
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getContractualProduct", _product -> _product.getContractualProduct()).mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getContractualProduct", _product -> _product.getContractualProduct()).mapC("getProductIdentifier", contractualProduct -> contractualProduct.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue());
            }
            if (ExpressionOperatorsNullSafe.exists((Mapper)this.productPayout(product, identifierType).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getBondReference", interestRatePayout -> interestRatePayout.getBondReference()).map("getBond", bondReference -> bondReference.getBond())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.productPayout(product, identifierType).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getBondReference", interestRatePayout -> interestRatePayout.getBondReference()).map("getBond", bondReference -> bondReference.getBond());
            }
            if (ExpressionOperatorsNullSafe.exists((Mapper)this.productPayout(product, identifierType).mapC("getForwardPayout", payout -> payout.getForwardPayout()).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.productPayout(product, identifierType).mapC("getForwardPayout", payout -> payout.getForwardPayout()).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue());
            }
            return MapperC.ofNull();
        }

        @Override
        protected MapperC<? extends ProductIdentifier> indexProductId(Product product, ProductIdTypeEnum identifierType) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)this.cdsIndex(product, identifierType).mapC("getProductIdentifier", creditIndexReferenceInformation -> creditIndexReferenceInformation.getProductIdentifier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.cdsIndex(product, identifierType).mapC("getProductIdentifier", creditIndexReferenceInformation -> creditIndexReferenceInformation.getProductIdentifier());
            }
            if (ExpressionOperatorsNullSafe.exists((Mapper)this.cdsIndexUnderlying(product, identifierType).mapC("getProductIdentifier", creditIndexReferenceInformation -> creditIndexReferenceInformation.getProductIdentifier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.cdsIndexUnderlying(product, identifierType).mapC("getProductIdentifier", creditIndexReferenceInformation -> creditIndexReferenceInformation.getProductIdentifier());
            }
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isFRA.evaluate(product))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)this.floatingRateIndex(product, identifierType).mapC("getProductIdentifier", indexReferenceInformation -> indexReferenceInformation.getProductIdentifier()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.floatingRateIndex(product, identifierType).mapC("getProductIdentifier", indexReferenceInformation -> indexReferenceInformation.getProductIdentifier());
            }
            Boolean boolean0 = this.qualify_BaseProduct_IRSwap.evaluate(this.economicTermsForProduct.evaluate(product));
            if (boolean0 != null && boolean0.booleanValue()) {
                return MapperC.of((MapperBuilder[])new MapperBuilder[]{this.floatingRateIndex(product, identifierType).mapC("getProductIdentifier", indexReferenceInformation -> indexReferenceInformation.getProductIdentifier()), this.floatingRateIndex(product, identifierType).mapC("getProductIdentifier", indexReferenceInformation -> indexReferenceInformation.getProductIdentifier())});
            }
            Boolean boolean1 = this.qualify_BaseProduct_IRSwap.evaluate(this.economicTermsForProduct.evaluate(product));
            if (boolean1 != null && boolean1.booleanValue()) {
                return MapperC.of((MapperBuilder[])new MapperBuilder[]{this.floatingRateIndex(product, identifierType).mapC("getProductIdentifier", indexReferenceInformation -> indexReferenceInformation.getProductIdentifier()), this.inflationRateIndex(product, identifierType).mapC("getProductIdentifier", indexReferenceInformation -> indexReferenceInformation.getProductIdentifier())});
            }
            return MapperC.ofNull();
        }

        @Override
        protected MapperS<? extends ProductIdentifier> indexNoProductId(Product product, ProductIdTypeEnum identifierType) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)this.cdsIndex(product, identifierType).map("getIndexName", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexName())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)this.cdsIndex(product, identifierType).mapC("getProductIdentifier", creditIndexReferenceInformation -> creditIndexReferenceInformation.getProductIdentifier()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)ProductIdentifier.builder().setIdentifier((FieldWithMetaString)this.cdsIndex(product, identifierType).map("getIndexName", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexName()).get()).setSource(ProductIdTypeEnum.NAME).build());
            }
            if (ExpressionOperatorsNullSafe.exists((Mapper)this.cdsIndexUnderlying(product, identifierType).map("getIndexName", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexName())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)this.cdsIndexUnderlying(product, identifierType).mapC("getProductIdentifier", creditIndexReferenceInformation -> creditIndexReferenceInformation.getProductIdentifier()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)ProductIdentifier.builder().setIdentifier((FieldWithMetaString)this.cdsIndexUnderlying(product, identifierType).map("getIndexName", creditIndexReferenceInformation -> creditIndexReferenceInformation.getIndexName()).get()).setSource(ProductIdTypeEnum.NAME).build());
            }
            if (ExpressionOperatorsNullSafe.exists((Mapper)this.floatingRateIndex(product, identifierType).map("getIndexName", indexReferenceInformation -> indexReferenceInformation.getIndexName())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)this.floatingRateIndex(product, identifierType).mapC("getProductIdentifier", indexReferenceInformation -> indexReferenceInformation.getProductIdentifier()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)ProductIdentifier.builder().setIdentifier((FieldWithMetaString)this.floatingRateIndex(product, identifierType).map("getIndexName", indexReferenceInformation -> indexReferenceInformation.getIndexName()).get()).setSource(ProductIdTypeEnum.NAME).build());
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperC<? extends ReferenceWithMetaProductIdentifier> basketProductId(Product product, ProductIdTypeEnum identifierType) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getBasket", _product -> _product.getBasket())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)this.underlierForProduct.evaluate(product)).map("getBasket", _product -> _product.getBasket()).mapC("getProductIdentifier", basket -> basket.getProductIdentifier());
            }
            return MapperC.ofNull();
        }

        @Override
        protected MapperC<? extends ProductIdentifier> basketNoProductId(Product product, ProductIdTypeEnum identifierType) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)this.productPayout(product, identifierType).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).mapC("getBasketId", basketReferenceInformation -> basketReferenceInformation.getBasketId())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.productPayout(product, identifierType).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).mapC("getBasketId", basketReferenceInformation -> basketReferenceInformation.getBasketId()).mapItem(item -> MapperS.of((Object)ProductIdentifier.builder().setIdentifier((FieldWithMetaString)item.get()).setSource(ProductIdTypeEnum.OTHER).build()));
            }
            if (ExpressionOperatorsNullSafe.exists((Mapper)this.underlierPayout(product, identifierType).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).mapC("getBasketId", basketReferenceInformation -> basketReferenceInformation.getBasketId())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.underlierPayout(product, identifierType).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getBasketReferenceInformation", generalTerms -> generalTerms.getBasketReferenceInformation()).mapC("getBasketId", basketReferenceInformation -> basketReferenceInformation.getBasketId()).mapItem(item -> MapperS.of((Object)ProductIdentifier.builder().setIdentifier((FieldWithMetaString)item.get()).setSource(ProductIdTypeEnum.OTHER).build()));
            }
            return MapperC.ofNull();
        }
    }
}

