/*
 * Decompiled with CFR 0.152.
 */
package drr.enrichment.lei.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.enrichment.lei.LeiData;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=API_GetLeiDataDefault.class)
public abstract class API_GetLeiData
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public LeiData evaluate(String lei) {
        LeiData leiData;
        LeiData.LeiDataBuilder leiDataBuilder = this.doEvaluate(lei);
        if (leiDataBuilder == null) {
            leiData = null;
        } else {
            leiData = leiDataBuilder.build();
            this.objectValidator.validate(LeiData.class, (RosettaModelObject)leiData);
        }
        return leiData;
    }

    protected abstract LeiData.LeiDataBuilder doEvaluate(String var1);

    public static class API_GetLeiDataDefault
    extends API_GetLeiData {
        @Override
        protected LeiData.LeiDataBuilder doEvaluate(String lei) {
            LeiData.LeiDataBuilder leiData = LeiData.builder();
            return this.assignOutput(leiData, lei);
        }

        protected LeiData.LeiDataBuilder assignOutput(LeiData.LeiDataBuilder leiData, String lei) {
            return Optional.ofNullable(leiData).map(o -> o.prune()).orElse(null);
        }
    }
}

