/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.jfsa.rewrite.trade.functions;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.util.string.functions.StringLength;
import drr.base.util.string.functions.SubString;
import drr.regulation.common.trade.underlier.UnderlyingIdentificationTypeEnum;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.standards.iso.IndexEnum;
import iso20022.auth030.jfsa.BasketConstituents3__1;
import iso20022.auth030.jfsa.CustomBasket4__1;
import iso20022.auth030.jfsa.GenericIdentification184;
import iso20022.auth030.jfsa.IndexIdentification1__1;
import iso20022.auth030.jfsa.InstrumentIdentification6Choice__1;
import iso20022.auth030.jfsa.SecurityIdentification41Choice__1;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetUndrlygInstrmDefault.class)
public abstract class GetUndrlygInstrm
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected StringLength stringLength;
    @Inject
    protected SubString subString;

    public SecurityIdentification41Choice__1 evaluate(JFSATransactionReport drrReport) {
        SecurityIdentification41Choice__1 undrlygInstrm;
        SecurityIdentification41Choice__1.SecurityIdentification41Choice__1Builder undrlygInstrmBuilder = this.doEvaluate(drrReport);
        if (undrlygInstrmBuilder == null) {
            undrlygInstrm = null;
        } else {
            undrlygInstrm = undrlygInstrmBuilder.build();
            this.objectValidator.validate(SecurityIdentification41Choice__1.class, (RosettaModelObject)undrlygInstrm);
        }
        return undrlygInstrm;
    }

    protected abstract SecurityIdentification41Choice__1.SecurityIdentification41Choice__1Builder doEvaluate(JFSATransactionReport var1);

    public static class GetUndrlygInstrmDefault
    extends GetUndrlygInstrm {
        @Override
        protected SecurityIdentification41Choice__1.SecurityIdentification41Choice__1Builder doEvaluate(JFSATransactionReport drrReport) {
            SecurityIdentification41Choice__1.SecurityIdentification41Choice__1Builder undrlygInstrm = SecurityIdentification41Choice__1.builder();
            return this.assignOutput(undrlygInstrm, drrReport);
        }

        protected SecurityIdentification41Choice__1.SecurityIdentification41Choice__1Builder assignOutput(SecurityIdentification41Choice__1.SecurityIdentification41Choice__1Builder undrlygInstrm, JFSATransactionReport drrReport) {
            String ifThenElseResult0 = null;
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getUnderlyingIdentificationType", jFSATransactionReport -> jFSATransactionReport.getUnderlyingIdentificationType()), (Mapper)MapperS.of((Object)((Object)UnderlyingIdentificationTypeEnum.I)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult0 = (String)MapperS.of((Object)drrReport).map("getUnderlyingIdentification", jFSATransactionReport -> jFSATransactionReport.getUnderlyingIdentification()).get();
            }
            String ifThenElseResult1 = null;
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getUnderlyingIdentificationType", jFSATransactionReport -> jFSATransactionReport.getUnderlyingIdentificationType()), (Mapper)MapperS.of((Object)((Object)UnderlyingIdentificationTypeEnum.X)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult1 = (String)MapperS.of((Object)drrReport).map("getUnderlyingIndexIndicator", jFSATransactionReport -> jFSATransactionReport.getUnderlyingIndexIndicator()).map("to-string", IndexEnum::toDisplayString).get();
            }
            String ifThenElseResult2 = null;
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getUnderlyingIdentificationType", jFSATransactionReport -> jFSATransactionReport.getUnderlyingIdentificationType()), (Mapper)MapperS.of((Object)((Object)UnderlyingIdentificationTypeEnum.X)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult2 = (String)MapperS.of((Object)drrReport).map("getNameOfTheUnderlyingIndex", jFSATransactionReport -> jFSATransactionReport.getNameOfTheUnderlyingIndex()).get();
            }
            String ifThenElseResult3 = null;
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getUnderlyingIdentificationType", jFSATransactionReport -> jFSATransactionReport.getUnderlyingIdentificationType()), (Mapper)MapperS.of((Object)((Object)UnderlyingIdentificationTypeEnum.X)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult3 = (String)MapperS.of((Object)drrReport).map("getUnderlyingIdentification", jFSATransactionReport -> jFSATransactionReport.getUnderlyingIdentification()).map("to-string", Object::toString).get();
            }
            String ifThenElseResult4 = null;
            if (ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)this.stringLength.evaluate((String)MapperS.of((Object)drrReport).map("getCustomBasketCode", jFSATransactionReport -> jFSATransactionReport.getCustomBasketCode()).get())), (Mapper)MapperS.of((Object)20), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult4 = this.subString.evaluate((String)MapperS.of((Object)drrReport).map("getCustomBasketCode", jFSATransactionReport -> jFSATransactionReport.getCustomBasketCode()).get(), 21, 52);
            }
            undrlygInstrm = (SecurityIdentification41Choice__1.SecurityIdentification41Choice__1Builder)this.toBuilder((RosettaModelObject)SecurityIdentification41Choice__1.builder().setIsin(ifThenElseResult0).setIndx(IndexIdentification1__1.builder().setIndx(ifThenElseResult1).setNm(ifThenElseResult2).setIsin(ifThenElseResult3).build()).setBskt(CustomBasket4__1.builder().setStrr(this.subString.evaluate((String)MapperS.of((Object)drrReport).map("getCustomBasketCode", jFSATransactionReport -> jFSATransactionReport.getCustomBasketCode()).get(), 1, 20)).setId(ifThenElseResult4).setCnsttnts(MapperS.of((Object)drrReport).mapC("getBasketConstituents", jFSATransactionReport -> jFSATransactionReport.getBasketConstituents()).mapItem(item -> {
                String _ifThenElseResult0 = null;
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getSource", basketConstituentsReport -> basketConstituentsReport.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.ISIN), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    _ifThenElseResult0 = (String)item.map("getIdentifier", basketConstituentsReport -> basketConstituentsReport.getIdentifier()).get();
                }
                String _ifThenElseResult1 = null;
                if (ExpressionOperatorsNullSafe.notEqual((Mapper)item.map("getSource", basketConstituentsReport -> basketConstituentsReport.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.ISIN), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    _ifThenElseResult1 = (String)item.map("getIdentifier", basketConstituentsReport -> basketConstituentsReport.getIdentifier()).get();
                }
                String _ifThenElseResult2 = null;
                if (ExpressionOperatorsNullSafe.notEqual((Mapper)item.map("getSource", basketConstituentsReport -> basketConstituentsReport.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.ISIN), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    _ifThenElseResult2 = (String)item.map("getSource", basketConstituentsReport -> basketConstituentsReport.getSource()).map("to-string", ProductIdTypeEnum::toDisplayString).get();
                }
                return MapperS.of((Object)BasketConstituents3__1.builder().setInstrmId(InstrumentIdentification6Choice__1.builder().setIsin(_ifThenElseResult0).setOthrId(GenericIdentification184.builder().setId(_ifThenElseResult1).setSrc(_ifThenElseResult2).build()).build()).build());
            }).getMulti()).build()).build());
            return Optional.ofNullable(undrlygInstrm).map(o -> o.prune()).orElse(null);
        }
    }
}

