/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.FrequencyPeriodEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ASICTransactionReportDTCC_ASIC_BR_1070_01")
@ImplementedBy(value=Default.class)
public interface ASICTransactionReportDTCC_ASIC_BR_1070_01
extends Validator<ASICTransactionReport> {
    public static final String NAME = "ASICTransactionReportDTCC_ASIC_BR_1070_01";
    public static final String DEFINITION = "if [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType and [CommonAssetClass -> CRDT, CommonAssetClass -> EQUI, CommonAssetClass -> COMM, CommonAssetClass -> INTR] any = assetClass and [CommonContractType -> FRAS, CommonContractType -> OPTN, CommonContractType -> SWAP, CommonContractType -> SWPT, CommonContractType -> OTHR] any = contractType then if [FrequencyPeriodEnum -> YEAR, FrequencyPeriodEnum -> MNTH, FrequencyPeriodEnum -> WEEK, FrequencyPeriodEnum -> DAIL, FrequencyPeriodEnum -> EXPI] any = leg1 -> periodicPayment -> fixedRatePaymentFrequencyPeriod then leg1 -> periodicPayment -> fixedRatePaymentFrequencyPeriodMultiplier exists and (leg1 -> periodicPayment -> fixedRatePaymentFrequencyPeriodMultiplier < 1000 and leg1 -> periodicPayment -> fixedRatePaymentFrequencyPeriodMultiplier > 0) else if leg1 -> periodicPayment -> fixedRatePaymentFrequencyPeriod = FrequencyPeriodEnum -> EXPI then leg1 -> periodicPayment -> fixedRatePaymentFrequencyPeriodMultiplier = 1 else if leg1 -> periodicPayment -> fixedRatePaymentFrequencyPeriod is absent or leg1 -> periodicPayment -> fixedRatePaymentFrequencyPeriod = FrequencyPeriodEnum -> ADHO then leg1 -> periodicPayment -> fixedRatePaymentFrequencyPeriodMultiplier is absent";

    public static class NoOp
    implements ASICTransactionReportDTCC_ASIC_BR_1070_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ASICTransactionReportDTCC_ASIC_BR_1070_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICTransactionReport aSICTransactionReport) {
            ComparisonResult result = this.executeDataRule(aSICTransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ASICTransactionReportDTCC_ASIC_BR_1070_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ASICTransactionReport", (RosettaPath)path, (String)ASICTransactionReportDTCC_ASIC_BR_1070_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ASICTransactionReportDTCC_ASIC_BR_1070_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ASICTransactionReport", (RosettaPath)path, (String)ASICTransactionReportDTCC_ASIC_BR_1070_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ASICTransactionReport aSICTransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getActionType", _aSICTransactionReport -> _aSICTransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)CommonAssetClass.CRDT)), MapperS.of((Object)((Object)CommonAssetClass.EQUI)), MapperS.of((Object)((Object)CommonAssetClass.COMM)), MapperS.of((Object)((Object)CommonAssetClass.INTR))}), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getAssetClass", _aSICTransactionReport -> _aSICTransactionReport.getAssetClass()), (CardinalityOperator)CardinalityOperator.Any)).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)CommonContractType.FRAS)), MapperS.of((Object)((Object)CommonContractType.OPTN)), MapperS.of((Object)((Object)CommonContractType.SWAP)), MapperS.of((Object)((Object)CommonContractType.SWPT)), MapperS.of((Object)((Object)CommonContractType.OTHR))}), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getContractType", _aSICTransactionReport -> _aSICTransactionReport.getContractType()), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)FrequencyPeriodEnum.YEAR)), MapperS.of((Object)((Object)FrequencyPeriodEnum.MNTH)), MapperS.of((Object)((Object)FrequencyPeriodEnum.WEEK)), MapperS.of((Object)((Object)FrequencyPeriodEnum.DAIL)), MapperS.of((Object)((Object)FrequencyPeriodEnum.EXPI))}), (Mapper)MapperS.of((Object)aSICTransactionReport).map("getLeg1", _aSICTransactionReport -> _aSICTransactionReport.getLeg1()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)aSICTransactionReport).map("getLeg1", _aSICTransactionReport -> _aSICTransactionReport.getLeg1()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier())).andNullSafe(ExpressionOperatorsNullSafe.lessThan((Mapper)MapperS.of((Object)aSICTransactionReport).map("getLeg1", _aSICTransactionReport -> _aSICTransactionReport.getLeg1()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()), (Mapper)MapperS.of((Object)1000), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)aSICTransactionReport).map("getLeg1", _aSICTransactionReport -> _aSICTransactionReport.getLeg1()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()), (Mapper)MapperS.of((Object)0), (CardinalityOperator)CardinalityOperator.All)));
                    }
                    if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)aSICTransactionReport).map("getLeg1", _aSICTransactionReport -> _aSICTransactionReport.getLeg1()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()), (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.EXPI)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)aSICTransactionReport).map("getLeg1", _aSICTransactionReport -> _aSICTransactionReport.getLeg1()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All);
                    }
                    if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)aSICTransactionReport).map("getLeg1", _aSICTransactionReport -> _aSICTransactionReport.getLeg1()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod())).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)aSICTransactionReport).map("getLeg1", _aSICTransactionReport -> _aSICTransactionReport.getLeg1()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()), (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.ADHO)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)aSICTransactionReport).map("getLeg1", _aSICTransactionReport -> _aSICTransactionReport.getLeg1()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()));
                    }
                    return ComparisonResult.ofEmpty();
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

