/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.valuation.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.valuation.ASICValuationReport;
import drr.regulation.asic.rewrite.valuation.labels.ASICValuationLabelProvider;
import drr.regulation.asic.rewrite.valuation.reports.Counterparty2Rule;
import drr.regulation.asic.rewrite.valuation.reports.ExecutionAgentOfTheCounterparty1Rule;
import drr.regulation.asic.rewrite.valuation.reports.ExecutionAgentOfTheCounterparty2DTCCRule;
import drr.regulation.asic.rewrite.valuation.reports.SmallScaleBuySideEntityIndicatorRule;
import drr.regulation.asic.rewrite.valuation.reports.TechnicalRecordIdRule;
import drr.regulation.asic.rewrite.valuation.reports.UniqueTransactionIdentifierProprietaryRule;
import drr.regulation.asic.rewrite.valuation.reports.UniqueTransactionIdentifierRule;
import drr.regulation.common.ValuationReportInstruction;
import drr.regulation.common.valuation.datetime.reports.NextFloatingReferenceResetDateLeg1Rule;
import drr.regulation.common.valuation.datetime.reports.NextFloatingReferenceResetDateLeg2Rule;
import drr.regulation.common.valuation.datetime.reports.ReportingTimestampRule;
import drr.regulation.common.valuation.datetime.reports.ValuationTimestampRule;
import drr.regulation.common.valuation.event.reports.ActionTypeRule;
import drr.regulation.common.valuation.event.reports.LevelRule;
import drr.regulation.common.valuation.party.reports.Counterparty1Rule;
import drr.regulation.common.valuation.party.reports.Counterparty2IdentifierTypeRule;
import drr.regulation.common.valuation.party.reports.EntityResponsibleForReportingRule;
import drr.regulation.common.valuation.party.reports.ReportSubmittingEntityIDRule;
import drr.regulation.common.valuation.quantity.reports.DeltaRule;
import drr.regulation.common.valuation.valuation.reports.ValuationAmountRule;
import drr.regulation.common.valuation.valuation.reports.ValuationCurrencyRule;
import drr.regulation.common.valuation.valuation.reports.ValuationMethodRule;
import java.util.Optional;
import javax.inject.Inject;

@RosettaReport(namespace="drr.regulation.asic.rewrite.valuation", body="ASIC", corpusList={"Valuation"})
@RuneLabelProvider(labelProvider=ASICValuationLabelProvider.class)
@ImplementedBy(value=ASICValuationReportFunctionDefault.class)
public abstract class ASICValuationReportFunction
implements ReportFunction<ValuationReportInstruction, ASICValuationReport> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ActionTypeRule actionTypeRule;
    @Inject
    protected Counterparty1Rule counterparty1Rule;
    @Inject
    protected Counterparty2IdentifierTypeRule counterparty2IdentifierTypeRule;
    @Inject
    protected Counterparty2Rule counterparty2Rule;
    @Inject
    protected DeltaRule deltaRule;
    @Inject
    protected EntityResponsibleForReportingRule entityResponsibleForReportingRule;
    @Inject
    protected ExecutionAgentOfTheCounterparty1Rule executionAgentOfTheCounterparty1Rule;
    @Inject
    protected ExecutionAgentOfTheCounterparty2DTCCRule executionAgentOfTheCounterparty2DTCCRule;
    @Inject
    protected LevelRule levelRule;
    @Inject
    protected NextFloatingReferenceResetDateLeg1Rule nextFloatingReferenceResetDateLeg1Rule;
    @Inject
    protected NextFloatingReferenceResetDateLeg2Rule nextFloatingReferenceResetDateLeg2Rule;
    @Inject
    protected ReportSubmittingEntityIDRule reportSubmittingEntityIDRule;
    @Inject
    protected ReportingTimestampRule reportingTimestampRule;
    @Inject
    protected SmallScaleBuySideEntityIndicatorRule smallScaleBuySideEntityIndicatorRule;
    @Inject
    protected TechnicalRecordIdRule technicalRecordIdRule;
    @Inject
    protected UniqueTransactionIdentifierProprietaryRule uniqueTransactionIdentifierProprietaryRule;
    @Inject
    protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
    @Inject
    protected ValuationAmountRule valuationAmountRule;
    @Inject
    protected ValuationCurrencyRule valuationCurrencyRule;
    @Inject
    protected ValuationMethodRule valuationMethodRule;
    @Inject
    protected ValuationTimestampRule valuationTimestampRule;

    public ASICValuationReport evaluate(ValuationReportInstruction input) {
        ASICValuationReport output;
        ASICValuationReport.ASICValuationReportBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(ASICValuationReport.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract ASICValuationReport.ASICValuationReportBuilder doEvaluate(ValuationReportInstruction var1);

    public static class ASICValuationReportFunctionDefault
    extends ASICValuationReportFunction {
        @Override
        protected ASICValuationReport.ASICValuationReportBuilder doEvaluate(ValuationReportInstruction input) {
            ASICValuationReport.ASICValuationReportBuilder output = ASICValuationReport.builder();
            return this.assignOutput(output, input);
        }

        protected ASICValuationReport.ASICValuationReportBuilder assignOutput(ASICValuationReport.ASICValuationReportBuilder output, ValuationReportInstruction input) {
            output.setReportingTimestamp(this.reportingTimestampRule.evaluate(input));
            output.setCounterparty1(this.counterparty1Rule.evaluate(input));
            output.setCounterparty2IdentifierTypeOverriddenAsBoolean(this.counterparty2IdentifierTypeRule.evaluate(input));
            output.setCounterparty2(this.counterparty2Rule.evaluate(input));
            output.setValuationAmount(this.valuationAmountRule.evaluate(input));
            output.setValuationCurrency(this.valuationCurrencyRule.evaluate(input));
            output.setValuationTimestamp(this.valuationTimestampRule.evaluate(input));
            output.setValuationMethod(this.valuationMethodRule.evaluate(input));
            output.setDelta(this.deltaRule.evaluate(input));
            output.setActionType(this.actionTypeRule.evaluate(input));
            output.setLevel(this.levelRule.evaluate(input));
            output.setTechnicalRecordIdOverriddenAsString(this.technicalRecordIdRule.evaluate(input));
            output.setReportSubmittingEntityIDOverriddenAsString(this.reportSubmittingEntityIDRule.evaluate(input));
            output.setEntityResponsibleForReportingOverriddenAsString(this.entityResponsibleForReportingRule.evaluate(input));
            output.setNextFloatingReferenceResetDateLeg1(this.nextFloatingReferenceResetDateLeg1Rule.evaluate(input));
            output.setNextFloatingReferenceResetDateLeg2(this.nextFloatingReferenceResetDateLeg2Rule.evaluate(input));
            output.setUniqueTransactionIdentifier(this.uniqueTransactionIdentifierRule.evaluate(input));
            output.setUniqueTransactionIdentifierProprietary(this.uniqueTransactionIdentifierProprietaryRule.evaluate(input));
            output.setExecutionAgentOfTheCounterparty2(this.executionAgentOfTheCounterparty2DTCCRule.evaluate(input));
            output.setExecutionAgentOfTheCounterparty1(this.executionAgentOfTheCounterparty1Rule.evaluate(input));
            output.setSmallScaleBuySideEntityIndicator(this.smallScaleBuySideEntityIndicatorRule.evaluate(input));
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

