/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.functions;

import cdm.base.staticdata.party.Party;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.base.util.party.functions.CounterpartiesForEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.reports.PayoutLeg1Rule;
import drr.standards.iosco.cde.version2.party.functions.ReceiverParty;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=ReceiverPartyLeg1Default.class)
public abstract class ReceiverPartyLeg1
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CounterpartiesForEvent counterpartiesForEvent;
    @Inject
    protected PayoutLeg1Rule payoutLeg1Rule;
    @Inject
    protected ReceiverParty receiverParty;

    public Party evaluate(TransactionReportInstruction transacion) {
        Party party;
        Party.PartyBuilder partyBuilder = this.doEvaluate(transacion);
        if (partyBuilder == null) {
            party = null;
        } else {
            party = partyBuilder.build();
            this.objectValidator.validate(Party.class, (RosettaModelObject)party);
        }
        return party;
    }

    protected abstract Party.PartyBuilder doEvaluate(TransactionReportInstruction var1);

    public static class ReceiverPartyLeg1Default
    extends ReceiverPartyLeg1 {
        @Override
        protected Party.PartyBuilder doEvaluate(TransactionReportInstruction transacion) {
            Party.PartyBuilder party = Party.builder();
            return this.assignOutput(party, transacion);
        }

        protected Party.PartyBuilder assignOutput(Party.PartyBuilder party, TransactionReportInstruction transacion) {
            party = (Party.PartyBuilder)this.toBuilder((RosettaModelObject)this.receiverParty.evaluate(this.payoutLeg1Rule.evaluate(transacion), this.counterpartiesForEvent.evaluate(transacion)));
            return Optional.ofNullable(party).map(o -> o.prune()).orElse(null);
        }
    }
}

