/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.margin.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.margin.CFTCMarginReport;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CFTCMarginReportTypeFormatValidator
implements Validator<CFTCMarginReport> {
    private List<ComparisonResult> getComparisonResults(CFTCMarginReport o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperatorsNullSafe.checkString((String)"counterparty1", (String)o.getCounterparty1(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18,18}[0-9]{2,2}"))), ExpressionOperatorsNullSafe.checkString((String)"counterparty2", (String)o.getCounterparty2(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperatorsNullSafe.checkString((String)"collateralPortfolioCode", (String)o.getCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperatorsNullSafe.checkString((String)"uti", (String)o.getUti(), (int)0, Optional.empty(), Optional.of(Pattern.compile("[A-Z0-9]{18}[0-9]{2}[A-Z0-9  \\:.\\-_]{0,32}"))), ExpressionOperatorsNullSafe.checkNumber((String)"initialMarginPostedByTheCounterparty1PreHaircut", (BigDecimal)o.getInitialMarginPostedByTheCounterparty1PreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"initialMarginPostedByTheCounterparty1PostHaircut", (BigDecimal)o.getInitialMarginPostedByTheCounterparty1PostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"variationMarginPostedByTheCounterparty1PreHaircut", (BigDecimal)o.getVariationMarginPostedByTheCounterparty1PreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"variationMarginPostedByTheCounterparty1PostHaircut", (BigDecimal)o.getVariationMarginPostedByTheCounterparty1PostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"initialMarginCollectedByCounterparty1PreHaircut", (BigDecimal)o.getInitialMarginCollectedByCounterparty1PreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"initialMarginCollectedByCounterparty1PostHaircut", (BigDecimal)o.getInitialMarginCollectedByCounterparty1PostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"variationMarginCollectedByTheCounterparty1PreHaircut", (BigDecimal)o.getVariationMarginCollectedByTheCounterparty1PreHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"variationMarginCollectedByTheCounterparty1PostHaircut", (BigDecimal)o.getVariationMarginCollectedByTheCounterparty1PostHaircut(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"excessCollateralPostedByTheCounterparty1", (BigDecimal)o.getExcessCollateralPostedByTheCounterparty1(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"excessCollateralCollectedByTheCounterparty1", (BigDecimal)o.getExcessCollateralCollectedByTheCounterparty1(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"variationMarginCollateralPortfolioCode", (String)o.getVariationMarginCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperatorsNullSafe.checkString((String)"initialMarginCollateralPortfolioCode", (String)o.getInitialMarginCollateralPortfolioCode(), (int)1, Optional.of(52), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,52}"))), ExpressionOperatorsNullSafe.checkString((String)"counterparty2IdentifierSource", (String)o.getCounterparty2IdentifierSource(), (int)1, Optional.of(4), Optional.empty())});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCMarginReport o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"CFTCMarginReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"CFTCMarginReport", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"CFTCMarginReport", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"CFTCMarginReport", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

