/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.product.functions.IsFixedFloatZeroCouponSwapKnownAmount;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForEvent;
import drr.regulation.cftc.rewrite.trade.functions.IsAllowableActionForCFTC;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;

@ImplementedBy(value=PriceCurrencyRuleDefault.class)
public abstract class PriceCurrencyRule
implements ReportFunction<TransactionReportInstruction, ISOCurrencyCodeEnum> {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsAllowableActionForCFTC isAllowableActionForCFTC;
    @Inject
    protected IsFixedFloatZeroCouponSwapKnownAmount isFixedFloatZeroCouponSwapKnownAmount;
    @Inject
    protected drr.standards.iosco.cde.version2.price.reports.PriceCurrencyRule priceCurrencyRule;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
    @Inject
    protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;

    public ISOCurrencyCodeEnum evaluate(TransactionReportInstruction input) {
        ISOCurrencyCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction var1);

    public static class PriceCurrencyRuleDefault
    extends PriceCurrencyRule {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(TransactionReportInstruction input) {
            ISOCurrencyCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCFTC.evaluate((ReportableEventBase)item.get()));
            MapperS thenArg1 = thenArg0.filterSingleNullSafe(item -> ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_AssetClass_Commodity.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate((ReportableEventBase)item.get()))))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_AssetClass_Equity.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate((ReportableEventBase)item.get())))))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isFixedFloatZeroCouponSwapKnownAmount.evaluate(this.productForEvent.evaluate((ReportableEventBase)item.get()))))).get());
            output = (ISOCurrencyCodeEnum)thenArg1.mapSingleToItem(item -> MapperS.of((Object)this.priceCurrencyRule.evaluate((TransactionReportInstructionBase)item.get()))).get();
            return output;
        }
    }
}

