/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.trade.CFTCPart43TransactionReport;
import drr.standards.iosco.upi.AnnaDsbAssetClassEnum;
import drr.standards.iosco.upi.AnnaDsbInstrumentTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CFTCPart43TransactionReportNotionalAmountCondition")
@ImplementedBy(value=Default.class)
public interface CFTCPart43TransactionReportNotionalAmountCondition
extends Validator<CFTCPart43TransactionReport> {
    public static final String NAME = "CFTCPart43TransactionReportNotionalAmountCondition";
    public static final String DEFINITION = "if (nonReportable -> postUpiData -> Header -> AssetClass = Foreign_Exchange or dtccAdditionalFields -> primaryAssetClass = ForeignExchange) and (nonReportable -> instrumentType = Option or nonReportable -> postUpiData -> Header -> InstrumentType = Option) then ((if leg1 -> notionalAmount exists and (callAmount exists and putAmount exists) then leg1 -> notionalAmount = callAmount or leg1 -> notionalAmount = putAmount) and (if leg2 -> notionalAmount exists and (callAmount exists and putAmount exists) then leg2 -> notionalAmount = callAmount or leg2 -> notionalAmount = putAmount))";

    public static class NoOp
    implements CFTCPart43TransactionReportNotionalAmountCondition {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CFTCPart43TransactionReportNotionalAmountCondition {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
            ComparisonResult result = this.executeDataRule(cFTCPart43TransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CFTCPart43TransactionReportNotionalAmountCondition.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CFTCPart43TransactionReport", (RosettaPath)path, (String)CFTCPart43TransactionReportNotionalAmountCondition.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CFTCPart43TransactionReportNotionalAmountCondition.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CFTCPart43TransactionReport", (RosettaPath)path, (String)CFTCPart43TransactionReportNotionalAmountCondition.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CFTCPart43TransactionReport cFTCPart43TransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getNonReportable", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getNonReportable()).map("getPostUpiData", cFTCNonReportablePart43 -> cFTCNonReportablePart43.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), (Mapper)MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.FOREIGN_EXCHANGE)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getDtccAdditionalFields", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getDtccAdditionalFields()).map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), (Mapper)MapperS.of((Object)AssetClassEnum.FOREIGN_EXCHANGE), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getNonReportable", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getNonReportable()).map("getInstrumentType", cFTCNonReportablePart43 -> cFTCNonReportablePart43.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getNonReportable", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getNonReportable()).map("getPostUpiData", cFTCNonReportablePart43 -> cFTCNonReportablePart43.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ComparisonResult ifThenElseResult0 = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getLeg1()).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getCallAmount", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCallAmount())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getPutAmount", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getPutAmount())))).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getLeg1()).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()), (Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getCallAmount", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCallAmount()), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getLeg1()).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()), (Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getPutAmount", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getPutAmount()), (CardinalityOperator)CardinalityOperator.All)) : ComparisonResult.ofEmpty();
                    ComparisonResult ifThenElseResult1 = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getLeg2()).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getCallAmount", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCallAmount())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getPutAmount", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getPutAmount())))).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getLeg2()).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()), (Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getCallAmount", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCallAmount()), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getLeg2()).map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()), (Mapper)MapperS.of((Object)cFTCPart43TransactionReport).map("getPutAmount", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getPutAmount()), (CardinalityOperator)CardinalityOperator.All)) : ComparisonResult.ofEmpty();
                    return ifThenElseResult0.andNullSafe(ifThenElseResult1);
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

