/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.trade.CFTCPart45TransactionReport;
import drr.standards.iosco.upi.AnnaDsbAssetClassEnum;
import drr.standards.iosco.upi.AnnaDsbInstrumentTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CFTCPart45TransactionReportNotionalCurrencyCondition")
@ImplementedBy(value=Default.class)
public interface CFTCPart45TransactionReportNotionalCurrencyCondition
extends Validator<CFTCPart45TransactionReport> {
    public static final String NAME = "CFTCPart45TransactionReportNotionalCurrencyCondition";
    public static final String DEFINITION = "if (nonReportable -> postUpiData -> Header -> AssetClass = Foreign_Exchange or dtccAdditionalFields -> primaryAssetClass = ForeignExchange) and (nonReportable -> instrumentType = Option or nonReportable -> postUpiData -> Header -> InstrumentType = Option) then ((if leg1 -> notionalCurrency exists and (callCurrency exists and putCurrency exists) then leg1 -> notionalCurrency = callCurrency or leg1 -> notionalCurrency = putCurrency) and (if leg2 -> notionalCurrency exists and (callCurrency exists and putCurrency exists) then leg2 -> notionalCurrency = callCurrency or leg2 -> notionalCurrency = putCurrency))";

    public static class NoOp
    implements CFTCPart45TransactionReportNotionalCurrencyCondition {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CFTCPart45TransactionReportNotionalCurrencyCondition {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            ComparisonResult result = this.executeDataRule(cFTCPart45TransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CFTCPart45TransactionReportNotionalCurrencyCondition.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CFTCPart45TransactionReport", (RosettaPath)path, (String)CFTCPart45TransactionReportNotionalCurrencyCondition.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CFTCPart45TransactionReportNotionalCurrencyCondition.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CFTCPart45TransactionReport", (RosettaPath)path, (String)CFTCPart45TransactionReportNotionalCurrencyCondition.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getNonReportable", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNonReportable()).map("getPostUpiData", cFTCNonReportablePart45 -> cFTCNonReportablePart45.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), (Mapper)MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.FOREIGN_EXCHANGE)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getDtccAdditionalFields", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getDtccAdditionalFields()).map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), (Mapper)MapperS.of((Object)AssetClassEnum.FOREIGN_EXCHANGE), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getNonReportable", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNonReportable()).map("getInstrumentType", cFTCNonReportablePart45 -> cFTCNonReportablePart45.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getNonReportable", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNonReportable()).map("getPostUpiData", cFTCNonReportablePart45 -> cFTCNonReportablePart45.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getInstrumentType", annaDsbHeader -> annaDsbHeader.getInstrumentType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ComparisonResult ifThenElseResult0 = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).map("getNotionalCurrency", cFTCPart45Leg -> cFTCPart45Leg.getNotionalCurrency())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getCallCurrency", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCallCurrency())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getPutCurrency", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPutCurrency())))).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).map("getNotionalCurrency", cFTCPart45Leg -> cFTCPart45Leg.getNotionalCurrency()), (Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getCallCurrency", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCallCurrency()), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).map("getNotionalCurrency", cFTCPart45Leg -> cFTCPart45Leg.getNotionalCurrency()), (Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getPutCurrency", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPutCurrency()), (CardinalityOperator)CardinalityOperator.All)) : ComparisonResult.ofEmpty();
                    ComparisonResult ifThenElseResult1 = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).map("getNotionalCurrency", cFTCPart45Leg -> cFTCPart45Leg.getNotionalCurrency())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getCallCurrency", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCallCurrency())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getPutCurrency", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPutCurrency())))).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).map("getNotionalCurrency", cFTCPart45Leg -> cFTCPart45Leg.getNotionalCurrency()), (Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getCallCurrency", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCallCurrency()), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).map("getNotionalCurrency", cFTCPart45Leg -> cFTCPart45Leg.getNotionalCurrency()), (Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getPutCurrency", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPutCurrency()), (CardinalityOperator)CardinalityOperator.All)) : ComparisonResult.ofEmpty();
                    return ifThenElseResult0.andNullSafe(ifThenElseResult1);
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

