/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.meta.CSAPartyInformationMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CSAPartyInformation", builder=CSAPartyInformationBuilderImpl.class, version="7.0.0-dev.85")
@RuneDataType(value="CSAPartyInformation", model="drr", builder=CSAPartyInformationBuilderImpl.class, version="7.0.0-dev.85")
public interface CSAPartyInformation
extends RosettaModelObject {
    public static final CSAPartyInformationMeta metaData = new CSAPartyInformationMeta();

    public Boolean getNonReportedTradePortfolio();

    public Boolean getLocalCounterparty();

    public CSAPartyInformation build();

    public CSAPartyInformationBuilder toBuilder();

    public static CSAPartyInformationBuilder builder() {
        return new CSAPartyInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends CSAPartyInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CSAPartyInformation> getType() {
        return CSAPartyInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("nonReportedTradePortfolio"), Boolean.class, (Object)this.getNonReportedTradePortfolio(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("localCounterparty"), Boolean.class, (Object)this.getLocalCounterparty(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CSAPartyInformationBuilderImpl
    implements CSAPartyInformationBuilder {
        protected Boolean nonReportedTradePortfolio;
        protected Boolean localCounterparty;

        @Override
        @RosettaAttribute(value="nonReportedTradePortfolio")
        @RuneAttribute(value="nonReportedTradePortfolio")
        public Boolean getNonReportedTradePortfolio() {
            return this.nonReportedTradePortfolio;
        }

        @Override
        @RosettaAttribute(value="localCounterparty")
        @RuneAttribute(value="localCounterparty")
        public Boolean getLocalCounterparty() {
            return this.localCounterparty;
        }

        @Override
        @RosettaAttribute(value="nonReportedTradePortfolio")
        @RuneAttribute(value="nonReportedTradePortfolio")
        public CSAPartyInformationBuilder setNonReportedTradePortfolio(Boolean _nonReportedTradePortfolio) {
            this.nonReportedTradePortfolio = _nonReportedTradePortfolio == null ? null : _nonReportedTradePortfolio;
            return this;
        }

        @Override
        @RosettaAttribute(value="localCounterparty")
        @RuneAttribute(value="localCounterparty")
        public CSAPartyInformationBuilder setLocalCounterparty(Boolean _localCounterparty) {
            this.localCounterparty = _localCounterparty == null ? null : _localCounterparty;
            return this;
        }

        @Override
        public CSAPartyInformation build() {
            return new CSAPartyInformationImpl(this);
        }

        @Override
        public CSAPartyInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public CSAPartyInformationBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getNonReportedTradePortfolio() != null) {
                return true;
            }
            return this.getLocalCounterparty() != null;
        }

        public CSAPartyInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CSAPartyInformationBuilder o = (CSAPartyInformationBuilder)other;
            merger.mergeBasic((Object)this.getNonReportedTradePortfolio(), (Object)o.getNonReportedTradePortfolio(), this::setNonReportedTradePortfolio, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLocalCounterparty(), (Object)o.getLocalCounterparty(), this::setLocalCounterparty, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CSAPartyInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.nonReportedTradePortfolio, _that.getNonReportedTradePortfolio())) {
                return false;
            }
            return Objects.equals(this.localCounterparty, _that.getLocalCounterparty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.nonReportedTradePortfolio != null ? this.nonReportedTradePortfolio.hashCode() : 0);
            _result = 31 * _result + (this.localCounterparty != null ? this.localCounterparty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CSAPartyInformationBuilder {nonReportedTradePortfolio=" + this.nonReportedTradePortfolio + ", localCounterparty=" + this.localCounterparty + "}";
        }
    }

    public static interface CSAPartyInformationBuilder
    extends CSAPartyInformation,
    RosettaModelObjectBuilder {
        public CSAPartyInformationBuilder setNonReportedTradePortfolio(Boolean var1);

        public CSAPartyInformationBuilder setLocalCounterparty(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("nonReportedTradePortfolio"), Boolean.class, (Object)this.getNonReportedTradePortfolio(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("localCounterparty"), Boolean.class, (Object)this.getLocalCounterparty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public CSAPartyInformationBuilder prune();
    }

    public static class CSAPartyInformationImpl
    implements CSAPartyInformation {
        private final Boolean nonReportedTradePortfolio;
        private final Boolean localCounterparty;

        protected CSAPartyInformationImpl(CSAPartyInformationBuilder builder) {
            this.nonReportedTradePortfolio = builder.getNonReportedTradePortfolio();
            this.localCounterparty = builder.getLocalCounterparty();
        }

        @Override
        @RosettaAttribute(value="nonReportedTradePortfolio")
        @RuneAttribute(value="nonReportedTradePortfolio")
        public Boolean getNonReportedTradePortfolio() {
            return this.nonReportedTradePortfolio;
        }

        @Override
        @RosettaAttribute(value="localCounterparty")
        @RuneAttribute(value="localCounterparty")
        public Boolean getLocalCounterparty() {
            return this.localCounterparty;
        }

        @Override
        public CSAPartyInformation build() {
            return this;
        }

        @Override
        public CSAPartyInformationBuilder toBuilder() {
            CSAPartyInformationBuilder builder = CSAPartyInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CSAPartyInformationBuilder builder) {
            Optional.ofNullable(this.getNonReportedTradePortfolio()).ifPresent(builder::setNonReportedTradePortfolio);
            Optional.ofNullable(this.getLocalCounterparty()).ifPresent(builder::setLocalCounterparty);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CSAPartyInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.nonReportedTradePortfolio, _that.getNonReportedTradePortfolio())) {
                return false;
            }
            return Objects.equals(this.localCounterparty, _that.getLocalCounterparty());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.nonReportedTradePortfolio != null ? this.nonReportedTradePortfolio.hashCode() : 0);
            _result = 31 * _result + (this.localCounterparty != null ? this.localCounterparty.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CSAPartyInformation {nonReportedTradePortfolio=" + this.nonReportedTradePortfolio + ", localCounterparty=" + this.localCounterparty + "}";
        }
    }
}

