/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import cdm.base.staticdata.party.Address;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.meta.ExecutingEntityMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ExecutingEntity", builder=ExecutingEntityBuilderImpl.class, version="7.0.0-dev.85")
@RuneDataType(value="ExecutingEntity", model="drr", builder=ExecutingEntityBuilderImpl.class, version="7.0.0-dev.85")
public interface ExecutingEntity
extends RosettaModelObject {
    public static final ExecutingEntityMeta metaData = new ExecutingEntityMeta();

    public Boolean getIsInvestmentFirm();

    public Address getAddressOfBranch();

    public Address getAddressOfIncorporation();

    public ExecutingEntity build();

    public ExecutingEntityBuilder toBuilder();

    public static ExecutingEntityBuilder builder() {
        return new ExecutingEntityBuilderImpl();
    }

    default public RosettaMetaData<? extends ExecutingEntity> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExecutingEntity> getType() {
        return ExecutingEntity.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("isInvestmentFirm"), Boolean.class, (Object)this.getIsInvestmentFirm(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("addressOfBranch"), processor, Address.class, (RosettaModelObject)this.getAddressOfBranch(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("addressOfIncorporation"), processor, Address.class, (RosettaModelObject)this.getAddressOfIncorporation(), new AttributeMeta[0]);
    }

    public static class ExecutingEntityBuilderImpl
    implements ExecutingEntityBuilder {
        protected Boolean isInvestmentFirm;
        protected Address.AddressBuilder addressOfBranch;
        protected Address.AddressBuilder addressOfIncorporation;

        @Override
        @RosettaAttribute(value="isInvestmentFirm", isRequired=true)
        @RuneAttribute(value="isInvestmentFirm", isRequired=true)
        public Boolean getIsInvestmentFirm() {
            return this.isInvestmentFirm;
        }

        @Override
        @RosettaAttribute(value="addressOfBranch", isRequired=true)
        @RuneAttribute(value="addressOfBranch", isRequired=true)
        public Address.AddressBuilder getAddressOfBranch() {
            return this.addressOfBranch;
        }

        @Override
        public Address.AddressBuilder getOrCreateAddressOfBranch() {
            Address.AddressBuilder result = this.addressOfBranch != null ? this.addressOfBranch : (this.addressOfBranch = Address.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="addressOfIncorporation", isRequired=true)
        @RuneAttribute(value="addressOfIncorporation", isRequired=true)
        public Address.AddressBuilder getAddressOfIncorporation() {
            return this.addressOfIncorporation;
        }

        @Override
        public Address.AddressBuilder getOrCreateAddressOfIncorporation() {
            Address.AddressBuilder result = this.addressOfIncorporation != null ? this.addressOfIncorporation : (this.addressOfIncorporation = Address.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="isInvestmentFirm", isRequired=true)
        @RuneAttribute(value="isInvestmentFirm", isRequired=true)
        public ExecutingEntityBuilder setIsInvestmentFirm(Boolean _isInvestmentFirm) {
            this.isInvestmentFirm = _isInvestmentFirm == null ? null : _isInvestmentFirm;
            return this;
        }

        @Override
        @RosettaAttribute(value="addressOfBranch", isRequired=true)
        @RuneAttribute(value="addressOfBranch", isRequired=true)
        public ExecutingEntityBuilder setAddressOfBranch(Address _addressOfBranch) {
            this.addressOfBranch = _addressOfBranch == null ? null : _addressOfBranch.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="addressOfIncorporation", isRequired=true)
        @RuneAttribute(value="addressOfIncorporation", isRequired=true)
        public ExecutingEntityBuilder setAddressOfIncorporation(Address _addressOfIncorporation) {
            this.addressOfIncorporation = _addressOfIncorporation == null ? null : _addressOfIncorporation.toBuilder();
            return this;
        }

        @Override
        public ExecutingEntity build() {
            return new ExecutingEntityImpl(this);
        }

        @Override
        public ExecutingEntityBuilder toBuilder() {
            return this;
        }

        @Override
        public ExecutingEntityBuilder prune() {
            if (this.addressOfBranch != null && !this.addressOfBranch.prune().hasData()) {
                this.addressOfBranch = null;
            }
            if (this.addressOfIncorporation != null && !this.addressOfIncorporation.prune().hasData()) {
                this.addressOfIncorporation = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getIsInvestmentFirm() != null) {
                return true;
            }
            if (this.getAddressOfBranch() != null && this.getAddressOfBranch().hasData()) {
                return true;
            }
            return this.getAddressOfIncorporation() != null && this.getAddressOfIncorporation().hasData();
        }

        public ExecutingEntityBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ExecutingEntityBuilder o = (ExecutingEntityBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAddressOfBranch(), (RosettaModelObjectBuilder)o.getAddressOfBranch(), this::setAddressOfBranch);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAddressOfIncorporation(), (RosettaModelObjectBuilder)o.getAddressOfIncorporation(), this::setAddressOfIncorporation);
            merger.mergeBasic((Object)this.getIsInvestmentFirm(), (Object)o.getIsInvestmentFirm(), this::setIsInvestmentFirm, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExecutingEntity _that = this.getType().cast(o);
            if (!Objects.equals(this.isInvestmentFirm, _that.getIsInvestmentFirm())) {
                return false;
            }
            if (!Objects.equals(this.addressOfBranch, _that.getAddressOfBranch())) {
                return false;
            }
            return Objects.equals(this.addressOfIncorporation, _that.getAddressOfIncorporation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.isInvestmentFirm != null ? this.isInvestmentFirm.hashCode() : 0);
            _result = 31 * _result + (this.addressOfBranch != null ? this.addressOfBranch.hashCode() : 0);
            _result = 31 * _result + (this.addressOfIncorporation != null ? this.addressOfIncorporation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExecutingEntityBuilder {isInvestmentFirm=" + this.isInvestmentFirm + ", addressOfBranch=" + String.valueOf(this.addressOfBranch) + ", addressOfIncorporation=" + String.valueOf(this.addressOfIncorporation) + "}";
        }
    }

    public static interface ExecutingEntityBuilder
    extends ExecutingEntity,
    RosettaModelObjectBuilder {
        public Address.AddressBuilder getOrCreateAddressOfBranch();

        public Address.AddressBuilder getAddressOfBranch();

        public Address.AddressBuilder getOrCreateAddressOfIncorporation();

        public Address.AddressBuilder getAddressOfIncorporation();

        public ExecutingEntityBuilder setIsInvestmentFirm(Boolean var1);

        public ExecutingEntityBuilder setAddressOfBranch(Address var1);

        public ExecutingEntityBuilder setAddressOfIncorporation(Address var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("isInvestmentFirm"), Boolean.class, (Object)this.getIsInvestmentFirm(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("addressOfBranch"), processor, Address.AddressBuilder.class, (RosettaModelObjectBuilder)this.getAddressOfBranch(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("addressOfIncorporation"), processor, Address.AddressBuilder.class, (RosettaModelObjectBuilder)this.getAddressOfIncorporation(), new AttributeMeta[0]);
        }

        public ExecutingEntityBuilder prune();
    }

    public static class ExecutingEntityImpl
    implements ExecutingEntity {
        private final Boolean isInvestmentFirm;
        private final Address addressOfBranch;
        private final Address addressOfIncorporation;

        protected ExecutingEntityImpl(ExecutingEntityBuilder builder) {
            this.isInvestmentFirm = builder.getIsInvestmentFirm();
            this.addressOfBranch = Optional.ofNullable(builder.getAddressOfBranch()).map(f -> f.build()).orElse(null);
            this.addressOfIncorporation = Optional.ofNullable(builder.getAddressOfIncorporation()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="isInvestmentFirm", isRequired=true)
        @RuneAttribute(value="isInvestmentFirm", isRequired=true)
        public Boolean getIsInvestmentFirm() {
            return this.isInvestmentFirm;
        }

        @Override
        @RosettaAttribute(value="addressOfBranch", isRequired=true)
        @RuneAttribute(value="addressOfBranch", isRequired=true)
        public Address getAddressOfBranch() {
            return this.addressOfBranch;
        }

        @Override
        @RosettaAttribute(value="addressOfIncorporation", isRequired=true)
        @RuneAttribute(value="addressOfIncorporation", isRequired=true)
        public Address getAddressOfIncorporation() {
            return this.addressOfIncorporation;
        }

        @Override
        public ExecutingEntity build() {
            return this;
        }

        @Override
        public ExecutingEntityBuilder toBuilder() {
            ExecutingEntityBuilder builder = ExecutingEntity.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExecutingEntityBuilder builder) {
            Optional.ofNullable(this.getIsInvestmentFirm()).ifPresent(builder::setIsInvestmentFirm);
            Optional.ofNullable(this.getAddressOfBranch()).ifPresent(builder::setAddressOfBranch);
            Optional.ofNullable(this.getAddressOfIncorporation()).ifPresent(builder::setAddressOfIncorporation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ExecutingEntity _that = this.getType().cast(o);
            if (!Objects.equals(this.isInvestmentFirm, _that.getIsInvestmentFirm())) {
                return false;
            }
            if (!Objects.equals(this.addressOfBranch, _that.getAddressOfBranch())) {
                return false;
            }
            return Objects.equals(this.addressOfIncorporation, _that.getAddressOfIncorporation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.isInvestmentFirm != null ? this.isInvestmentFirm.hashCode() : 0);
            _result = 31 * _result + (this.addressOfBranch != null ? this.addressOfBranch.hashCode() : 0);
            _result = 31 * _result + (this.addressOfIncorporation != null ? this.addressOfIncorporation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ExecutingEntity {isInvestmentFirm=" + this.isInvestmentFirm + ", addressOfBranch=" + String.valueOf(this.addressOfBranch) + ", addressOfIncorporation=" + String.valueOf(this.addressOfIncorporation) + "}";
        }
    }
}

