/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneIgnore;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import drr.base.margin.CollateralDetails;
import drr.base.trade.ReportableInformationBase;
import drr.regulation.common.RegimeReportingSide;
import drr.regulation.common.ReportableCollateral;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.meta.RegimeReportableCollateralMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegimeReportableCollateral", builder=RegimeReportableCollateralBuilderImpl.class, version="7.0.0-dev.85")
@RuneDataType(value="RegimeReportableCollateral", model="drr", builder=RegimeReportableCollateralBuilderImpl.class, version="7.0.0-dev.85")
public interface RegimeReportableCollateral
extends ReportableCollateral {
    public static final RegimeReportableCollateralMeta metaData = new RegimeReportableCollateralMeta();

    public List<? extends RegimeReportingSide> getRegimeReportingSide();

    @Override
    public RegimeReportableCollateral build();

    @Override
    public RegimeReportableCollateralBuilder toBuilder();

    public static RegimeReportableCollateralBuilder builder() {
        return new RegimeReportableCollateralBuilderImpl();
    }

    default public RosettaMetaData<? extends RegimeReportableCollateral> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegimeReportableCollateral> getType() {
        return RegimeReportableCollateral.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("collateralDetails"), processor, CollateralDetails.class, this.getCollateralDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.class, this.getReportableInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("regimeReportingSide"), processor, RegimeReportingSide.class, this.getRegimeReportingSide(), new AttributeMeta[0]);
    }

    public static class RegimeReportableCollateralBuilderImpl
    extends ReportableCollateral.ReportableCollateralBuilderImpl
    implements RegimeReportableCollateralBuilder {
        protected List<RegimeReportingSide.RegimeReportingSideBuilder> regimeReportingSide = new ArrayList<RegimeReportingSide.RegimeReportingSideBuilder>();

        @Override
        @RosettaAttribute(value="regimeReportingSide")
        @RuneAttribute(value="regimeReportingSide")
        public List<? extends RegimeReportingSide.RegimeReportingSideBuilder> getRegimeReportingSide() {
            return this.regimeReportingSide;
        }

        @Override
        public RegimeReportingSide.RegimeReportingSideBuilder getOrCreateRegimeReportingSide(int index) {
            if (this.regimeReportingSide == null) {
                this.regimeReportingSide = new ArrayList<RegimeReportingSide.RegimeReportingSideBuilder>();
            }
            return (RegimeReportingSide.RegimeReportingSideBuilder)this.getIndex(this.regimeReportingSide, index, () -> {
                RegimeReportingSide.RegimeReportingSideBuilder newRegimeReportingSide = RegimeReportingSide.builder();
                return newRegimeReportingSide;
            });
        }

        @Override
        @RosettaAttribute(value="collateralDetails")
        @RuneAttribute(value="collateralDetails")
        public RegimeReportableCollateralBuilder setCollateralDetails(CollateralDetails _collateralDetails) {
            this.collateralDetails = _collateralDetails == null ? null : _collateralDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportableInformation", isRequired=true)
        @RuneAttribute(value="reportableInformation", isRequired=true)
        public RegimeReportableCollateralBuilder setReportableInformation(ReportableInformation _reportableInformation) {
            this.reportableInformation = _reportableInformation == null ? null : _reportableInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public RegimeReportableCollateralBuilder setReportableInformation(ReportableInformationBase _reportableInformation) {
            ReportableInformation ifThenElseResult = _reportableInformation == null ? null : (_reportableInformation instanceof ReportableInformation ? (ReportableInformation)ReportableInformation.class.cast(_reportableInformation) : null);
            return this.setReportableInformation(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="regimeReportingSide")
        @RuneAttribute(value="regimeReportingSide")
        public RegimeReportableCollateralBuilder addRegimeReportingSide(RegimeReportingSide _regimeReportingSide) {
            if (_regimeReportingSide != null) {
                this.regimeReportingSide.add(_regimeReportingSide.toBuilder());
            }
            return this;
        }

        @Override
        public RegimeReportableCollateralBuilder addRegimeReportingSide(RegimeReportingSide _regimeReportingSide, int idx) {
            this.getIndex(this.regimeReportingSide, idx, () -> _regimeReportingSide.toBuilder());
            return this;
        }

        @Override
        public RegimeReportableCollateralBuilder addRegimeReportingSide(List<? extends RegimeReportingSide> regimeReportingSides) {
            if (regimeReportingSides != null) {
                for (RegimeReportingSide regimeReportingSide : regimeReportingSides) {
                    this.regimeReportingSide.add(regimeReportingSide.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="regimeReportingSide")
        public RegimeReportableCollateralBuilder setRegimeReportingSide(List<? extends RegimeReportingSide> regimeReportingSides) {
            this.regimeReportingSide = regimeReportingSides == null ? new ArrayList<RegimeReportingSide.RegimeReportingSideBuilder>() : (List)regimeReportingSides.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public RegimeReportableCollateral build() {
            return new RegimeReportableCollateralImpl(this);
        }

        @Override
        public RegimeReportableCollateralBuilder toBuilder() {
            return this;
        }

        @Override
        public RegimeReportableCollateralBuilder prune() {
            super.prune();
            this.regimeReportingSide = this.regimeReportingSide.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getRegimeReportingSide() != null && this.getRegimeReportingSide().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public RegimeReportableCollateralBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RegimeReportableCollateralBuilder o = (RegimeReportableCollateralBuilder)other;
            merger.mergeRosetta(this.getRegimeReportingSide(), o.getRegimeReportingSide(), this::getOrCreateRegimeReportingSide);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegimeReportableCollateral _that = (RegimeReportableCollateral)this.getType().cast(o);
            return ListEquals.listEquals(this.regimeReportingSide, _that.getRegimeReportingSide());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.regimeReportingSide != null ? this.regimeReportingSide.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegimeReportableCollateralBuilder {regimeReportingSide=" + String.valueOf(this.regimeReportingSide) + "} " + super.toString();
        }
    }

    public static interface RegimeReportableCollateralBuilder
    extends RegimeReportableCollateral,
    ReportableCollateral.ReportableCollateralBuilder {
        public RegimeReportingSide.RegimeReportingSideBuilder getOrCreateRegimeReportingSide(int var1);

        public List<? extends RegimeReportingSide.RegimeReportingSideBuilder> getRegimeReportingSide();

        @Override
        public RegimeReportableCollateralBuilder setCollateralDetails(CollateralDetails var1);

        @Override
        public RegimeReportableCollateralBuilder setReportableInformation(ReportableInformationBase var1);

        @Override
        public RegimeReportableCollateralBuilder setReportableInformation(ReportableInformation var1);

        public RegimeReportableCollateralBuilder addRegimeReportingSide(RegimeReportingSide var1);

        public RegimeReportableCollateralBuilder addRegimeReportingSide(RegimeReportingSide var1, int var2);

        public RegimeReportableCollateralBuilder addRegimeReportingSide(List<? extends RegimeReportingSide> var1);

        public RegimeReportableCollateralBuilder setRegimeReportingSide(List<? extends RegimeReportingSide> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("collateralDetails"), processor, CollateralDetails.CollateralDetailsBuilder.class, (RosettaModelObjectBuilder)this.getCollateralDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.ReportableInformationBuilder.class, (RosettaModelObjectBuilder)this.getReportableInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("regimeReportingSide"), processor, RegimeReportingSide.RegimeReportingSideBuilder.class, this.getRegimeReportingSide(), new AttributeMeta[0]);
        }

        @Override
        public RegimeReportableCollateralBuilder prune();
    }

    public static class RegimeReportableCollateralImpl
    extends ReportableCollateral.ReportableCollateralImpl
    implements RegimeReportableCollateral {
        private final List<? extends RegimeReportingSide> regimeReportingSide;

        protected RegimeReportableCollateralImpl(RegimeReportableCollateralBuilder builder) {
            super(builder);
            this.regimeReportingSide = Optional.ofNullable(builder.getRegimeReportingSide()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="regimeReportingSide")
        @RuneAttribute(value="regimeReportingSide")
        public List<? extends RegimeReportingSide> getRegimeReportingSide() {
            return this.regimeReportingSide;
        }

        @Override
        public RegimeReportableCollateral build() {
            return this;
        }

        @Override
        public RegimeReportableCollateralBuilder toBuilder() {
            RegimeReportableCollateralBuilder builder = RegimeReportableCollateral.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegimeReportableCollateralBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getRegimeReportingSide()).ifPresent(builder::setRegimeReportingSide);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegimeReportableCollateral _that = (RegimeReportableCollateral)this.getType().cast(o);
            return ListEquals.listEquals(this.regimeReportingSide, _that.getRegimeReportingSide());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.regimeReportingSide != null ? this.regimeReportingSide.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegimeReportableCollateral {regimeReportingSide=" + String.valueOf(this.regimeReportingSide) + "} " + super.toString();
        }
    }
}

