/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.emir;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneIgnore;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.base.trade.basket.BasketConstituentsReport;
import drr.base.trade.payment.OtherPayment;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.PricePeriod;
import drr.regulation.common.ClearingAccountOriginEnum;
import drr.regulation.common.ClearingExceptionsAndExemptionsEnum;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.Counterparty2IdentifierEnum;
import drr.regulation.common.ReportableDelivery;
import drr.regulation.common.emir.meta.EMIRTransactionReportMeta;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.CommonTransactionReport;
import drr.regulation.common.trade.NonReportable;
import drr.regulation.common.trade.contract.MasterAgreementEnum;
import drr.regulation.common.trade.party.NatureOfCounterpartyEnum;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier;
import drr.regulation.common.trade.underlier.UnderlyingIdentificationTypeEnum;
import drr.standards.iosco.cde.version1.LegV1;
import drr.standards.iosco.cde.version2.LegV2;
import drr.standards.iosco.cde.version3.Leg;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.ClearingObligationEnum;
import drr.standards.iso.ConfirmationEnum;
import drr.standards.iso.DeliveryTypeEnum;
import drr.standards.iso.Direction1Enum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EnergyLoadType1Code;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.IndexEnum;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.RiskReductionTechniqueEnum;
import drr.standards.iso.SeniorityEnum;
import drr.standards.iso.TradingCapacity7Code;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="EMIRTransactionReport", builder=EMIRTransactionReportBuilderImpl.class, version="7.0.0-dev.85")
@RuneDataType(value="EMIRTransactionReport", model="drr", builder=EMIRTransactionReportBuilderImpl.class, version="7.0.0-dev.85")
public interface EMIRTransactionReport
extends CommonTransactionReport {
    public static final EMIRTransactionReportMeta metaData = new EMIRTransactionReportMeta();

    @Override
    public CommonContractType getContractType();

    @Override
    public CommonAssetClass getAssetClass();

    @Override
    public ClearedEnum getCleared();

    @Override
    public MasterAgreementEnum getMasterAgreementType();

    @Override
    public ZonedDateTime getExecutionTimestamp();

    @Override
    public Date getEffectiveDate();

    @Override
    public DeliveryTypeEnum getDeliveryType();

    public String getOtherMasterAgreementType();

    public String getCollateralPortfolioCode();

    public String getPtrrId();

    public Boolean getClearingThresholdOfCounterparty1();

    public Boolean getClearingThresholdOfCounterparty2();

    public Boolean getReportingObligationOfTheCounterparty2();

    public Boolean getDirectlyLinkedToCommercialActivityOrTreasuryFinancing();

    public String getReportTrackingNumber();

    public String getIsin();

    public String getProductClassification();

    public List<IndexEnum> getIndicatorOfTheUnderlyingIndex();

    public ClearingObligationEnum getClearingObligation();

    public Boolean getPtrr();

    public RiskReductionTechniqueEnum getTypeOfPTRRTechnique();

    public String getPtrrServiceProvider();

    public String getVenueOfExecution();

    public BigDecimal getForwardExchangeRate();

    public List<String> getDeliveryPoint();

    public String getInterconnectionPoint();

    public EnergyLoadType1Code getLoadType();

    public List<? extends ReportableDelivery> getDeliveryReport();

    public Boolean getTranche();

    public Date getEventDate();

    @Override
    public EMIRTransactionReport build();

    @Override
    public EMIRTransactionReportBuilder toBuilder();

    public static EMIRTransactionReportBuilder builder() {
        return new EMIRTransactionReportBuilderImpl();
    }

    default public RosettaMetaData<? extends EMIRTransactionReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EMIRTransactionReport> getType() {
        return EMIRTransactionReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, (Object)this.getBuyerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, (Object)this.getSellerIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, (Object)this.getCleared(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, (Object)this.getConfirmed(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.class, this.getPriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("price"), processor, PriceFormat.class, this.getPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, (Object)this.getPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.class, this.getPackageTransactionPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.class, this.getPackageTransactionSpread(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.class, this.getStrikePrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, (Object)this.getStrikePriceNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, (Object)this.getStrikePriceCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, (Object)this.getDirection1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, this.getBasketConstituents(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.class, this.getOtherPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leg1"), processor, CommonLeg.class, this.getLeg1(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leg2"), processor, CommonLeg.class, this.getLeg2(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, (Object)this.getUnderlyingAssetPriceSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, (Object)this.getCryptoAssetUnderlyingIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, (Object)this.getEventType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, (Object)this.getConfirmationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, (Object)this.getBookingLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, (Object)this.getTraderLocation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, (Object)this.getDeliveryType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, (Object)this.getExecutionAgentCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentCounterparty2"), String.class, (Object)this.getExecutionAgentCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("natureOfCounterparty1"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("natureOfCounterparty2"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, this.getCorporateSectorOfTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, this.getCorporateSectorOfTheCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, (Object)this.getCountryOfTheCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, (Object)this.getTradingCapacity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("brokerID"), String.class, (Object)this.getBrokerID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, (Object)this.getContractType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, (Object)this.getAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, (Object)this.getEmbeddedOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("masterAgreementType"), MasterAgreementEnum.class, (Object)this.getMasterAgreementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, (Object)this.getMasterAgreementVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, (Object)this.getSecondaryTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("intragroup"), Boolean.class, (Object)this.getIntragroup(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, (Object)this.getNonStandardizedTermIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, (Object)this.getAmendmentIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, (Object)this.getUnderlyingIdentification(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("underlyingIdentificationType"), UnderlyingIdentificationTypeEnum.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, (Object)this.getNameOfTheUnderlyingIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("swapLinkID"), String.class, (Object)this.getSwapLinkID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, (Object)this.getPackageIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, (Object)this.getCustomBasketIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, (Object)this.getPriorUTIProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, (Object)this.getClearingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, (Object)this.getClearingAccountOrigin(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, (Object)this.getClearingReceiptTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, (Object)this.getOriginalSwapUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, (Object)this.getSubsequentPositionUTI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, (Object)this.getOriginalSwapSDRIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priorUSI"), String.class, (Object)this.getPriorUSI(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, (Object)this.getNewSDRIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("referenceEntity"), String.class, (Object)this.getReferenceEntity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, (Object)this.getSeniority(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("series"), Integer.class, (Object)this.getSeries(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("seriesVersion"), Integer.class, (Object)this.getSeriesVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("baseProduct"), String.class, (Object)this.getBaseProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("subProduct"), String.class, (Object)this.getSubProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, (Object)this.getFurtherSubProduct(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.class, this.getBarrier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("nonReportable"), processor, NonReportable.class, this.getNonReportable(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("otherMasterAgreementType"), String.class, (Object)this.getOtherMasterAgreementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, (Object)this.getCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("ptrrId"), String.class, (Object)this.getPtrrId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty1"), Boolean.class, (Object)this.getClearingThresholdOfCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty2"), Boolean.class, (Object)this.getClearingThresholdOfCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportingObligationOfTheCounterparty2"), Boolean.class, (Object)this.getReportingObligationOfTheCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("directlyLinkedToCommercialActivityOrTreasuryFinancing"), Boolean.class, (Object)this.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportTrackingNumber"), String.class, (Object)this.getReportTrackingNumber(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isin"), String.class, (Object)this.getIsin(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("productClassification"), String.class, (Object)this.getProductClassification(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indicatorOfTheUnderlyingIndex"), IndexEnum.class, this.getIndicatorOfTheUnderlyingIndex(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("clearingObligation"), ClearingObligationEnum.class, (Object)this.getClearingObligation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("ptrr"), Boolean.class, (Object)this.getPtrr(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("typeOfPTRRTechnique"), RiskReductionTechniqueEnum.class, (Object)this.getTypeOfPTRRTechnique(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("ptrrServiceProvider"), String.class, (Object)this.getPtrrServiceProvider(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("venueOfExecution"), String.class, (Object)this.getVenueOfExecution(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("forwardExchangeRate"), BigDecimal.class, (Object)this.getForwardExchangeRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("deliveryPoint"), String.class, this.getDeliveryPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("interconnectionPoint"), String.class, (Object)this.getInterconnectionPoint(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("loadType"), EnergyLoadType1Code.class, (Object)this.getLoadType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("deliveryReport"), processor, ReportableDelivery.class, this.getDeliveryReport(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("tranche"), Boolean.class, (Object)this.getTranche(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class EMIRTransactionReportBuilderImpl
    extends CommonTransactionReport.CommonTransactionReportBuilderImpl
    implements EMIRTransactionReportBuilder {
        protected CommonContractType contractType;
        protected CommonAssetClass assetClass;
        protected ClearedEnum cleared;
        protected MasterAgreementEnum masterAgreementType;
        protected ZonedDateTime executionTimestamp;
        protected Date effectiveDate;
        protected DeliveryTypeEnum deliveryType;
        protected String otherMasterAgreementType;
        protected String collateralPortfolioCode;
        protected String ptrrId;
        protected Boolean clearingThresholdOfCounterparty1;
        protected Boolean clearingThresholdOfCounterparty2;
        protected Boolean reportingObligationOfTheCounterparty2;
        protected Boolean directlyLinkedToCommercialActivityOrTreasuryFinancing;
        protected String reportTrackingNumber;
        protected String isin;
        protected String productClassification;
        protected List<IndexEnum> indicatorOfTheUnderlyingIndex = new ArrayList<IndexEnum>();
        protected ClearingObligationEnum clearingObligation;
        protected Boolean ptrr;
        protected RiskReductionTechniqueEnum typeOfPTRRTechnique;
        protected String ptrrServiceProvider;
        protected String venueOfExecution;
        protected BigDecimal forwardExchangeRate;
        protected List<String> deliveryPoint = new ArrayList<String>();
        protected String interconnectionPoint;
        protected EnergyLoadType1Code loadType;
        protected List<ReportableDelivery.ReportableDeliveryBuilder> deliveryReport = new ArrayList<ReportableDelivery.ReportableDeliveryBuilder>();
        protected Boolean tranche;
        protected Date eventDate;

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public CommonContractType getContractType() {
            return this.contractType;
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public CommonAssetClass getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public ClearedEnum getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="masterAgreementType", isRequired=true)
        @RuneAttribute(value="masterAgreementType", isRequired=true)
        public MasterAgreementEnum getMasterAgreementType() {
            return this.masterAgreementType;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp", isRequired=true)
        @RuneAttribute(value="executionTimestamp", isRequired=true)
        public ZonedDateTime getExecutionTimestamp() {
            return this.executionTimestamp;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="deliveryType", isRequired=true)
        @RuneAttribute(value="deliveryType", isRequired=true)
        public DeliveryTypeEnum getDeliveryType() {
            return this.deliveryType;
        }

        @Override
        @RosettaAttribute(value="otherMasterAgreementType")
        @RuneAttribute(value="otherMasterAgreementType")
        public String getOtherMasterAgreementType() {
            return this.otherMasterAgreementType;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCode")
        @RuneAttribute(value="collateralPortfolioCode")
        public String getCollateralPortfolioCode() {
            return this.collateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="ptrrId")
        @RuneAttribute(value="ptrrId")
        public String getPtrrId() {
            return this.ptrrId;
        }

        @Override
        @RosettaAttribute(value="clearingThresholdOfCounterparty1")
        @RuneAttribute(value="clearingThresholdOfCounterparty1")
        public Boolean getClearingThresholdOfCounterparty1() {
            return this.clearingThresholdOfCounterparty1;
        }

        @Override
        @RosettaAttribute(value="clearingThresholdOfCounterparty2")
        @RuneAttribute(value="clearingThresholdOfCounterparty2")
        public Boolean getClearingThresholdOfCounterparty2() {
            return this.clearingThresholdOfCounterparty2;
        }

        @Override
        @RosettaAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
        @RuneAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
        public Boolean getReportingObligationOfTheCounterparty2() {
            return this.reportingObligationOfTheCounterparty2;
        }

        @Override
        @RosettaAttribute(value="directlyLinkedToCommercialActivityOrTreasuryFinancing")
        @RuneAttribute(value="directlyLinkedToCommercialActivityOrTreasuryFinancing")
        public Boolean getDirectlyLinkedToCommercialActivityOrTreasuryFinancing() {
            return this.directlyLinkedToCommercialActivityOrTreasuryFinancing;
        }

        @Override
        @RosettaAttribute(value="reportTrackingNumber")
        @RuneAttribute(value="reportTrackingNumber")
        public String getReportTrackingNumber() {
            return this.reportTrackingNumber;
        }

        @Override
        @RosettaAttribute(value="isin")
        @RuneAttribute(value="isin")
        public String getIsin() {
            return this.isin;
        }

        @Override
        @RosettaAttribute(value="productClassification", isRequired=true)
        @RuneAttribute(value="productClassification", isRequired=true)
        public String getProductClassification() {
            return this.productClassification;
        }

        @Override
        @RosettaAttribute(value="indicatorOfTheUnderlyingIndex")
        @RuneAttribute(value="indicatorOfTheUnderlyingIndex")
        public List<IndexEnum> getIndicatorOfTheUnderlyingIndex() {
            return this.indicatorOfTheUnderlyingIndex;
        }

        @Override
        @RosettaAttribute(value="clearingObligation")
        @RuneAttribute(value="clearingObligation")
        public ClearingObligationEnum getClearingObligation() {
            return this.clearingObligation;
        }

        @Override
        @RosettaAttribute(value="ptrr")
        @RuneAttribute(value="ptrr")
        public Boolean getPtrr() {
            return this.ptrr;
        }

        @Override
        @RosettaAttribute(value="typeOfPTRRTechnique")
        @RuneAttribute(value="typeOfPTRRTechnique")
        public RiskReductionTechniqueEnum getTypeOfPTRRTechnique() {
            return this.typeOfPTRRTechnique;
        }

        @Override
        @RosettaAttribute(value="ptrrServiceProvider")
        @RuneAttribute(value="ptrrServiceProvider")
        public String getPtrrServiceProvider() {
            return this.ptrrServiceProvider;
        }

        @Override
        @RosettaAttribute(value="venueOfExecution")
        @RuneAttribute(value="venueOfExecution")
        public String getVenueOfExecution() {
            return this.venueOfExecution;
        }

        @Override
        @RosettaAttribute(value="forwardExchangeRate")
        @RuneAttribute(value="forwardExchangeRate")
        public BigDecimal getForwardExchangeRate() {
            return this.forwardExchangeRate;
        }

        @Override
        @RosettaAttribute(value="deliveryPoint")
        @RuneAttribute(value="deliveryPoint")
        public List<String> getDeliveryPoint() {
            return this.deliveryPoint;
        }

        @Override
        @RosettaAttribute(value="interconnectionPoint")
        @RuneAttribute(value="interconnectionPoint")
        public String getInterconnectionPoint() {
            return this.interconnectionPoint;
        }

        @Override
        @RosettaAttribute(value="loadType")
        @RuneAttribute(value="loadType")
        public EnergyLoadType1Code getLoadType() {
            return this.loadType;
        }

        @Override
        @RosettaAttribute(value="deliveryReport")
        @RuneAttribute(value="deliveryReport")
        public List<? extends ReportableDelivery.ReportableDeliveryBuilder> getDeliveryReport() {
            return this.deliveryReport;
        }

        @Override
        public ReportableDelivery.ReportableDeliveryBuilder getOrCreateDeliveryReport(int index) {
            if (this.deliveryReport == null) {
                this.deliveryReport = new ArrayList<ReportableDelivery.ReportableDeliveryBuilder>();
            }
            return (ReportableDelivery.ReportableDeliveryBuilder)this.getIndex(this.deliveryReport, index, () -> {
                ReportableDelivery.ReportableDeliveryBuilder newDeliveryReport = ReportableDelivery.builder();
                return newDeliveryReport;
            });
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public Boolean getTranche() {
            return this.tranche;
        }

        @Override
        @RosettaAttribute(value="eventDate", isRequired=true)
        @RuneAttribute(value="eventDate", isRequired=true)
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public EMIRTransactionReportBuilder setEffectiveDateOverriddenAsDate(Date _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public EMIRTransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
            return this.setEffectiveDateOverriddenAsDate(_effectiveDate);
        }

        @Override
        @RosettaAttribute(value="earlyTerminationDate")
        @RuneAttribute(value="earlyTerminationDate")
        public EMIRTransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
            this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public EMIRTransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp", isRequired=true)
        @RuneAttribute(value="executionTimestamp", isRequired=true)
        public EMIRTransactionReportBuilder setExecutionTimestampOverriddenAsZonedDateTime(ZonedDateTime _executionTimestamp) {
            this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public EMIRTransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
            return this.setExecutionTimestampOverriddenAsZonedDateTime(_executionTimestamp);
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public EMIRTransactionReportBuilder setExpirationDate(Date _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public EMIRTransactionReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2")
        @RuneAttribute(value="counterparty2")
        public EMIRTransactionReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType")
        @RuneAttribute(value="counterparty2IdentifierType")
        public EMIRTransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary1")
        @RuneAttribute(value="beneficiary1")
        public EMIRTransactionReportBuilder setBeneficiary1(String _beneficiary1) {
            this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
            return this;
        }

        @Override
        @RosettaAttribute(value="beneficiary1IdentifierTypeIndicator")
        @RuneAttribute(value="beneficiary1IdentifierTypeIndicator")
        public EMIRTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
            this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerIdentifier")
        @RuneAttribute(value="buyerIdentifier")
        public EMIRTransactionReportBuilder setBuyerIdentifier(String _buyerIdentifier) {
            this.buyerIdentifier = _buyerIdentifier == null ? null : _buyerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="sellerIdentifier")
        @RuneAttribute(value="sellerIdentifier")
        public EMIRTransactionReportBuilder setSellerIdentifier(String _sellerIdentifier) {
            this.sellerIdentifier = _sellerIdentifier == null ? null : _sellerIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public EMIRTransactionReportBuilder setClearedOverriddenAsClearedEnum(ClearedEnum _cleared) {
            this.cleared = _cleared == null ? null : _cleared;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public EMIRTransactionReportBuilder setCleared(ClearedEnum _cleared) {
            return this.setClearedOverriddenAsClearedEnum(_cleared);
        }

        @Override
        @RosettaAttribute(value="centralCounterparty")
        @RuneAttribute(value="centralCounterparty")
        public EMIRTransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
            this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingMember")
        @RuneAttribute(value="clearingMember")
        public EMIRTransactionReportBuilder setClearingMember(String _clearingMember) {
            this.clearingMember = _clearingMember == null ? null : _clearingMember;
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmed")
        @RuneAttribute(value="confirmed")
        public EMIRTransactionReportBuilder setConfirmed(ConfirmationEnum _confirmed) {
            this.confirmed = _confirmed == null ? null : _confirmed;
            return this;
        }

        @Override
        @RosettaAttribute(value="callAmount")
        @RuneAttribute(value="callAmount")
        public EMIRTransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
            this.callAmount = _callAmount == null ? null : _callAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="putAmount")
        @RuneAttribute(value="putAmount")
        public EMIRTransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
            this.putAmount = _putAmount == null ? null : _putAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="callCurrency")
        @RuneAttribute(value="callCurrency")
        public EMIRTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
            this.callCurrency = _callCurrency == null ? null : _callCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="putCurrency")
        @RuneAttribute(value="putCurrency")
        public EMIRTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
            this.putCurrency = _putCurrency == null ? null : _putCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public EMIRTransactionReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceSchedule")
        @RuneAttribute(value="priceSchedule")
        public EMIRTransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule) {
            if (_priceSchedule != null) {
                this.priceSchedule.add(_priceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule, int idx) {
            this.getIndex(this.priceSchedule, idx, () -> _priceSchedule.toBuilder());
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedules) {
            if (priceSchedules != null) {
                for (PricePeriod pricePeriod : priceSchedules) {
                    this.priceSchedule.add(pricePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="priceSchedule")
        public EMIRTransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedules) {
            this.priceSchedule = priceSchedules == null ? new ArrayList() : (List)priceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceSchedule")
        @RuneAttribute(value="strikePriceSchedule")
        public EMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule) {
            if (_strikePriceSchedule != null) {
                this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule, int idx) {
            this.getIndex(this.strikePriceSchedule, idx, () -> _strikePriceSchedule.toBuilder());
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
            if (strikePriceSchedules != null) {
                for (PricePeriod pricePeriod : strikePriceSchedules) {
                    this.strikePriceSchedule.add(pricePeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="strikePriceSchedule")
        public EMIRTransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
            this.strikePriceSchedule = strikePriceSchedules == null ? new ArrayList() : (List)strikePriceSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="price")
        @RuneAttribute(value="price")
        public EMIRTransactionReportBuilder setPrice(PriceFormat _price) {
            this.price = _price == null ? null : _price.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceNotation")
        @RuneAttribute(value="priceNotation")
        public EMIRTransactionReportBuilder setPriceNotation(PriceNotationEnum _priceNotation) {
            this.priceNotation = _priceNotation == null ? null : _priceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceCurrency")
        @RuneAttribute(value="priceCurrency")
        public EMIRTransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
            this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPrice")
        @RuneAttribute(value="packageTransactionPrice")
        public EMIRTransactionReportBuilder setPackageTransactionPrice(PriceFormat _packageTransactionPrice) {
            this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceNotation")
        @RuneAttribute(value="packageTransactionPriceNotation")
        public EMIRTransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
            this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionPriceCurrency")
        @RuneAttribute(value="packageTransactionPriceCurrency")
        public EMIRTransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
            this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpread")
        @RuneAttribute(value="packageTransactionSpread")
        public EMIRTransactionReportBuilder setPackageTransactionSpread(PriceFormat _packageTransactionSpread) {
            this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadNotation")
        @RuneAttribute(value="packageTransactionSpreadNotation")
        public EMIRTransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum _packageTransactionSpreadNotation) {
            this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageTransactionSpreadCurrency")
        @RuneAttribute(value="packageTransactionSpreadCurrency")
        public EMIRTransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
            this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageIdentifier")
        @RuneAttribute(value="packageIdentifier")
        public EMIRTransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
            this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePrice")
        @RuneAttribute(value="strikePrice")
        public EMIRTransactionReportBuilder setStrikePrice(PriceFormat _strikePrice) {
            this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceNotation")
        @RuneAttribute(value="strikePriceNotation")
        public EMIRTransactionReportBuilder setStrikePriceNotation(PriceNotationEnum _strikePriceNotation) {
            this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="strikePriceCurrency")
        @RuneAttribute(value="strikePriceCurrency")
        public EMIRTransactionReportBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
            this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceUnitOfMeasure")
        @RuneAttribute(value="priceUnitOfMeasure")
        public EMIRTransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
            this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumAmount")
        @RuneAttribute(value="optionPremiumAmount")
        public EMIRTransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
            this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumCurrency")
        @RuneAttribute(value="optionPremiumCurrency")
        public EMIRTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
            this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionPremiumPaymentDate")
        @RuneAttribute(value="optionPremiumPaymentDate")
        public EMIRTransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
            this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRate")
        @RuneAttribute(value="exchangeRate")
        public EMIRTransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
            this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeRateBasis")
        @RuneAttribute(value="exchangeRateBasis")
        public EMIRTransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
            this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexAttachmentPoint")
        @RuneAttribute(value="cdSIndexAttachmentPoint")
        public EMIRTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
            this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="cdSIndexDetachmentPoint")
        @RuneAttribute(value="cdSIndexDetachmentPoint")
        public EMIRTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
            this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public EMIRTransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="firstExerciseDate")
        @RuneAttribute(value="firstExerciseDate")
        public EMIRTransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
            this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalContractualSettlementDate")
        @RuneAttribute(value="finalContractualSettlementDate")
        public EMIRTransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
            this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementLocation")
        @RuneAttribute(value="settlementLocation")
        public EMIRTransactionReportBuilder setSettlementLocation(ISOCountryCodeEnum _settlementLocation) {
            this.settlementLocation = _settlementLocation == null ? null : _settlementLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTI")
        @RuneAttribute(value="priorUTI")
        public EMIRTransactionReportBuilder setPriorUTI(String _priorUTI) {
            this.priorUTI = _priorUTI == null ? null : _priorUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction1")
        @RuneAttribute(value="direction1")
        public EMIRTransactionReportBuilder setDirection1(Direction1Enum _direction1) {
            this.direction1 = _direction1 == null ? null : _direction1;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount")
        @RuneAttribute(value="valuationAmount")
        public EMIRTransactionReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency")
        @RuneAttribute(value="valuationCurrency")
        public EMIRTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod")
        @RuneAttribute(value="valuationMethod")
        public EMIRTransactionReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp")
        @RuneAttribute(value="valuationTimestamp")
        public EMIRTransactionReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="customBasketCode")
        @RuneAttribute(value="customBasketCode")
        public EMIRTransactionReportBuilder setCustomBasketCode(String _customBasketCode) {
            this.customBasketCode = _customBasketCode == null ? null : _customBasketCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="basketConstituents")
        @RuneAttribute(value="basketConstituents")
        public EMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
            if (_basketConstituents != null) {
                this.basketConstituents.add(_basketConstituents.toBuilder());
            }
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int idx) {
            this.getIndex(this.basketConstituents, idx, () -> _basketConstituents.toBuilder());
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            if (basketConstituentss != null) {
                for (BasketConstituentsReport basketConstituentsReport : basketConstituentss) {
                    this.basketConstituents.add(basketConstituentsReport.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="basketConstituents")
        public EMIRTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
            this.basketConstituents = basketConstituentss == null ? new ArrayList() : (List)basketConstituentss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="otherPayment")
        @RuneAttribute(value="otherPayment")
        public EMIRTransactionReportBuilder addOtherPayment(OtherPayment _otherPayment) {
            if (_otherPayment != null) {
                this.otherPayment.add(_otherPayment.toBuilder());
            }
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addOtherPayment(OtherPayment _otherPayment, int idx) {
            this.getIndex(this.otherPayment, idx, () -> _otherPayment.toBuilder());
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayments) {
            if (otherPayments != null) {
                for (OtherPayment otherPayment : otherPayments) {
                    this.otherPayment.add(otherPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otherPayment")
        public EMIRTransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayments) {
            this.otherPayment = otherPayments == null ? new ArrayList() : (List)otherPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="leg1")
        @RuneAttribute(value="leg1")
        public EMIRTransactionReportBuilder setLeg1(CommonLeg _leg1) {
            this.leg1 = _leg1 == null ? null : _leg1.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public EMIRTransactionReportBuilder setLeg1(Leg _leg1) {
            CommonLeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public EMIRTransactionReportBuilder setLeg1(LegV2 _leg1) {
            CommonLeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public EMIRTransactionReportBuilder setLeg1(LegV1 _leg1) {
            CommonLeg ifThenElseResult = _leg1 == null ? null : (_leg1 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg1) : null);
            return this.setLeg1(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="leg2")
        @RuneAttribute(value="leg2")
        public EMIRTransactionReportBuilder setLeg2(CommonLeg _leg2) {
            this.leg2 = _leg2 == null ? null : _leg2.toBuilder();
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public EMIRTransactionReportBuilder setLeg2(Leg _leg2) {
            CommonLeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public EMIRTransactionReportBuilder setLeg2(LegV2 _leg2) {
            CommonLeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public EMIRTransactionReportBuilder setLeg2(LegV1 _leg2) {
            CommonLeg ifThenElseResult = _leg2 == null ? null : (_leg2 instanceof CommonLeg ? (CommonLeg)CommonLeg.class.cast(_leg2) : null);
            return this.setLeg2(ifThenElseResult);
        }

        @Override
        @RosettaAttribute(value="underlyingIdOther")
        @RuneAttribute(value="underlyingIdOther")
        public EMIRTransactionReportBuilder setUnderlyingIdOther(String _underlyingIdOther) {
            this.underlyingIdOther = _underlyingIdOther == null ? null : _underlyingIdOther;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdOtherSource")
        @RuneAttribute(value="underlyingIdOtherSource")
        public EMIRTransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum _underlyingIdOtherSource) {
            this.underlyingIdOtherSource = _underlyingIdOtherSource == null ? null : _underlyingIdOtherSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetTradingPlatformIdentifier")
        @RuneAttribute(value="underlyingAssetTradingPlatformIdentifier")
        public EMIRTransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifier(String _underlyingAssetTradingPlatformIdentifier) {
            this.underlyingAssetTradingPlatformIdentifier = _underlyingAssetTradingPlatformIdentifier == null ? null : _underlyingAssetTradingPlatformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingAssetPriceSource")
        @RuneAttribute(value="underlyingAssetPriceSource")
        public EMIRTransactionReportBuilder setUnderlyingAssetPriceSource(String _underlyingAssetPriceSource) {
            this.underlyingAssetPriceSource = _underlyingAssetPriceSource == null ? null : _underlyingAssetPriceSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="cryptoAssetUnderlyingIndicator")
        @RuneAttribute(value="cryptoAssetUnderlyingIndicator")
        public EMIRTransactionReportBuilder setCryptoAssetUnderlyingIndicator(Boolean _cryptoAssetUnderlyingIndicator) {
            this.cryptoAssetUnderlyingIndicator = _cryptoAssetUnderlyingIndicator == null ? null : _cryptoAssetUnderlyingIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public EMIRTransactionReportBuilder setLevel(ReportLevelEnum _level) {
            this.level = _level == null ? null : _level;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public EMIRTransactionReportBuilder setActionType(ActionTypeEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventType")
        @RuneAttribute(value="eventType")
        public EMIRTransactionReportBuilder setEventType(EventTypeEnum _eventType) {
            this.eventType = _eventType == null ? null : _eventType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public EMIRTransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
            this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp")
        @RuneAttribute(value="eventTimestamp")
        public EMIRTransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
            this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="confirmationTimestamp")
        @RuneAttribute(value="confirmationTimestamp")
        public EMIRTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime _confirmationTimestamp) {
            this.confirmationTimestamp = _confirmationTimestamp == null ? null : _confirmationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="platformIdentifier")
        @RuneAttribute(value="platformIdentifier")
        public EMIRTransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
            this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="bookingLocation")
        @RuneAttribute(value="bookingLocation")
        public EMIRTransactionReportBuilder setBookingLocation(ISOCountryCodeEnum _bookingLocation) {
            this.bookingLocation = _bookingLocation == null ? null : _bookingLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="traderLocation")
        @RuneAttribute(value="traderLocation")
        public EMIRTransactionReportBuilder setTraderLocation(ISOCountryCodeEnum _traderLocation) {
            this.traderLocation = _traderLocation == null ? null : _traderLocation;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryType", isRequired=true)
        @RuneAttribute(value="deliveryType", isRequired=true)
        public EMIRTransactionReportBuilder setDeliveryTypeOverriddenAsDeliveryTypeEnum(DeliveryTypeEnum _deliveryType) {
            this.deliveryType = _deliveryType == null ? null : _deliveryType;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public EMIRTransactionReportBuilder setDeliveryType(DeliveryTypeEnum _deliveryType) {
            return this.setDeliveryTypeOverriddenAsDeliveryTypeEnum(_deliveryType);
        }

        @Override
        @RosettaAttribute(value="executionAgentCounterparty1")
        @RuneAttribute(value="executionAgentCounterparty1")
        public EMIRTransactionReportBuilder setExecutionAgentCounterparty1(String _executionAgentCounterparty1) {
            this.executionAgentCounterparty1 = _executionAgentCounterparty1 == null ? null : _executionAgentCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentCounterparty2")
        @RuneAttribute(value="executionAgentCounterparty2")
        public EMIRTransactionReportBuilder setExecutionAgentCounterparty2(String _executionAgentCounterparty2) {
            this.executionAgentCounterparty2 = _executionAgentCounterparty2 == null ? null : _executionAgentCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="natureOfCounterparty1")
        @RuneAttribute(value="natureOfCounterparty1")
        public EMIRTransactionReportBuilder setNatureOfCounterparty1(NatureOfCounterpartyEnum _natureOfCounterparty1) {
            this.natureOfCounterparty1 = _natureOfCounterparty1 == null ? null : _natureOfCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="natureOfCounterparty2")
        @RuneAttribute(value="natureOfCounterparty2")
        public EMIRTransactionReportBuilder setNatureOfCounterparty2(NatureOfCounterpartyEnum _natureOfCounterparty2) {
            this.natureOfCounterparty2 = _natureOfCounterparty2 == null ? null : _natureOfCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        public EMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1) {
            if (_clearingExceptionsAndExemptionsCounterparty1 != null) {
                this.clearingExceptionsAndExemptionsCounterparty1.add(_clearingExceptionsAndExemptionsCounterparty1);
            }
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1, int idx) {
            this.getIndex(this.clearingExceptionsAndExemptionsCounterparty1, idx, () -> _clearingExceptionsAndExemptionsCounterparty1);
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
            if (clearingExceptionsAndExemptionsCounterparty1s != null) {
                for (ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty1s) {
                    this.clearingExceptionsAndExemptionsCounterparty1.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty1")
        public EMIRTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
            this.clearingExceptionsAndExemptionsCounterparty1 = clearingExceptionsAndExemptionsCounterparty1s == null ? new ArrayList() : (List)clearingExceptionsAndExemptionsCounterparty1s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        public EMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2) {
            if (_clearingExceptionsAndExemptionsCounterparty2 != null) {
                this.clearingExceptionsAndExemptionsCounterparty2.add(_clearingExceptionsAndExemptionsCounterparty2);
            }
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2, int idx) {
            this.getIndex(this.clearingExceptionsAndExemptionsCounterparty2, idx, () -> _clearingExceptionsAndExemptionsCounterparty2);
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
            if (clearingExceptionsAndExemptionsCounterparty2s != null) {
                for (ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty2s) {
                    this.clearingExceptionsAndExemptionsCounterparty2.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="clearingExceptionsAndExemptionsCounterparty2")
        public EMIRTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
            this.clearingExceptionsAndExemptionsCounterparty2 = clearingExceptionsAndExemptionsCounterparty2s == null ? new ArrayList() : (List)clearingExceptionsAndExemptionsCounterparty2s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateSectorOfTheCounterparty1")
        @RuneAttribute(value="corporateSectorOfTheCounterparty1")
        public EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1) {
            if (_corporateSectorOfTheCounterparty1 != null) {
                this.corporateSectorOfTheCounterparty1.add(_corporateSectorOfTheCounterparty1);
            }
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String _corporateSectorOfTheCounterparty1, int idx) {
            this.getIndex(this.corporateSectorOfTheCounterparty1, idx, () -> _corporateSectorOfTheCounterparty1);
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
            if (corporateSectorOfTheCounterparty1s != null) {
                for (String toAdd : corporateSectorOfTheCounterparty1s) {
                    this.corporateSectorOfTheCounterparty1.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="corporateSectorOfTheCounterparty1")
        public EMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> corporateSectorOfTheCounterparty1s) {
            this.corporateSectorOfTheCounterparty1 = corporateSectorOfTheCounterparty1s == null ? new ArrayList() : (List)corporateSectorOfTheCounterparty1s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="corporateSectorOfTheCounterparty2")
        @RuneAttribute(value="corporateSectorOfTheCounterparty2")
        public EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2) {
            if (_corporateSectorOfTheCounterparty2 != null) {
                this.corporateSectorOfTheCounterparty2.add(_corporateSectorOfTheCounterparty2);
            }
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String _corporateSectorOfTheCounterparty2, int idx) {
            this.getIndex(this.corporateSectorOfTheCounterparty2, idx, () -> _corporateSectorOfTheCounterparty2);
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
            if (corporateSectorOfTheCounterparty2s != null) {
                for (String toAdd : corporateSectorOfTheCounterparty2s) {
                    this.corporateSectorOfTheCounterparty2.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="corporateSectorOfTheCounterparty2")
        public EMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> corporateSectorOfTheCounterparty2s) {
            this.corporateSectorOfTheCounterparty2 = corporateSectorOfTheCounterparty2s == null ? new ArrayList() : (List)corporateSectorOfTheCounterparty2s.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name")
        @RuneAttribute(value="counterparty2Name")
        public EMIRTransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
            this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public EMIRTransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public EMIRTransactionReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        @RosettaAttribute(value="countryOfTheCounterparty2")
        @RuneAttribute(value="countryOfTheCounterparty2")
        public EMIRTransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum _countryOfTheCounterparty2) {
            this.countryOfTheCounterparty2 = _countryOfTheCounterparty2 == null ? null : _countryOfTheCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource")
        @RuneAttribute(value="counterparty2IdentifierSource")
        public EMIRTransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum _counterparty2IdentifierSource) {
            this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingCapacity")
        @RuneAttribute(value="tradingCapacity")
        public EMIRTransactionReportBuilder setTradingCapacity(TradingCapacity7Code _tradingCapacity) {
            this.tradingCapacity = _tradingCapacity == null ? null : _tradingCapacity;
            return this;
        }

        @Override
        @RosettaAttribute(value="brokerID")
        @RuneAttribute(value="brokerID")
        public EMIRTransactionReportBuilder setBrokerID(String _brokerID) {
            this.brokerID = _brokerID == null ? null : _brokerID;
            return this;
        }

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public EMIRTransactionReportBuilder setContractTypeOverriddenAsCommonContractType(CommonContractType _contractType) {
            this.contractType = _contractType == null ? null : _contractType;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public EMIRTransactionReportBuilder setContractType(CommonContractType _contractType) {
            return this.setContractTypeOverriddenAsCommonContractType(_contractType);
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public EMIRTransactionReportBuilder setAssetClassOverriddenAsCommonAssetClass(CommonAssetClass _assetClass) {
            this.assetClass = _assetClass == null ? null : _assetClass;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public EMIRTransactionReportBuilder setAssetClass(CommonAssetClass _assetClass) {
            return this.setAssetClassOverriddenAsCommonAssetClass(_assetClass);
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public EMIRTransactionReportBuilder setOptionType(OptionTypeCode _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="optionStyle")
        @RuneAttribute(value="optionStyle")
        public EMIRTransactionReportBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
            this.optionStyle = _optionStyle == null ? null : _optionStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="embeddedOptionType")
        @RuneAttribute(value="embeddedOptionType")
        public EMIRTransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum _embeddedOptionType) {
            this.embeddedOptionType = _embeddedOptionType == null ? null : _embeddedOptionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="masterAgreementType", isRequired=true)
        @RuneAttribute(value="masterAgreementType", isRequired=true)
        public EMIRTransactionReportBuilder setMasterAgreementTypeOverriddenAsMasterAgreementEnum(MasterAgreementEnum _masterAgreementType) {
            this.masterAgreementType = _masterAgreementType == null ? null : _masterAgreementType;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public EMIRTransactionReportBuilder setMasterAgreementType(MasterAgreementEnum _masterAgreementType) {
            return this.setMasterAgreementTypeOverriddenAsMasterAgreementEnum(_masterAgreementType);
        }

        @Override
        @RosettaAttribute(value="masterAgreementVersion")
        @RuneAttribute(value="masterAgreementVersion")
        public EMIRTransactionReportBuilder setMasterAgreementVersion(Integer _masterAgreementVersion) {
            this.masterAgreementVersion = _masterAgreementVersion == null ? null : _masterAgreementVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="secondaryTransactionIdentifier")
        @RuneAttribute(value="secondaryTransactionIdentifier")
        public EMIRTransactionReportBuilder setSecondaryTransactionIdentifier(String _secondaryTransactionIdentifier) {
            this.secondaryTransactionIdentifier = _secondaryTransactionIdentifier == null ? null : _secondaryTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="intragroup")
        @RuneAttribute(value="intragroup")
        public EMIRTransactionReportBuilder setIntragroup(Boolean _intragroup) {
            this.intragroup = _intragroup == null ? null : _intragroup;
            return this;
        }

        @Override
        @RosettaAttribute(value="nonStandardizedTermIndicator")
        @RuneAttribute(value="nonStandardizedTermIndicator")
        public EMIRTransactionReportBuilder setNonStandardizedTermIndicator(Boolean _nonStandardizedTermIndicator) {
            this.nonStandardizedTermIndicator = _nonStandardizedTermIndicator == null ? null : _nonStandardizedTermIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="amendmentIndicator")
        @RuneAttribute(value="amendmentIndicator")
        public EMIRTransactionReportBuilder setAmendmentIndicator(Boolean _amendmentIndicator) {
            this.amendmentIndicator = _amendmentIndicator == null ? null : _amendmentIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentification")
        @RuneAttribute(value="underlyingIdentification")
        public EMIRTransactionReportBuilder setUnderlyingIdentification(String _underlyingIdentification) {
            this.underlyingIdentification = _underlyingIdentification == null ? null : _underlyingIdentification;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyingIdentificationType")
        @RuneAttribute(value="underlyingIdentificationType")
        public EMIRTransactionReportBuilder setUnderlyingIdentificationType(UnderlyingIdentificationTypeEnum _underlyingIdentificationType) {
            this.underlyingIdentificationType = _underlyingIdentificationType == null ? null : _underlyingIdentificationType;
            return this;
        }

        @Override
        @RosettaAttribute(value="nameOfTheUnderlyingIndex")
        @RuneAttribute(value="nameOfTheUnderlyingIndex")
        public EMIRTransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
            this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityDateOfTheUnderlying")
        @RuneAttribute(value="maturityDateOfTheUnderlying")
        public EMIRTransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
            this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
            return this;
        }

        @Override
        @RosettaAttribute(value="swapLinkID")
        @RuneAttribute(value="swapLinkID")
        public EMIRTransactionReportBuilder setSwapLinkID(String _swapLinkID) {
            this.swapLinkID = _swapLinkID == null ? null : _swapLinkID;
            return this;
        }

        @Override
        @RosettaAttribute(value="packageIndicator")
        @RuneAttribute(value="packageIndicator")
        public EMIRTransactionReportBuilder setPackageIndicator(Boolean _packageIndicator) {
            this.packageIndicator = _packageIndicator == null ? null : _packageIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="customBasketIndicator")
        @RuneAttribute(value="customBasketIndicator")
        public EMIRTransactionReportBuilder setCustomBasketIndicator(Boolean _customBasketIndicator) {
            this.customBasketIndicator = _customBasketIndicator == null ? null : _customBasketIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUTIProprietary")
        @RuneAttribute(value="priorUTIProprietary")
        public EMIRTransactionReportBuilder setPriorUTIProprietary(String _priorUTIProprietary) {
            this.priorUTIProprietary = _priorUTIProprietary == null ? null : _priorUTIProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingTimestamp")
        @RuneAttribute(value="clearingTimestamp")
        public EMIRTransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
            this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingAccountOrigin")
        @RuneAttribute(value="clearingAccountOrigin")
        public EMIRTransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum _clearingAccountOrigin) {
            this.clearingAccountOrigin = _clearingAccountOrigin == null ? null : _clearingAccountOrigin;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingReceiptTimestamp")
        @RuneAttribute(value="clearingReceiptTimestamp")
        public EMIRTransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime _clearingReceiptTimestamp) {
            this.clearingReceiptTimestamp = _clearingReceiptTimestamp == null ? null : _clearingReceiptTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier")
        @RuneAttribute(value="uniqueTransactionIdentifier")
        public EMIRTransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public EMIRTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier")
        @RuneAttribute(value="uniqueProductIdentifier")
        public EMIRTransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
            this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalSwapUTI")
        @RuneAttribute(value="originalSwapUTI")
        public EMIRTransactionReportBuilder setOriginalSwapUTI(String _originalSwapUTI) {
            this.originalSwapUTI = _originalSwapUTI == null ? null : _originalSwapUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="subsequentPositionUTI")
        @RuneAttribute(value="subsequentPositionUTI")
        public EMIRTransactionReportBuilder setSubsequentPositionUTI(String _subsequentPositionUTI) {
            this.subsequentPositionUTI = _subsequentPositionUTI == null ? null : _subsequentPositionUTI;
            return this;
        }

        @Override
        @RosettaAttribute(value="originalSwapSDRIdentifier")
        @RuneAttribute(value="originalSwapSDRIdentifier")
        public EMIRTransactionReportBuilder setOriginalSwapSDRIdentifier(String _originalSwapSDRIdentifier) {
            this.originalSwapSDRIdentifier = _originalSwapSDRIdentifier == null ? null : _originalSwapSDRIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="priorUSI")
        @RuneAttribute(value="priorUSI")
        public EMIRTransactionReportBuilder setPriorUSI(String _priorUSI) {
            this.priorUSI = _priorUSI == null ? null : _priorUSI;
            return this;
        }

        @Override
        @RosettaAttribute(value="newSDRIdentifier")
        @RuneAttribute(value="newSDRIdentifier")
        public EMIRTransactionReportBuilder setNewSDRIdentifier(String _newSDRIdentifier) {
            this.newSDRIdentifier = _newSDRIdentifier == null ? null : _newSDRIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public EMIRTransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceEntity")
        @RuneAttribute(value="referenceEntity")
        public EMIRTransactionReportBuilder setReferenceEntity(String _referenceEntity) {
            this.referenceEntity = _referenceEntity == null ? null : _referenceEntity;
            return this;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public EMIRTransactionReportBuilder setSeniority(SeniorityEnum _seniority) {
            this.seniority = _seniority == null ? null : _seniority;
            return this;
        }

        @Override
        @RosettaAttribute(value="series")
        @RuneAttribute(value="series")
        public EMIRTransactionReportBuilder setSeries(Integer _series) {
            this.series = _series == null ? null : _series;
            return this;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public EMIRTransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
            this.indexFactor = _indexFactor == null ? null : _indexFactor;
            return this;
        }

        @Override
        @RosettaAttribute(value="seriesVersion")
        @RuneAttribute(value="seriesVersion")
        public EMIRTransactionReportBuilder setSeriesVersion(Integer _seriesVersion) {
            this.seriesVersion = _seriesVersion == null ? null : _seriesVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="baseProduct")
        @RuneAttribute(value="baseProduct")
        public EMIRTransactionReportBuilder setBaseProduct(String _baseProduct) {
            this.baseProduct = _baseProduct == null ? null : _baseProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="subProduct")
        @RuneAttribute(value="subProduct")
        public EMIRTransactionReportBuilder setSubProduct(String _subProduct) {
            this.subProduct = _subProduct == null ? null : _subProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="furtherSubProduct")
        @RuneAttribute(value="furtherSubProduct")
        public EMIRTransactionReportBuilder setFurtherSubProduct(String _furtherSubProduct) {
            this.furtherSubProduct = _furtherSubProduct == null ? null : _furtherSubProduct;
            return this;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public EMIRTransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier _barrier) {
            this.barrier = _barrier == null ? null : _barrier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public EMIRTransactionReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public EMIRTransactionReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="nonReportable")
        @RuneAttribute(value="nonReportable")
        public EMIRTransactionReportBuilder setNonReportable(NonReportable _nonReportable) {
            this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="otherMasterAgreementType")
        @RuneAttribute(value="otherMasterAgreementType")
        public EMIRTransactionReportBuilder setOtherMasterAgreementType(String _otherMasterAgreementType) {
            this.otherMasterAgreementType = _otherMasterAgreementType == null ? null : _otherMasterAgreementType;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCode")
        @RuneAttribute(value="collateralPortfolioCode")
        public EMIRTransactionReportBuilder setCollateralPortfolioCode(String _collateralPortfolioCode) {
            this.collateralPortfolioCode = _collateralPortfolioCode == null ? null : _collateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="ptrrId")
        @RuneAttribute(value="ptrrId")
        public EMIRTransactionReportBuilder setPtrrId(String _ptrrId) {
            this.ptrrId = _ptrrId == null ? null : _ptrrId;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingThresholdOfCounterparty1")
        @RuneAttribute(value="clearingThresholdOfCounterparty1")
        public EMIRTransactionReportBuilder setClearingThresholdOfCounterparty1(Boolean _clearingThresholdOfCounterparty1) {
            this.clearingThresholdOfCounterparty1 = _clearingThresholdOfCounterparty1 == null ? null : _clearingThresholdOfCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingThresholdOfCounterparty2")
        @RuneAttribute(value="clearingThresholdOfCounterparty2")
        public EMIRTransactionReportBuilder setClearingThresholdOfCounterparty2(Boolean _clearingThresholdOfCounterparty2) {
            this.clearingThresholdOfCounterparty2 = _clearingThresholdOfCounterparty2 == null ? null : _clearingThresholdOfCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
        @RuneAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
        public EMIRTransactionReportBuilder setReportingObligationOfTheCounterparty2(Boolean _reportingObligationOfTheCounterparty2) {
            this.reportingObligationOfTheCounterparty2 = _reportingObligationOfTheCounterparty2 == null ? null : _reportingObligationOfTheCounterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="directlyLinkedToCommercialActivityOrTreasuryFinancing")
        @RuneAttribute(value="directlyLinkedToCommercialActivityOrTreasuryFinancing")
        public EMIRTransactionReportBuilder setDirectlyLinkedToCommercialActivityOrTreasuryFinancing(Boolean _directlyLinkedToCommercialActivityOrTreasuryFinancing) {
            this.directlyLinkedToCommercialActivityOrTreasuryFinancing = _directlyLinkedToCommercialActivityOrTreasuryFinancing == null ? null : _directlyLinkedToCommercialActivityOrTreasuryFinancing;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportTrackingNumber")
        @RuneAttribute(value="reportTrackingNumber")
        public EMIRTransactionReportBuilder setReportTrackingNumber(String _reportTrackingNumber) {
            this.reportTrackingNumber = _reportTrackingNumber == null ? null : _reportTrackingNumber;
            return this;
        }

        @Override
        @RosettaAttribute(value="isin")
        @RuneAttribute(value="isin")
        public EMIRTransactionReportBuilder setIsin(String _isin) {
            this.isin = _isin == null ? null : _isin;
            return this;
        }

        @Override
        @RosettaAttribute(value="productClassification", isRequired=true)
        @RuneAttribute(value="productClassification", isRequired=true)
        public EMIRTransactionReportBuilder setProductClassification(String _productClassification) {
            this.productClassification = _productClassification == null ? null : _productClassification;
            return this;
        }

        @Override
        @RosettaAttribute(value="indicatorOfTheUnderlyingIndex")
        @RuneAttribute(value="indicatorOfTheUnderlyingIndex")
        public EMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum _indicatorOfTheUnderlyingIndex) {
            if (_indicatorOfTheUnderlyingIndex != null) {
                this.indicatorOfTheUnderlyingIndex.add(_indicatorOfTheUnderlyingIndex);
            }
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum _indicatorOfTheUnderlyingIndex, int idx) {
            this.getIndex(this.indicatorOfTheUnderlyingIndex, idx, () -> _indicatorOfTheUnderlyingIndex);
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(List<IndexEnum> indicatorOfTheUnderlyingIndexs) {
            if (indicatorOfTheUnderlyingIndexs != null) {
                for (IndexEnum toAdd : indicatorOfTheUnderlyingIndexs) {
                    this.indicatorOfTheUnderlyingIndex.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="indicatorOfTheUnderlyingIndex")
        public EMIRTransactionReportBuilder setIndicatorOfTheUnderlyingIndex(List<IndexEnum> indicatorOfTheUnderlyingIndexs) {
            this.indicatorOfTheUnderlyingIndex = indicatorOfTheUnderlyingIndexs == null ? new ArrayList<IndexEnum>() : (List)indicatorOfTheUnderlyingIndexs.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="clearingObligation")
        @RuneAttribute(value="clearingObligation")
        public EMIRTransactionReportBuilder setClearingObligation(ClearingObligationEnum _clearingObligation) {
            this.clearingObligation = _clearingObligation == null ? null : _clearingObligation;
            return this;
        }

        @Override
        @RosettaAttribute(value="ptrr")
        @RuneAttribute(value="ptrr")
        public EMIRTransactionReportBuilder setPtrr(Boolean _ptrr) {
            this.ptrr = _ptrr == null ? null : _ptrr;
            return this;
        }

        @Override
        @RosettaAttribute(value="typeOfPTRRTechnique")
        @RuneAttribute(value="typeOfPTRRTechnique")
        public EMIRTransactionReportBuilder setTypeOfPTRRTechnique(RiskReductionTechniqueEnum _typeOfPTRRTechnique) {
            this.typeOfPTRRTechnique = _typeOfPTRRTechnique == null ? null : _typeOfPTRRTechnique;
            return this;
        }

        @Override
        @RosettaAttribute(value="ptrrServiceProvider")
        @RuneAttribute(value="ptrrServiceProvider")
        public EMIRTransactionReportBuilder setPtrrServiceProvider(String _ptrrServiceProvider) {
            this.ptrrServiceProvider = _ptrrServiceProvider == null ? null : _ptrrServiceProvider;
            return this;
        }

        @Override
        @RosettaAttribute(value="venueOfExecution")
        @RuneAttribute(value="venueOfExecution")
        public EMIRTransactionReportBuilder setVenueOfExecution(String _venueOfExecution) {
            this.venueOfExecution = _venueOfExecution == null ? null : _venueOfExecution;
            return this;
        }

        @Override
        @RosettaAttribute(value="forwardExchangeRate")
        @RuneAttribute(value="forwardExchangeRate")
        public EMIRTransactionReportBuilder setForwardExchangeRate(BigDecimal _forwardExchangeRate) {
            this.forwardExchangeRate = _forwardExchangeRate == null ? null : _forwardExchangeRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryPoint")
        @RuneAttribute(value="deliveryPoint")
        public EMIRTransactionReportBuilder addDeliveryPoint(String _deliveryPoint) {
            if (_deliveryPoint != null) {
                this.deliveryPoint.add(_deliveryPoint);
            }
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addDeliveryPoint(String _deliveryPoint, int idx) {
            this.getIndex(this.deliveryPoint, idx, () -> _deliveryPoint);
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addDeliveryPoint(List<String> deliveryPoints) {
            if (deliveryPoints != null) {
                for (String toAdd : deliveryPoints) {
                    this.deliveryPoint.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="deliveryPoint")
        public EMIRTransactionReportBuilder setDeliveryPoint(List<String> deliveryPoints) {
            this.deliveryPoint = deliveryPoints == null ? new ArrayList<String>() : (List)deliveryPoints.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="interconnectionPoint")
        @RuneAttribute(value="interconnectionPoint")
        public EMIRTransactionReportBuilder setInterconnectionPoint(String _interconnectionPoint) {
            this.interconnectionPoint = _interconnectionPoint == null ? null : _interconnectionPoint;
            return this;
        }

        @Override
        @RosettaAttribute(value="loadType")
        @RuneAttribute(value="loadType")
        public EMIRTransactionReportBuilder setLoadType(EnergyLoadType1Code _loadType) {
            this.loadType = _loadType == null ? null : _loadType;
            return this;
        }

        @Override
        @RosettaAttribute(value="deliveryReport")
        @RuneAttribute(value="deliveryReport")
        public EMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery _deliveryReport) {
            if (_deliveryReport != null) {
                this.deliveryReport.add(_deliveryReport.toBuilder());
            }
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery _deliveryReport, int idx) {
            this.getIndex(this.deliveryReport, idx, () -> _deliveryReport.toBuilder());
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder addDeliveryReport(List<? extends ReportableDelivery> deliveryReports) {
            if (deliveryReports != null) {
                for (ReportableDelivery reportableDelivery : deliveryReports) {
                    this.deliveryReport.add(reportableDelivery.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="deliveryReport")
        public EMIRTransactionReportBuilder setDeliveryReport(List<? extends ReportableDelivery> deliveryReports) {
            this.deliveryReport = deliveryReports == null ? new ArrayList<ReportableDelivery.ReportableDeliveryBuilder>() : (List)deliveryReports.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public EMIRTransactionReportBuilder setTranche(Boolean _tranche) {
            this.tranche = _tranche == null ? null : _tranche;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate", isRequired=true)
        @RuneAttribute(value="eventDate", isRequired=true)
        public EMIRTransactionReportBuilder setEventDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        public EMIRTransactionReport build() {
            return new EMIRTransactionReportImpl(this);
        }

        @Override
        public EMIRTransactionReportBuilder toBuilder() {
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder prune() {
            super.prune();
            this.deliveryReport = this.deliveryReport.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getContractType() != null) {
                return true;
            }
            if (this.getAssetClass() != null) {
                return true;
            }
            if (this.getCleared() != null) {
                return true;
            }
            if (this.getMasterAgreementType() != null) {
                return true;
            }
            if (this.getExecutionTimestamp() != null) {
                return true;
            }
            if (this.getEffectiveDate() != null) {
                return true;
            }
            if (this.getDeliveryType() != null) {
                return true;
            }
            if (this.getOtherMasterAgreementType() != null) {
                return true;
            }
            if (this.getCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getPtrrId() != null) {
                return true;
            }
            if (this.getClearingThresholdOfCounterparty1() != null) {
                return true;
            }
            if (this.getClearingThresholdOfCounterparty2() != null) {
                return true;
            }
            if (this.getReportingObligationOfTheCounterparty2() != null) {
                return true;
            }
            if (this.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing() != null) {
                return true;
            }
            if (this.getReportTrackingNumber() != null) {
                return true;
            }
            if (this.getIsin() != null) {
                return true;
            }
            if (this.getProductClassification() != null) {
                return true;
            }
            if (this.getIndicatorOfTheUnderlyingIndex() != null && !this.getIndicatorOfTheUnderlyingIndex().isEmpty()) {
                return true;
            }
            if (this.getClearingObligation() != null) {
                return true;
            }
            if (this.getPtrr() != null) {
                return true;
            }
            if (this.getTypeOfPTRRTechnique() != null) {
                return true;
            }
            if (this.getPtrrServiceProvider() != null) {
                return true;
            }
            if (this.getVenueOfExecution() != null) {
                return true;
            }
            if (this.getForwardExchangeRate() != null) {
                return true;
            }
            if (this.getDeliveryPoint() != null && !this.getDeliveryPoint().isEmpty()) {
                return true;
            }
            if (this.getInterconnectionPoint() != null) {
                return true;
            }
            if (this.getLoadType() != null) {
                return true;
            }
            if (this.getDeliveryReport() != null && this.getDeliveryReport().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getTranche() != null) {
                return true;
            }
            return this.getEventDate() != null;
        }

        @Override
        public EMIRTransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            EMIRTransactionReportBuilder o = (EMIRTransactionReportBuilder)other;
            merger.mergeRosetta(this.getDeliveryReport(), o.getDeliveryReport(), this::getOrCreateDeliveryReport);
            merger.mergeBasic((Object)this.getContractType(), (Object)o.getContractType(), this::setContractTypeOverriddenAsCommonContractType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAssetClass(), (Object)o.getAssetClass(), this::setAssetClassOverriddenAsCommonAssetClass, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCleared(), (Object)o.getCleared(), this::setClearedOverriddenAsClearedEnum, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMasterAgreementType(), (Object)o.getMasterAgreementType(), this::setMasterAgreementTypeOverriddenAsMasterAgreementEnum, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionTimestamp(), (Object)o.getExecutionTimestamp(), this::setExecutionTimestampOverriddenAsZonedDateTime, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEffectiveDate(), (Object)o.getEffectiveDate(), this::setEffectiveDateOverriddenAsDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDeliveryType(), (Object)o.getDeliveryType(), this::setDeliveryTypeOverriddenAsDeliveryTypeEnum, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getOtherMasterAgreementType(), (Object)o.getOtherMasterAgreementType(), this::setOtherMasterAgreementType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCollateralPortfolioCode(), (Object)o.getCollateralPortfolioCode(), this::setCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPtrrId(), (Object)o.getPtrrId(), this::setPtrrId, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClearingThresholdOfCounterparty1(), (Object)o.getClearingThresholdOfCounterparty1(), this::setClearingThresholdOfCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getClearingThresholdOfCounterparty2(), (Object)o.getClearingThresholdOfCounterparty2(), this::setClearingThresholdOfCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportingObligationOfTheCounterparty2(), (Object)o.getReportingObligationOfTheCounterparty2(), this::setReportingObligationOfTheCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), (Object)o.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), this::setDirectlyLinkedToCommercialActivityOrTreasuryFinancing, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportTrackingNumber(), (Object)o.getReportTrackingNumber(), this::setReportTrackingNumber, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIsin(), (Object)o.getIsin(), this::setIsin, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getProductClassification(), (Object)o.getProductClassification(), this::setProductClassification, new AttributeMeta[0]);
            merger.mergeBasic(this.getIndicatorOfTheUnderlyingIndex(), o.getIndicatorOfTheUnderlyingIndex(), this::addIndicatorOfTheUnderlyingIndex);
            merger.mergeBasic((Object)this.getClearingObligation(), (Object)o.getClearingObligation(), this::setClearingObligation, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPtrr(), (Object)o.getPtrr(), this::setPtrr, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTypeOfPTRRTechnique(), (Object)o.getTypeOfPTRRTechnique(), this::setTypeOfPTRRTechnique, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPtrrServiceProvider(), (Object)o.getPtrrServiceProvider(), this::setPtrrServiceProvider, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVenueOfExecution(), (Object)o.getVenueOfExecution(), this::setVenueOfExecution, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getForwardExchangeRate(), (Object)o.getForwardExchangeRate(), this::setForwardExchangeRate, new AttributeMeta[0]);
            merger.mergeBasic(this.getDeliveryPoint(), o.getDeliveryPoint(), this::addDeliveryPoint);
            merger.mergeBasic((Object)this.getInterconnectionPoint(), (Object)o.getInterconnectionPoint(), this::setInterconnectionPoint, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLoadType(), (Object)o.getLoadType(), this::setLoadType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTranche(), (Object)o.getTranche(), this::setTranche, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventDate(), (Object)o.getEventDate(), this::setEventDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EMIRTransactionReport _that = (EMIRTransactionReport)this.getType().cast(o);
            if (!Objects.equals((Object)this.contractType, (Object)_that.getContractType())) {
                return false;
            }
            if (!Objects.equals((Object)this.assetClass, (Object)_that.getAssetClass())) {
                return false;
            }
            if (!Objects.equals((Object)this.cleared, (Object)_that.getCleared())) {
                return false;
            }
            if (!Objects.equals((Object)this.masterAgreementType, (Object)_that.getMasterAgreementType())) {
                return false;
            }
            if (!Objects.equals(this.executionTimestamp, _that.getExecutionTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.deliveryType, (Object)_that.getDeliveryType())) {
                return false;
            }
            if (!Objects.equals(this.otherMasterAgreementType, _that.getOtherMasterAgreementType())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioCode, _that.getCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.ptrrId, _that.getPtrrId())) {
                return false;
            }
            if (!Objects.equals(this.clearingThresholdOfCounterparty1, _that.getClearingThresholdOfCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.clearingThresholdOfCounterparty2, _that.getClearingThresholdOfCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.reportingObligationOfTheCounterparty2, _that.getReportingObligationOfTheCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.directlyLinkedToCommercialActivityOrTreasuryFinancing, _that.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing())) {
                return false;
            }
            if (!Objects.equals(this.reportTrackingNumber, _that.getReportTrackingNumber())) {
                return false;
            }
            if (!Objects.equals(this.isin, _that.getIsin())) {
                return false;
            }
            if (!Objects.equals(this.productClassification, _that.getProductClassification())) {
                return false;
            }
            if (!ListEquals.listEquals(this.indicatorOfTheUnderlyingIndex, _that.getIndicatorOfTheUnderlyingIndex())) {
                return false;
            }
            if (!Objects.equals((Object)this.clearingObligation, (Object)_that.getClearingObligation())) {
                return false;
            }
            if (!Objects.equals(this.ptrr, _that.getPtrr())) {
                return false;
            }
            if (!Objects.equals((Object)this.typeOfPTRRTechnique, (Object)_that.getTypeOfPTRRTechnique())) {
                return false;
            }
            if (!Objects.equals(this.ptrrServiceProvider, _that.getPtrrServiceProvider())) {
                return false;
            }
            if (!Objects.equals(this.venueOfExecution, _that.getVenueOfExecution())) {
                return false;
            }
            if (!Objects.equals(this.forwardExchangeRate, _that.getForwardExchangeRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.deliveryPoint, _that.getDeliveryPoint())) {
                return false;
            }
            if (!Objects.equals(this.interconnectionPoint, _that.getInterconnectionPoint())) {
                return false;
            }
            if (!Objects.equals((Object)this.loadType, (Object)_that.getLoadType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.deliveryReport, _that.getDeliveryReport())) {
                return false;
            }
            if (!Objects.equals(this.tranche, _that.getTranche())) {
                return false;
            }
            return Objects.equals(this.eventDate, _that.getEventDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.contractType != null ? ((Object)((Object)this.contractType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? ((Object)((Object)this.assetClass)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? ((Object)((Object)this.cleared)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.masterAgreementType != null ? ((Object)((Object)this.masterAgreementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.executionTimestamp != null ? this.executionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.deliveryType != null ? ((Object)((Object)this.deliveryType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.otherMasterAgreementType != null ? this.otherMasterAgreementType.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioCode != null ? this.collateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.ptrrId != null ? this.ptrrId.hashCode() : 0);
            _result = 31 * _result + (this.clearingThresholdOfCounterparty1 != null ? this.clearingThresholdOfCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.clearingThresholdOfCounterparty2 != null ? this.clearingThresholdOfCounterparty2.hashCode() : 0);
            _result = 31 * _result + (this.reportingObligationOfTheCounterparty2 != null ? this.reportingObligationOfTheCounterparty2.hashCode() : 0);
            _result = 31 * _result + (this.directlyLinkedToCommercialActivityOrTreasuryFinancing != null ? this.directlyLinkedToCommercialActivityOrTreasuryFinancing.hashCode() : 0);
            _result = 31 * _result + (this.reportTrackingNumber != null ? this.reportTrackingNumber.hashCode() : 0);
            _result = 31 * _result + (this.isin != null ? this.isin.hashCode() : 0);
            _result = 31 * _result + (this.productClassification != null ? this.productClassification.hashCode() : 0);
            _result = 31 * _result + (this.indicatorOfTheUnderlyingIndex != null ? this.indicatorOfTheUnderlyingIndex.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.clearingObligation != null ? ((Object)((Object)this.clearingObligation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.ptrr != null ? this.ptrr.hashCode() : 0);
            _result = 31 * _result + (this.typeOfPTRRTechnique != null ? ((Object)((Object)this.typeOfPTRRTechnique)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.ptrrServiceProvider != null ? this.ptrrServiceProvider.hashCode() : 0);
            _result = 31 * _result + (this.venueOfExecution != null ? this.venueOfExecution.hashCode() : 0);
            _result = 31 * _result + (this.forwardExchangeRate != null ? this.forwardExchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.deliveryPoint != null ? this.deliveryPoint.hashCode() : 0);
            _result = 31 * _result + (this.interconnectionPoint != null ? this.interconnectionPoint.hashCode() : 0);
            _result = 31 * _result + (this.loadType != null ? ((Object)((Object)this.loadType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.deliveryReport != null ? this.deliveryReport.hashCode() : 0);
            _result = 31 * _result + (this.tranche != null ? this.tranche.hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EMIRTransactionReportBuilder {contractType=" + String.valueOf((Object)this.contractType) + ", assetClass=" + String.valueOf((Object)this.assetClass) + ", cleared=" + String.valueOf((Object)this.cleared) + ", masterAgreementType=" + String.valueOf((Object)this.masterAgreementType) + ", executionTimestamp=" + String.valueOf(this.executionTimestamp) + ", effectiveDate=" + String.valueOf(this.effectiveDate) + ", deliveryType=" + String.valueOf((Object)this.deliveryType) + ", otherMasterAgreementType=" + this.otherMasterAgreementType + ", collateralPortfolioCode=" + this.collateralPortfolioCode + ", ptrrId=" + this.ptrrId + ", clearingThresholdOfCounterparty1=" + this.clearingThresholdOfCounterparty1 + ", clearingThresholdOfCounterparty2=" + this.clearingThresholdOfCounterparty2 + ", reportingObligationOfTheCounterparty2=" + this.reportingObligationOfTheCounterparty2 + ", directlyLinkedToCommercialActivityOrTreasuryFinancing=" + this.directlyLinkedToCommercialActivityOrTreasuryFinancing + ", reportTrackingNumber=" + this.reportTrackingNumber + ", isin=" + this.isin + ", productClassification=" + this.productClassification + ", indicatorOfTheUnderlyingIndex=" + String.valueOf(this.indicatorOfTheUnderlyingIndex) + ", clearingObligation=" + String.valueOf((Object)this.clearingObligation) + ", ptrr=" + this.ptrr + ", typeOfPTRRTechnique=" + String.valueOf((Object)this.typeOfPTRRTechnique) + ", ptrrServiceProvider=" + this.ptrrServiceProvider + ", venueOfExecution=" + this.venueOfExecution + ", forwardExchangeRate=" + String.valueOf(this.forwardExchangeRate) + ", deliveryPoint=" + String.valueOf(this.deliveryPoint) + ", interconnectionPoint=" + this.interconnectionPoint + ", loadType=" + String.valueOf((Object)this.loadType) + ", deliveryReport=" + String.valueOf(this.deliveryReport) + ", tranche=" + this.tranche + ", eventDate=" + String.valueOf(this.eventDate) + "} " + super.toString();
        }
    }

    public static interface EMIRTransactionReportBuilder
    extends EMIRTransactionReport,
    CommonTransactionReport.CommonTransactionReportBuilder {
        public ReportableDelivery.ReportableDeliveryBuilder getOrCreateDeliveryReport(int var1);

        public List<? extends ReportableDelivery.ReportableDeliveryBuilder> getDeliveryReport();

        @Override
        public EMIRTransactionReportBuilder setEffectiveDate(Date var1);

        @Override
        public EMIRTransactionReportBuilder setEarlyTerminationDate(Date var1);

        @Override
        public EMIRTransactionReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public EMIRTransactionReportBuilder setExecutionTimestamp(ZonedDateTime var1);

        @Override
        public EMIRTransactionReportBuilder setExpirationDate(Date var1);

        @Override
        public EMIRTransactionReportBuilder setCounterparty1(String var1);

        @Override
        public EMIRTransactionReportBuilder setCounterparty2(String var1);

        @Override
        public EMIRTransactionReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public EMIRTransactionReportBuilder setBeneficiary1(String var1);

        @Override
        public EMIRTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean var1);

        @Override
        public EMIRTransactionReportBuilder setBuyerIdentifier(String var1);

        @Override
        public EMIRTransactionReportBuilder setSellerIdentifier(String var1);

        @Override
        public EMIRTransactionReportBuilder setCleared(ClearedEnum var1);

        @Override
        public EMIRTransactionReportBuilder setCentralCounterparty(String var1);

        @Override
        public EMIRTransactionReportBuilder setClearingMember(String var1);

        @Override
        public EMIRTransactionReportBuilder setConfirmed(ConfirmationEnum var1);

        @Override
        public EMIRTransactionReportBuilder setCallAmount(BigDecimal var1);

        @Override
        public EMIRTransactionReportBuilder setPutAmount(BigDecimal var1);

        @Override
        public EMIRTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public EMIRTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public EMIRTransactionReportBuilder setDelta(BigDecimal var1);

        @Override
        public EMIRTransactionReportBuilder addPriceSchedule(PricePeriod var1);

        @Override
        public EMIRTransactionReportBuilder addPriceSchedule(PricePeriod var1, int var2);

        @Override
        public EMIRTransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public EMIRTransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public EMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod var1);

        @Override
        public EMIRTransactionReportBuilder addStrikePriceSchedule(PricePeriod var1, int var2);

        @Override
        public EMIRTransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public EMIRTransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> var1);

        @Override
        public EMIRTransactionReportBuilder setPrice(PriceFormat var1);

        @Override
        public EMIRTransactionReportBuilder setPriceNotation(PriceNotationEnum var1);

        @Override
        public EMIRTransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public EMIRTransactionReportBuilder setPackageTransactionPrice(PriceFormat var1);

        @Override
        public EMIRTransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum var1);

        @Override
        public EMIRTransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public EMIRTransactionReportBuilder setPackageTransactionSpread(PriceFormat var1);

        @Override
        public EMIRTransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum var1);

        @Override
        public EMIRTransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public EMIRTransactionReportBuilder setPackageIdentifier(String var1);

        @Override
        public EMIRTransactionReportBuilder setStrikePrice(PriceFormat var1);

        @Override
        public EMIRTransactionReportBuilder setStrikePriceNotation(PriceNotationEnum var1);

        @Override
        public EMIRTransactionReportBuilder setStrikePriceCurrency(String var1);

        @Override
        public EMIRTransactionReportBuilder setPriceUnitOfMeasure(String var1);

        @Override
        public EMIRTransactionReportBuilder setOptionPremiumAmount(BigDecimal var1);

        @Override
        public EMIRTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public EMIRTransactionReportBuilder setOptionPremiumPaymentDate(Date var1);

        @Override
        public EMIRTransactionReportBuilder setExchangeRate(BigDecimal var1);

        @Override
        public EMIRTransactionReportBuilder setExchangeRateBasis(String var1);

        @Override
        public EMIRTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal var1);

        @Override
        public EMIRTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal var1);

        @Override
        public EMIRTransactionReportBuilder setCollateralPortfolioIndicator(Boolean var1);

        @Override
        public EMIRTransactionReportBuilder setFirstExerciseDate(Date var1);

        @Override
        public EMIRTransactionReportBuilder setFinalContractualSettlementDate(Date var1);

        @Override
        public EMIRTransactionReportBuilder setSettlementLocation(ISOCountryCodeEnum var1);

        @Override
        public EMIRTransactionReportBuilder setPriorUTI(String var1);

        @Override
        public EMIRTransactionReportBuilder setDirection1(Direction1Enum var1);

        @Override
        public EMIRTransactionReportBuilder setValuationAmount(BigDecimal var1);

        @Override
        public EMIRTransactionReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public EMIRTransactionReportBuilder setValuationMethod(ValuationType1Code var1);

        @Override
        public EMIRTransactionReportBuilder setValuationTimestamp(ZonedDateTime var1);

        @Override
        public EMIRTransactionReportBuilder setCustomBasketCode(String var1);

        @Override
        public EMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport var1);

        @Override
        public EMIRTransactionReportBuilder addBasketConstituents(BasketConstituentsReport var1, int var2);

        @Override
        public EMIRTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> var1);

        @Override
        public EMIRTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> var1);

        @Override
        public EMIRTransactionReportBuilder addOtherPayment(OtherPayment var1);

        @Override
        public EMIRTransactionReportBuilder addOtherPayment(OtherPayment var1, int var2);

        @Override
        public EMIRTransactionReportBuilder addOtherPayment(List<? extends OtherPayment> var1);

        @Override
        public EMIRTransactionReportBuilder setOtherPayment(List<? extends OtherPayment> var1);

        @Override
        public EMIRTransactionReportBuilder setLeg1(LegV1 var1);

        @Override
        public EMIRTransactionReportBuilder setLeg2(LegV1 var1);

        @Override
        public EMIRTransactionReportBuilder setLeg1(LegV2 var1);

        @Override
        public EMIRTransactionReportBuilder setLeg2(LegV2 var1);

        @Override
        public EMIRTransactionReportBuilder setLeg1(Leg var1);

        @Override
        public EMIRTransactionReportBuilder setLeg2(Leg var1);

        @Override
        public EMIRTransactionReportBuilder setUnderlyingIdOther(String var1);

        @Override
        public EMIRTransactionReportBuilder setUnderlyingIdOtherSource(ProductIdTypeEnum var1);

        @Override
        public EMIRTransactionReportBuilder setUnderlyingAssetTradingPlatformIdentifier(String var1);

        @Override
        public EMIRTransactionReportBuilder setUnderlyingAssetPriceSource(String var1);

        @Override
        public EMIRTransactionReportBuilder setCryptoAssetUnderlyingIndicator(Boolean var1);

        @Override
        public EMIRTransactionReportBuilder setLevel(ReportLevelEnum var1);

        @Override
        public EMIRTransactionReportBuilder setActionType(ActionTypeEnum var1);

        @Override
        public EMIRTransactionReportBuilder setEventType(EventTypeEnum var1);

        @Override
        public EMIRTransactionReportBuilder setEventIdentifier(String var1);

        @Override
        public EMIRTransactionReportBuilder setEventTimestamp(ZonedDateTime var1);

        @Override
        public EMIRTransactionReportBuilder setLeg1(CommonLeg var1);

        @Override
        public EMIRTransactionReportBuilder setLeg2(CommonLeg var1);

        @Override
        public EMIRTransactionReportBuilder setConfirmationTimestamp(ZonedDateTime var1);

        @Override
        public EMIRTransactionReportBuilder setPlatformIdentifier(String var1);

        @Override
        public EMIRTransactionReportBuilder setBookingLocation(ISOCountryCodeEnum var1);

        @Override
        public EMIRTransactionReportBuilder setTraderLocation(ISOCountryCodeEnum var1);

        @Override
        public EMIRTransactionReportBuilder setDeliveryType(DeliveryTypeEnum var1);

        @Override
        public EMIRTransactionReportBuilder setExecutionAgentCounterparty1(String var1);

        @Override
        public EMIRTransactionReportBuilder setExecutionAgentCounterparty2(String var1);

        @Override
        public EMIRTransactionReportBuilder setNatureOfCounterparty1(NatureOfCounterpartyEnum var1);

        @Override
        public EMIRTransactionReportBuilder setNatureOfCounterparty2(NatureOfCounterpartyEnum var1);

        @Override
        public EMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum var1);

        @Override
        public EMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum var1, int var2);

        @Override
        public EMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public EMIRTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public EMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum var1);

        @Override
        public EMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum var1, int var2);

        @Override
        public EMIRTransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public EMIRTransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> var1);

        @Override
        public EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String var1);

        @Override
        public EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(String var1, int var2);

        @Override
        public EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty1(List<String> var1);

        @Override
        public EMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty1(List<String> var1);

        @Override
        public EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String var1);

        @Override
        public EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(String var1, int var2);

        @Override
        public EMIRTransactionReportBuilder addCorporateSectorOfTheCounterparty2(List<String> var1);

        @Override
        public EMIRTransactionReportBuilder setCorporateSectorOfTheCounterparty2(List<String> var1);

        @Override
        public EMIRTransactionReportBuilder setCounterparty2Name(String var1);

        @Override
        public EMIRTransactionReportBuilder setReportSubmittingEntityID(String var1);

        @Override
        public EMIRTransactionReportBuilder setEntityResponsibleForReporting(String var1);

        @Override
        public EMIRTransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum var1);

        @Override
        public EMIRTransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum var1);

        @Override
        public EMIRTransactionReportBuilder setTradingCapacity(TradingCapacity7Code var1);

        @Override
        public EMIRTransactionReportBuilder setBrokerID(String var1);

        @Override
        public EMIRTransactionReportBuilder setContractType(CommonContractType var1);

        @Override
        public EMIRTransactionReportBuilder setAssetClass(CommonAssetClass var1);

        @Override
        public EMIRTransactionReportBuilder setOptionType(OptionTypeCode var1);

        @Override
        public EMIRTransactionReportBuilder setOptionStyle(OptionStyleEnum var1);

        @Override
        public EMIRTransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum var1);

        @Override
        public EMIRTransactionReportBuilder setMasterAgreementType(MasterAgreementEnum var1);

        @Override
        public EMIRTransactionReportBuilder setMasterAgreementVersion(Integer var1);

        @Override
        public EMIRTransactionReportBuilder setSecondaryTransactionIdentifier(String var1);

        @Override
        public EMIRTransactionReportBuilder setIntragroup(Boolean var1);

        @Override
        public EMIRTransactionReportBuilder setNonStandardizedTermIndicator(Boolean var1);

        @Override
        public EMIRTransactionReportBuilder setAmendmentIndicator(Boolean var1);

        @Override
        public EMIRTransactionReportBuilder setUnderlyingIdentification(String var1);

        @Override
        public EMIRTransactionReportBuilder setUnderlyingIdentificationType(UnderlyingIdentificationTypeEnum var1);

        @Override
        public EMIRTransactionReportBuilder setNameOfTheUnderlyingIndex(String var1);

        @Override
        public EMIRTransactionReportBuilder setMaturityDateOfTheUnderlying(Date var1);

        @Override
        public EMIRTransactionReportBuilder setSwapLinkID(String var1);

        @Override
        public EMIRTransactionReportBuilder setPackageIndicator(Boolean var1);

        @Override
        public EMIRTransactionReportBuilder setCustomBasketIndicator(Boolean var1);

        @Override
        public EMIRTransactionReportBuilder setPriorUTIProprietary(String var1);

        @Override
        public EMIRTransactionReportBuilder setClearingTimestamp(ZonedDateTime var1);

        @Override
        public EMIRTransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum var1);

        @Override
        public EMIRTransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime var1);

        @Override
        public EMIRTransactionReportBuilder setUniqueTransactionIdentifier(String var1);

        @Override
        public EMIRTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        @Override
        public EMIRTransactionReportBuilder setUniqueProductIdentifier(String var1);

        @Override
        public EMIRTransactionReportBuilder setOriginalSwapUTI(String var1);

        @Override
        public EMIRTransactionReportBuilder setSubsequentPositionUTI(String var1);

        @Override
        public EMIRTransactionReportBuilder setOriginalSwapSDRIdentifier(String var1);

        @Override
        public EMIRTransactionReportBuilder setPriorUSI(String var1);

        @Override
        public EMIRTransactionReportBuilder setNewSDRIdentifier(String var1);

        @Override
        public EMIRTransactionReportBuilder setTechnicalRecordId(String var1);

        @Override
        public EMIRTransactionReportBuilder setReferenceEntity(String var1);

        @Override
        public EMIRTransactionReportBuilder setSeniority(SeniorityEnum var1);

        @Override
        public EMIRTransactionReportBuilder setSeries(Integer var1);

        @Override
        public EMIRTransactionReportBuilder setIndexFactor(BigDecimal var1);

        @Override
        public EMIRTransactionReportBuilder setSeriesVersion(Integer var1);

        @Override
        public EMIRTransactionReportBuilder setBaseProduct(String var1);

        @Override
        public EMIRTransactionReportBuilder setSubProduct(String var1);

        @Override
        public EMIRTransactionReportBuilder setFurtherSubProduct(String var1);

        @Override
        public EMIRTransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier var1);

        @Override
        public EMIRTransactionReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        @Override
        public EMIRTransactionReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        @Override
        public EMIRTransactionReportBuilder setNonReportable(NonReportable var1);

        public EMIRTransactionReportBuilder setContractTypeOverriddenAsCommonContractType(CommonContractType var1);

        public EMIRTransactionReportBuilder setAssetClassOverriddenAsCommonAssetClass(CommonAssetClass var1);

        public EMIRTransactionReportBuilder setClearedOverriddenAsClearedEnum(ClearedEnum var1);

        public EMIRTransactionReportBuilder setMasterAgreementTypeOverriddenAsMasterAgreementEnum(MasterAgreementEnum var1);

        public EMIRTransactionReportBuilder setExecutionTimestampOverriddenAsZonedDateTime(ZonedDateTime var1);

        public EMIRTransactionReportBuilder setEffectiveDateOverriddenAsDate(Date var1);

        public EMIRTransactionReportBuilder setDeliveryTypeOverriddenAsDeliveryTypeEnum(DeliveryTypeEnum var1);

        public EMIRTransactionReportBuilder setOtherMasterAgreementType(String var1);

        public EMIRTransactionReportBuilder setCollateralPortfolioCode(String var1);

        public EMIRTransactionReportBuilder setPtrrId(String var1);

        public EMIRTransactionReportBuilder setClearingThresholdOfCounterparty1(Boolean var1);

        public EMIRTransactionReportBuilder setClearingThresholdOfCounterparty2(Boolean var1);

        public EMIRTransactionReportBuilder setReportingObligationOfTheCounterparty2(Boolean var1);

        public EMIRTransactionReportBuilder setDirectlyLinkedToCommercialActivityOrTreasuryFinancing(Boolean var1);

        public EMIRTransactionReportBuilder setReportTrackingNumber(String var1);

        public EMIRTransactionReportBuilder setIsin(String var1);

        public EMIRTransactionReportBuilder setProductClassification(String var1);

        public EMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum var1);

        public EMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(IndexEnum var1, int var2);

        public EMIRTransactionReportBuilder addIndicatorOfTheUnderlyingIndex(List<IndexEnum> var1);

        public EMIRTransactionReportBuilder setIndicatorOfTheUnderlyingIndex(List<IndexEnum> var1);

        public EMIRTransactionReportBuilder setClearingObligation(ClearingObligationEnum var1);

        public EMIRTransactionReportBuilder setPtrr(Boolean var1);

        public EMIRTransactionReportBuilder setTypeOfPTRRTechnique(RiskReductionTechniqueEnum var1);

        public EMIRTransactionReportBuilder setPtrrServiceProvider(String var1);

        public EMIRTransactionReportBuilder setVenueOfExecution(String var1);

        public EMIRTransactionReportBuilder setForwardExchangeRate(BigDecimal var1);

        public EMIRTransactionReportBuilder addDeliveryPoint(String var1);

        public EMIRTransactionReportBuilder addDeliveryPoint(String var1, int var2);

        public EMIRTransactionReportBuilder addDeliveryPoint(List<String> var1);

        public EMIRTransactionReportBuilder setDeliveryPoint(List<String> var1);

        public EMIRTransactionReportBuilder setInterconnectionPoint(String var1);

        public EMIRTransactionReportBuilder setLoadType(EnergyLoadType1Code var1);

        public EMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery var1);

        public EMIRTransactionReportBuilder addDeliveryReport(ReportableDelivery var1, int var2);

        public EMIRTransactionReportBuilder addDeliveryReport(List<? extends ReportableDelivery> var1);

        public EMIRTransactionReportBuilder setDeliveryReport(List<? extends ReportableDelivery> var1);

        public EMIRTransactionReportBuilder setTranche(Boolean var1);

        public EMIRTransactionReportBuilder setEventDate(Date var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("effectiveDate"), Date.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, (Object)this.getEarlyTerminationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, (Object)this.getExecutionTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expirationDate"), Date.class, (Object)this.getExpirationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1"), String.class, (Object)this.getBeneficiary1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, (Object)this.getBeneficiary1IdentifierTypeIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, (Object)this.getBuyerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, (Object)this.getSellerIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, (Object)this.getCleared(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("centralCounterparty"), String.class, (Object)this.getCentralCounterparty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingMember"), String.class, (Object)this.getClearingMember(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, (Object)this.getConfirmed(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, (Object)this.getCallAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, (Object)this.getPutAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getCallCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPutCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, this.getPriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, this.getStrikePriceSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, (Object)this.getPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPackageTransactionPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionPriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionPriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getPackageTransactionSpread(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, (Object)this.getPackageTransactionSpreadNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getPackageTransactionSpreadCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageIdentifier"), String.class, (Object)this.getPackageIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getStrikePrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, (Object)this.getStrikePriceNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, (Object)this.getStrikePriceCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, (Object)this.getPriceUnitOfMeasure(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, (Object)this.getOptionPremiumAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getOptionPremiumCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, (Object)this.getOptionPremiumPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, (Object)this.getExchangeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, (Object)this.getExchangeRateBasis(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexAttachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, (Object)this.getCdSIndexDetachmentPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, (Object)this.getFirstExerciseDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, (Object)this.getFinalContractualSettlementDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementLocation"), ISOCountryCodeEnum.class, (Object)this.getSettlementLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTI"), String.class, (Object)this.getPriorUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, (Object)this.getDirection1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("customBasketCode"), String.class, (Object)this.getCustomBasketCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, this.getBasketConstituents(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.OtherPaymentBuilder.class, this.getOtherPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leg1"), processor, CommonLeg.CommonLegBuilder.class, (RosettaModelObjectBuilder)this.getLeg1(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leg2"), processor, CommonLeg.CommonLegBuilder.class, (RosettaModelObjectBuilder)this.getLeg2(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOther"), String.class, (Object)this.getUnderlyingIdOther(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdOtherSource"), ProductIdTypeEnum.class, (Object)this.getUnderlyingIdOtherSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetTradingPlatformIdentifier"), String.class, (Object)this.getUnderlyingAssetTradingPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingAssetPriceSource"), String.class, (Object)this.getUnderlyingAssetPriceSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("cryptoAssetUnderlyingIndicator"), Boolean.class, (Object)this.getCryptoAssetUnderlyingIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, (Object)this.getEventType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventIdentifier"), String.class, (Object)this.getEventIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("confirmationTimestamp"), ZonedDateTime.class, (Object)this.getConfirmationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("platformIdentifier"), String.class, (Object)this.getPlatformIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, (Object)this.getBookingLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, (Object)this.getTraderLocation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, (Object)this.getDeliveryType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, (Object)this.getExecutionAgentCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentCounterparty2"), String.class, (Object)this.getExecutionAgentCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("natureOfCounterparty1"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("natureOfCounterparty2"), NatureOfCounterpartyEnum.class, (Object)this.getNatureOfCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, this.getClearingExceptionsAndExemptionsCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty1"), String.class, this.getCorporateSectorOfTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("corporateSectorOfTheCounterparty2"), String.class, this.getCorporateSectorOfTheCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, (Object)this.getCountryOfTheCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, (Object)this.getTradingCapacity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("brokerID"), String.class, (Object)this.getBrokerID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, (Object)this.getContractType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, (Object)this.getAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, (Object)this.getOptionStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, (Object)this.getEmbeddedOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("masterAgreementType"), MasterAgreementEnum.class, (Object)this.getMasterAgreementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("masterAgreementVersion"), Integer.class, (Object)this.getMasterAgreementVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("secondaryTransactionIdentifier"), String.class, (Object)this.getSecondaryTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("intragroup"), Boolean.class, (Object)this.getIntragroup(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, (Object)this.getNonStandardizedTermIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, (Object)this.getAmendmentIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdentification"), String.class, (Object)this.getUnderlyingIdentification(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("underlyingIdentificationType"), UnderlyingIdentificationTypeEnum.class, (Object)this.getUnderlyingIdentificationType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, (Object)this.getNameOfTheUnderlyingIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, (Object)this.getMaturityDateOfTheUnderlying(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("swapLinkID"), String.class, (Object)this.getSwapLinkID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, (Object)this.getPackageIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, (Object)this.getCustomBasketIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, (Object)this.getPriorUTIProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, (Object)this.getClearingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, (Object)this.getClearingAccountOrigin(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, (Object)this.getClearingReceiptTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, (Object)this.getUniqueProductIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, (Object)this.getOriginalSwapUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("subsequentPositionUTI"), String.class, (Object)this.getSubsequentPositionUTI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, (Object)this.getOriginalSwapSDRIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priorUSI"), String.class, (Object)this.getPriorUSI(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, (Object)this.getNewSDRIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("referenceEntity"), String.class, (Object)this.getReferenceEntity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, (Object)this.getSeniority(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("series"), Integer.class, (Object)this.getSeries(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, (Object)this.getIndexFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("seriesVersion"), Integer.class, (Object)this.getSeriesVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("baseProduct"), String.class, (Object)this.getBaseProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("subProduct"), String.class, (Object)this.getSubProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("furtherSubProduct"), String.class, (Object)this.getFurtherSubProduct(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder.class, (RosettaModelObjectBuilder)this.getBarrier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("nonReportable"), processor, NonReportable.NonReportableBuilder.class, (RosettaModelObjectBuilder)this.getNonReportable(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("otherMasterAgreementType"), String.class, (Object)this.getOtherMasterAgreementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, (Object)this.getCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("ptrrId"), String.class, (Object)this.getPtrrId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty1"), Boolean.class, (Object)this.getClearingThresholdOfCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingThresholdOfCounterparty2"), Boolean.class, (Object)this.getClearingThresholdOfCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportingObligationOfTheCounterparty2"), Boolean.class, (Object)this.getReportingObligationOfTheCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("directlyLinkedToCommercialActivityOrTreasuryFinancing"), Boolean.class, (Object)this.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportTrackingNumber"), String.class, (Object)this.getReportTrackingNumber(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isin"), String.class, (Object)this.getIsin(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("productClassification"), String.class, (Object)this.getProductClassification(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indicatorOfTheUnderlyingIndex"), IndexEnum.class, this.getIndicatorOfTheUnderlyingIndex(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("clearingObligation"), ClearingObligationEnum.class, (Object)this.getClearingObligation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("ptrr"), Boolean.class, (Object)this.getPtrr(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("typeOfPTRRTechnique"), RiskReductionTechniqueEnum.class, (Object)this.getTypeOfPTRRTechnique(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("ptrrServiceProvider"), String.class, (Object)this.getPtrrServiceProvider(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("venueOfExecution"), String.class, (Object)this.getVenueOfExecution(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("forwardExchangeRate"), BigDecimal.class, (Object)this.getForwardExchangeRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("deliveryPoint"), String.class, this.getDeliveryPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("interconnectionPoint"), String.class, (Object)this.getInterconnectionPoint(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("loadType"), EnergyLoadType1Code.class, (Object)this.getLoadType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("deliveryReport"), processor, ReportableDelivery.ReportableDeliveryBuilder.class, this.getDeliveryReport(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("tranche"), Boolean.class, (Object)this.getTranche(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public EMIRTransactionReportBuilder prune();
    }

    public static class EMIRTransactionReportImpl
    extends CommonTransactionReport.CommonTransactionReportImpl
    implements EMIRTransactionReport {
        private final CommonContractType contractType;
        private final CommonAssetClass assetClass;
        private final ClearedEnum cleared;
        private final MasterAgreementEnum masterAgreementType;
        private final ZonedDateTime executionTimestamp;
        private final Date effectiveDate;
        private final DeliveryTypeEnum deliveryType;
        private final String otherMasterAgreementType;
        private final String collateralPortfolioCode;
        private final String ptrrId;
        private final Boolean clearingThresholdOfCounterparty1;
        private final Boolean clearingThresholdOfCounterparty2;
        private final Boolean reportingObligationOfTheCounterparty2;
        private final Boolean directlyLinkedToCommercialActivityOrTreasuryFinancing;
        private final String reportTrackingNumber;
        private final String isin;
        private final String productClassification;
        private final List<IndexEnum> indicatorOfTheUnderlyingIndex;
        private final ClearingObligationEnum clearingObligation;
        private final Boolean ptrr;
        private final RiskReductionTechniqueEnum typeOfPTRRTechnique;
        private final String ptrrServiceProvider;
        private final String venueOfExecution;
        private final BigDecimal forwardExchangeRate;
        private final List<String> deliveryPoint;
        private final String interconnectionPoint;
        private final EnergyLoadType1Code loadType;
        private final List<? extends ReportableDelivery> deliveryReport;
        private final Boolean tranche;
        private final Date eventDate;

        protected EMIRTransactionReportImpl(EMIRTransactionReportBuilder builder) {
            super(builder);
            this.contractType = builder.getContractType();
            this.assetClass = builder.getAssetClass();
            this.cleared = builder.getCleared();
            this.masterAgreementType = builder.getMasterAgreementType();
            this.executionTimestamp = builder.getExecutionTimestamp();
            this.effectiveDate = builder.getEffectiveDate();
            this.deliveryType = builder.getDeliveryType();
            this.otherMasterAgreementType = builder.getOtherMasterAgreementType();
            this.collateralPortfolioCode = builder.getCollateralPortfolioCode();
            this.ptrrId = builder.getPtrrId();
            this.clearingThresholdOfCounterparty1 = builder.getClearingThresholdOfCounterparty1();
            this.clearingThresholdOfCounterparty2 = builder.getClearingThresholdOfCounterparty2();
            this.reportingObligationOfTheCounterparty2 = builder.getReportingObligationOfTheCounterparty2();
            this.directlyLinkedToCommercialActivityOrTreasuryFinancing = builder.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing();
            this.reportTrackingNumber = builder.getReportTrackingNumber();
            this.isin = builder.getIsin();
            this.productClassification = builder.getProductClassification();
            this.indicatorOfTheUnderlyingIndex = Optional.ofNullable(builder.getIndicatorOfTheUnderlyingIndex()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.clearingObligation = builder.getClearingObligation();
            this.ptrr = builder.getPtrr();
            this.typeOfPTRRTechnique = builder.getTypeOfPTRRTechnique();
            this.ptrrServiceProvider = builder.getPtrrServiceProvider();
            this.venueOfExecution = builder.getVenueOfExecution();
            this.forwardExchangeRate = builder.getForwardExchangeRate();
            this.deliveryPoint = Optional.ofNullable(builder.getDeliveryPoint()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.interconnectionPoint = builder.getInterconnectionPoint();
            this.loadType = builder.getLoadType();
            this.deliveryReport = Optional.ofNullable(builder.getDeliveryReport()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.tranche = builder.getTranche();
            this.eventDate = builder.getEventDate();
        }

        @Override
        @RosettaAttribute(value="contractType", isRequired=true)
        @RuneAttribute(value="contractType", isRequired=true)
        public CommonContractType getContractType() {
            return this.contractType;
        }

        @Override
        @RosettaAttribute(value="assetClass", isRequired=true)
        @RuneAttribute(value="assetClass", isRequired=true)
        public CommonAssetClass getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="cleared", isRequired=true)
        @RuneAttribute(value="cleared", isRequired=true)
        public ClearedEnum getCleared() {
            return this.cleared;
        }

        @Override
        @RosettaAttribute(value="masterAgreementType", isRequired=true)
        @RuneAttribute(value="masterAgreementType", isRequired=true)
        public MasterAgreementEnum getMasterAgreementType() {
            return this.masterAgreementType;
        }

        @Override
        @RosettaAttribute(value="executionTimestamp", isRequired=true)
        @RuneAttribute(value="executionTimestamp", isRequired=true)
        public ZonedDateTime getExecutionTimestamp() {
            return this.executionTimestamp;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public Date getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="deliveryType", isRequired=true)
        @RuneAttribute(value="deliveryType", isRequired=true)
        public DeliveryTypeEnum getDeliveryType() {
            return this.deliveryType;
        }

        @Override
        @RosettaAttribute(value="otherMasterAgreementType")
        @RuneAttribute(value="otherMasterAgreementType")
        public String getOtherMasterAgreementType() {
            return this.otherMasterAgreementType;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCode")
        @RuneAttribute(value="collateralPortfolioCode")
        public String getCollateralPortfolioCode() {
            return this.collateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="ptrrId")
        @RuneAttribute(value="ptrrId")
        public String getPtrrId() {
            return this.ptrrId;
        }

        @Override
        @RosettaAttribute(value="clearingThresholdOfCounterparty1")
        @RuneAttribute(value="clearingThresholdOfCounterparty1")
        public Boolean getClearingThresholdOfCounterparty1() {
            return this.clearingThresholdOfCounterparty1;
        }

        @Override
        @RosettaAttribute(value="clearingThresholdOfCounterparty2")
        @RuneAttribute(value="clearingThresholdOfCounterparty2")
        public Boolean getClearingThresholdOfCounterparty2() {
            return this.clearingThresholdOfCounterparty2;
        }

        @Override
        @RosettaAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
        @RuneAttribute(value="reportingObligationOfTheCounterparty2", isRequired=true)
        public Boolean getReportingObligationOfTheCounterparty2() {
            return this.reportingObligationOfTheCounterparty2;
        }

        @Override
        @RosettaAttribute(value="directlyLinkedToCommercialActivityOrTreasuryFinancing")
        @RuneAttribute(value="directlyLinkedToCommercialActivityOrTreasuryFinancing")
        public Boolean getDirectlyLinkedToCommercialActivityOrTreasuryFinancing() {
            return this.directlyLinkedToCommercialActivityOrTreasuryFinancing;
        }

        @Override
        @RosettaAttribute(value="reportTrackingNumber")
        @RuneAttribute(value="reportTrackingNumber")
        public String getReportTrackingNumber() {
            return this.reportTrackingNumber;
        }

        @Override
        @RosettaAttribute(value="isin")
        @RuneAttribute(value="isin")
        public String getIsin() {
            return this.isin;
        }

        @Override
        @RosettaAttribute(value="productClassification", isRequired=true)
        @RuneAttribute(value="productClassification", isRequired=true)
        public String getProductClassification() {
            return this.productClassification;
        }

        @Override
        @RosettaAttribute(value="indicatorOfTheUnderlyingIndex")
        @RuneAttribute(value="indicatorOfTheUnderlyingIndex")
        public List<IndexEnum> getIndicatorOfTheUnderlyingIndex() {
            return this.indicatorOfTheUnderlyingIndex;
        }

        @Override
        @RosettaAttribute(value="clearingObligation")
        @RuneAttribute(value="clearingObligation")
        public ClearingObligationEnum getClearingObligation() {
            return this.clearingObligation;
        }

        @Override
        @RosettaAttribute(value="ptrr")
        @RuneAttribute(value="ptrr")
        public Boolean getPtrr() {
            return this.ptrr;
        }

        @Override
        @RosettaAttribute(value="typeOfPTRRTechnique")
        @RuneAttribute(value="typeOfPTRRTechnique")
        public RiskReductionTechniqueEnum getTypeOfPTRRTechnique() {
            return this.typeOfPTRRTechnique;
        }

        @Override
        @RosettaAttribute(value="ptrrServiceProvider")
        @RuneAttribute(value="ptrrServiceProvider")
        public String getPtrrServiceProvider() {
            return this.ptrrServiceProvider;
        }

        @Override
        @RosettaAttribute(value="venueOfExecution")
        @RuneAttribute(value="venueOfExecution")
        public String getVenueOfExecution() {
            return this.venueOfExecution;
        }

        @Override
        @RosettaAttribute(value="forwardExchangeRate")
        @RuneAttribute(value="forwardExchangeRate")
        public BigDecimal getForwardExchangeRate() {
            return this.forwardExchangeRate;
        }

        @Override
        @RosettaAttribute(value="deliveryPoint")
        @RuneAttribute(value="deliveryPoint")
        public List<String> getDeliveryPoint() {
            return this.deliveryPoint;
        }

        @Override
        @RosettaAttribute(value="interconnectionPoint")
        @RuneAttribute(value="interconnectionPoint")
        public String getInterconnectionPoint() {
            return this.interconnectionPoint;
        }

        @Override
        @RosettaAttribute(value="loadType")
        @RuneAttribute(value="loadType")
        public EnergyLoadType1Code getLoadType() {
            return this.loadType;
        }

        @Override
        @RosettaAttribute(value="deliveryReport")
        @RuneAttribute(value="deliveryReport")
        public List<? extends ReportableDelivery> getDeliveryReport() {
            return this.deliveryReport;
        }

        @Override
        @RosettaAttribute(value="tranche")
        @RuneAttribute(value="tranche")
        public Boolean getTranche() {
            return this.tranche;
        }

        @Override
        @RosettaAttribute(value="eventDate", isRequired=true)
        @RuneAttribute(value="eventDate", isRequired=true)
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        public EMIRTransactionReport build() {
            return this;
        }

        @Override
        public EMIRTransactionReportBuilder toBuilder() {
            EMIRTransactionReportBuilder builder = EMIRTransactionReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EMIRTransactionReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getContractType()).ifPresent(builder::setContractTypeOverriddenAsCommonContractType);
            Optional.ofNullable(this.getAssetClass()).ifPresent(builder::setAssetClassOverriddenAsCommonAssetClass);
            Optional.ofNullable(this.getCleared()).ifPresent(builder::setClearedOverriddenAsClearedEnum);
            Optional.ofNullable(this.getMasterAgreementType()).ifPresent(builder::setMasterAgreementTypeOverriddenAsMasterAgreementEnum);
            Optional.ofNullable(this.getExecutionTimestamp()).ifPresent(builder::setExecutionTimestampOverriddenAsZonedDateTime);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDateOverriddenAsDate);
            Optional.ofNullable(this.getDeliveryType()).ifPresent(builder::setDeliveryTypeOverriddenAsDeliveryTypeEnum);
            Optional.ofNullable(this.getOtherMasterAgreementType()).ifPresent(builder::setOtherMasterAgreementType);
            Optional.ofNullable(this.getCollateralPortfolioCode()).ifPresent(builder::setCollateralPortfolioCode);
            Optional.ofNullable(this.getPtrrId()).ifPresent(builder::setPtrrId);
            Optional.ofNullable(this.getClearingThresholdOfCounterparty1()).ifPresent(builder::setClearingThresholdOfCounterparty1);
            Optional.ofNullable(this.getClearingThresholdOfCounterparty2()).ifPresent(builder::setClearingThresholdOfCounterparty2);
            Optional.ofNullable(this.getReportingObligationOfTheCounterparty2()).ifPresent(builder::setReportingObligationOfTheCounterparty2);
            Optional.ofNullable(this.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing()).ifPresent(builder::setDirectlyLinkedToCommercialActivityOrTreasuryFinancing);
            Optional.ofNullable(this.getReportTrackingNumber()).ifPresent(builder::setReportTrackingNumber);
            Optional.ofNullable(this.getIsin()).ifPresent(builder::setIsin);
            Optional.ofNullable(this.getProductClassification()).ifPresent(builder::setProductClassification);
            Optional.ofNullable(this.getIndicatorOfTheUnderlyingIndex()).ifPresent(builder::setIndicatorOfTheUnderlyingIndex);
            Optional.ofNullable(this.getClearingObligation()).ifPresent(builder::setClearingObligation);
            Optional.ofNullable(this.getPtrr()).ifPresent(builder::setPtrr);
            Optional.ofNullable(this.getTypeOfPTRRTechnique()).ifPresent(builder::setTypeOfPTRRTechnique);
            Optional.ofNullable(this.getPtrrServiceProvider()).ifPresent(builder::setPtrrServiceProvider);
            Optional.ofNullable(this.getVenueOfExecution()).ifPresent(builder::setVenueOfExecution);
            Optional.ofNullable(this.getForwardExchangeRate()).ifPresent(builder::setForwardExchangeRate);
            Optional.ofNullable(this.getDeliveryPoint()).ifPresent(builder::setDeliveryPoint);
            Optional.ofNullable(this.getInterconnectionPoint()).ifPresent(builder::setInterconnectionPoint);
            Optional.ofNullable(this.getLoadType()).ifPresent(builder::setLoadType);
            Optional.ofNullable(this.getDeliveryReport()).ifPresent(builder::setDeliveryReport);
            Optional.ofNullable(this.getTranche()).ifPresent(builder::setTranche);
            Optional.ofNullable(this.getEventDate()).ifPresent(builder::setEventDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EMIRTransactionReport _that = (EMIRTransactionReport)this.getType().cast(o);
            if (!Objects.equals((Object)this.contractType, (Object)_that.getContractType())) {
                return false;
            }
            if (!Objects.equals((Object)this.assetClass, (Object)_that.getAssetClass())) {
                return false;
            }
            if (!Objects.equals((Object)this.cleared, (Object)_that.getCleared())) {
                return false;
            }
            if (!Objects.equals((Object)this.masterAgreementType, (Object)_that.getMasterAgreementType())) {
                return false;
            }
            if (!Objects.equals(this.executionTimestamp, _that.getExecutionTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals((Object)this.deliveryType, (Object)_that.getDeliveryType())) {
                return false;
            }
            if (!Objects.equals(this.otherMasterAgreementType, _that.getOtherMasterAgreementType())) {
                return false;
            }
            if (!Objects.equals(this.collateralPortfolioCode, _that.getCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.ptrrId, _that.getPtrrId())) {
                return false;
            }
            if (!Objects.equals(this.clearingThresholdOfCounterparty1, _that.getClearingThresholdOfCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.clearingThresholdOfCounterparty2, _that.getClearingThresholdOfCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.reportingObligationOfTheCounterparty2, _that.getReportingObligationOfTheCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.directlyLinkedToCommercialActivityOrTreasuryFinancing, _that.getDirectlyLinkedToCommercialActivityOrTreasuryFinancing())) {
                return false;
            }
            if (!Objects.equals(this.reportTrackingNumber, _that.getReportTrackingNumber())) {
                return false;
            }
            if (!Objects.equals(this.isin, _that.getIsin())) {
                return false;
            }
            if (!Objects.equals(this.productClassification, _that.getProductClassification())) {
                return false;
            }
            if (!ListEquals.listEquals(this.indicatorOfTheUnderlyingIndex, _that.getIndicatorOfTheUnderlyingIndex())) {
                return false;
            }
            if (!Objects.equals((Object)this.clearingObligation, (Object)_that.getClearingObligation())) {
                return false;
            }
            if (!Objects.equals(this.ptrr, _that.getPtrr())) {
                return false;
            }
            if (!Objects.equals((Object)this.typeOfPTRRTechnique, (Object)_that.getTypeOfPTRRTechnique())) {
                return false;
            }
            if (!Objects.equals(this.ptrrServiceProvider, _that.getPtrrServiceProvider())) {
                return false;
            }
            if (!Objects.equals(this.venueOfExecution, _that.getVenueOfExecution())) {
                return false;
            }
            if (!Objects.equals(this.forwardExchangeRate, _that.getForwardExchangeRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.deliveryPoint, _that.getDeliveryPoint())) {
                return false;
            }
            if (!Objects.equals(this.interconnectionPoint, _that.getInterconnectionPoint())) {
                return false;
            }
            if (!Objects.equals((Object)this.loadType, (Object)_that.getLoadType())) {
                return false;
            }
            if (!ListEquals.listEquals(this.deliveryReport, _that.getDeliveryReport())) {
                return false;
            }
            if (!Objects.equals(this.tranche, _that.getTranche())) {
                return false;
            }
            return Objects.equals(this.eventDate, _that.getEventDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.contractType != null ? ((Object)((Object)this.contractType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? ((Object)((Object)this.assetClass)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.cleared != null ? ((Object)((Object)this.cleared)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.masterAgreementType != null ? ((Object)((Object)this.masterAgreementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.executionTimestamp != null ? this.executionTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.deliveryType != null ? ((Object)((Object)this.deliveryType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.otherMasterAgreementType != null ? this.otherMasterAgreementType.hashCode() : 0);
            _result = 31 * _result + (this.collateralPortfolioCode != null ? this.collateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.ptrrId != null ? this.ptrrId.hashCode() : 0);
            _result = 31 * _result + (this.clearingThresholdOfCounterparty1 != null ? this.clearingThresholdOfCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.clearingThresholdOfCounterparty2 != null ? this.clearingThresholdOfCounterparty2.hashCode() : 0);
            _result = 31 * _result + (this.reportingObligationOfTheCounterparty2 != null ? this.reportingObligationOfTheCounterparty2.hashCode() : 0);
            _result = 31 * _result + (this.directlyLinkedToCommercialActivityOrTreasuryFinancing != null ? this.directlyLinkedToCommercialActivityOrTreasuryFinancing.hashCode() : 0);
            _result = 31 * _result + (this.reportTrackingNumber != null ? this.reportTrackingNumber.hashCode() : 0);
            _result = 31 * _result + (this.isin != null ? this.isin.hashCode() : 0);
            _result = 31 * _result + (this.productClassification != null ? this.productClassification.hashCode() : 0);
            _result = 31 * _result + (this.indicatorOfTheUnderlyingIndex != null ? this.indicatorOfTheUnderlyingIndex.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.clearingObligation != null ? ((Object)((Object)this.clearingObligation)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.ptrr != null ? this.ptrr.hashCode() : 0);
            _result = 31 * _result + (this.typeOfPTRRTechnique != null ? ((Object)((Object)this.typeOfPTRRTechnique)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.ptrrServiceProvider != null ? this.ptrrServiceProvider.hashCode() : 0);
            _result = 31 * _result + (this.venueOfExecution != null ? this.venueOfExecution.hashCode() : 0);
            _result = 31 * _result + (this.forwardExchangeRate != null ? this.forwardExchangeRate.hashCode() : 0);
            _result = 31 * _result + (this.deliveryPoint != null ? this.deliveryPoint.hashCode() : 0);
            _result = 31 * _result + (this.interconnectionPoint != null ? this.interconnectionPoint.hashCode() : 0);
            _result = 31 * _result + (this.loadType != null ? ((Object)((Object)this.loadType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.deliveryReport != null ? this.deliveryReport.hashCode() : 0);
            _result = 31 * _result + (this.tranche != null ? this.tranche.hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EMIRTransactionReport {contractType=" + String.valueOf((Object)this.contractType) + ", assetClass=" + String.valueOf((Object)this.assetClass) + ", cleared=" + String.valueOf((Object)this.cleared) + ", masterAgreementType=" + String.valueOf((Object)this.masterAgreementType) + ", executionTimestamp=" + String.valueOf(this.executionTimestamp) + ", effectiveDate=" + String.valueOf(this.effectiveDate) + ", deliveryType=" + String.valueOf((Object)this.deliveryType) + ", otherMasterAgreementType=" + this.otherMasterAgreementType + ", collateralPortfolioCode=" + this.collateralPortfolioCode + ", ptrrId=" + this.ptrrId + ", clearingThresholdOfCounterparty1=" + this.clearingThresholdOfCounterparty1 + ", clearingThresholdOfCounterparty2=" + this.clearingThresholdOfCounterparty2 + ", reportingObligationOfTheCounterparty2=" + this.reportingObligationOfTheCounterparty2 + ", directlyLinkedToCommercialActivityOrTreasuryFinancing=" + this.directlyLinkedToCommercialActivityOrTreasuryFinancing + ", reportTrackingNumber=" + this.reportTrackingNumber + ", isin=" + this.isin + ", productClassification=" + this.productClassification + ", indicatorOfTheUnderlyingIndex=" + String.valueOf(this.indicatorOfTheUnderlyingIndex) + ", clearingObligation=" + String.valueOf((Object)this.clearingObligation) + ", ptrr=" + this.ptrr + ", typeOfPTRRTechnique=" + String.valueOf((Object)this.typeOfPTRRTechnique) + ", ptrrServiceProvider=" + this.ptrrServiceProvider + ", venueOfExecution=" + this.venueOfExecution + ", forwardExchangeRate=" + String.valueOf(this.forwardExchangeRate) + ", deliveryPoint=" + String.valueOf(this.deliveryPoint) + ", interconnectionPoint=" + this.interconnectionPoint + ", loadType=" + String.valueOf((Object)this.loadType) + ", deliveryReport=" + String.valueOf(this.deliveryReport) + ", tranche=" + this.tranche + ", eventDate=" + String.valueOf(this.eventDate) + "} " + super.toString();
        }
    }
}

