/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.emir.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.event.functions.IsActionTypeEROR;
import drr.base.qualification.event.functions.IsAllowableAction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.TransactionReportInstructionBase;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.functions.PriceFormatFromNotation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.emir.reports.PackageTransactionSpreadNotationRule;
import drr.standards.iosco.cde.version3.price.reports.PackageTransactionSpreadValueRule;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PackageTransactionSpreadRuleDefault.class)
public abstract class PackageTransactionSpreadRule
implements ReportFunction<TransactionReportInstruction, PriceFormat> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected IsActionTypeEROR isActionTypeEROR;
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected PackageTransactionSpreadNotationRule packageTransactionSpreadNotationRule;
    @Inject
    protected PackageTransactionSpreadValueRule packageTransactionSpreadValueRule;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;

    public PriceFormat evaluate(TransactionReportInstruction input) {
        PriceFormat output;
        PriceFormat.PriceFormatBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceFormat.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction var1);

    public static class PackageTransactionSpreadRuleDefault
    extends PackageTransactionSpreadRule {
        @Override
        protected PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction input) {
            PriceFormat.PriceFormatBuilder output = PriceFormat.builder();
            return this.assignOutput(output, input);
        }

        protected PriceFormat.PriceFormatBuilder assignOutput(PriceFormat.PriceFormatBuilder output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isAllowableAction.evaluate((ReportableEventBase)item.get()))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isActionTypeEROR.evaluate((ReportableEventBase)item.get())))).get());
            output = (PriceFormat.PriceFormatBuilder)this.toBuilder((RosettaModelObject)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.priceFormatFromNotation.evaluate(this.packageTransactionSpreadValueRule.evaluate((TransactionReportInstructionBase)item.get()), this.packageTransactionSpreadNotationRule.evaluate((TransactionReportInstruction)item.get())))).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

