/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.asset.CommodityPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

@ImplementedBy(value=CommodityQuantityDefault.class)
public abstract class CommodityQuantity
implements RosettaFunction {
    public BigDecimal evaluate(CommodityPayout commodityPayout) {
        BigDecimal quantity = this.doEvaluate(commodityPayout);
        return quantity;
    }

    protected abstract BigDecimal doEvaluate(CommodityPayout var1);

    public static class CommodityQuantityDefault
    extends CommodityQuantity {
        @Override
        protected BigDecimal doEvaluate(CommodityPayout commodityPayout) {
            BigDecimal quantity = null;
            return this.assignOutput(quantity, commodityPayout);
        }

        protected BigDecimal assignOutput(BigDecimal quantity, CommodityPayout commodityPayout) {
            quantity = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)commodityPayout).map("getPriceQuantity", _commodityPayout -> _commodityPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule0 -> referenceWithMetaNonNegativeQuantitySchedule0 == null ? null : referenceWithMetaNonNegativeQuantitySchedule0.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue())).getOrDefault(Boolean.valueOf(false)) != false ? (BigDecimal)MapperS.of((Object)commodityPayout).map("getPriceQuantity", _commodityPayout -> _commodityPayout.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()).map("Type coercion", referenceWithMetaNonNegativeQuantitySchedule1 -> referenceWithMetaNonNegativeQuantitySchedule1 == null ? null : referenceWithMetaNonNegativeQuantitySchedule1.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue()).get() : null;
            return quantity;
        }
    }
}

