/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.template.FixedPricePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCommodityFixedPriceForward;
import drr.base.qualification.product.functions.IsCommoditySwapFixedFloat;
import drr.base.trade.functions.EconomicTermsForProduct;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=FixedPriceLeg1Default.class)
public abstract class FixedPriceLeg1
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsCommodityFixedPriceForward isCommodityFixedPriceForward;
    @Inject
    protected IsCommoditySwapFixedFloat isCommoditySwapFixedFloat;

    public FixedPricePayout evaluate(Product product) {
        FixedPricePayout fixedPrice;
        FixedPricePayout.FixedPricePayoutBuilder fixedPriceBuilder = this.doEvaluate(product);
        if (fixedPriceBuilder == null) {
            fixedPrice = null;
        } else {
            fixedPrice = fixedPriceBuilder.build();
            this.objectValidator.validate(FixedPricePayout.class, (RosettaModelObject)fixedPrice);
        }
        return fixedPrice;
    }

    protected abstract FixedPricePayout.FixedPricePayoutBuilder doEvaluate(Product var1);

    public static class FixedPriceLeg1Default
    extends FixedPriceLeg1 {
        @Override
        protected FixedPricePayout.FixedPricePayoutBuilder doEvaluate(Product product) {
            FixedPricePayout.FixedPricePayoutBuilder fixedPrice = FixedPricePayout.builder();
            return this.assignOutput(fixedPrice, product);
        }

        protected FixedPricePayout.FixedPricePayoutBuilder assignOutput(FixedPricePayout.FixedPricePayoutBuilder fixedPrice, Product product) {
            fixedPrice = ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCommoditySwapFixedFloat.evaluate(product))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCommodityFixedPriceForward.evaluate(product)))).getOrDefault(Boolean.valueOf(false)) != false ? (FixedPricePayout.FixedPricePayoutBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout()).get()) : null;
            return Optional.ofNullable(fixedPrice).map(o -> o.prune()).orElse(null);
        }
    }
}

