/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.datetime.Frequency;
import cdm.base.datetime.PeriodExtendedEnum;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.product.common.settlement.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.standards.iso.FrequencyPeriodEnum;
import drr.standards.iso.functions.ConvertPeriodtoISOFrequencyPeriod;
import javax.inject.Inject;

@ImplementedBy(value=FrequencyPeriodDefault.class)
public abstract class FrequencyPeriod
implements RosettaFunction {
    @Inject
    protected ConvertPeriodtoISOFrequencyPeriod convertPeriodtoISOFrequencyPeriod;

    public FrequencyPeriodEnum evaluate(PriceQuantity priceQuantity, Frequency frequency) {
        FrequencyPeriodEnum period = this.doEvaluate(priceQuantity, frequency);
        return period;
    }

    protected abstract FrequencyPeriodEnum doEvaluate(PriceQuantity var1, Frequency var2);

    protected abstract MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> quantity(PriceQuantity var1, Frequency var2);

    public static class FrequencyPeriodDefault
    extends FrequencyPeriod {
        @Override
        protected FrequencyPeriodEnum doEvaluate(PriceQuantity priceQuantity, Frequency frequency) {
            FrequencyPeriodEnum period = null;
            return this.assignOutput(period, priceQuantity, frequency);
        }

        protected FrequencyPeriodEnum assignOutput(FrequencyPeriodEnum period, PriceQuantity priceQuantity, Frequency frequency) {
            period = ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)frequency)).andNullSafe(ExpressionOperatorsNullSafe.exists(this.quantity(priceQuantity, frequency))).getOrDefault(Boolean.valueOf(false)) != false ? FrequencyPeriodEnum.ADHO : this.convertPeriodtoISOFrequencyPeriod.evaluate((PeriodExtendedEnum)MapperS.of((Object)frequency).map("getPeriod", _frequency -> _frequency.getPeriod()).get());
            return period;
        }

        @Override
        protected MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> quantity(PriceQuantity priceQuantity, Frequency frequency) {
            return MapperS.of((Object)priceQuantity).mapC("getQuantity", _priceQuantity -> _priceQuantity.getQuantity()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.exists((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule0 -> fieldWithMetaNonNegativeQuantitySchedule0 == null ? null : fieldWithMetaNonNegativeQuantitySchedule0.getValue()).map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule1 -> fieldWithMetaNonNegativeQuantitySchedule1 == null ? null : fieldWithMetaNonNegativeQuantitySchedule1.getValue()).map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue())).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)ExpressionOperatorsNullSafe.distinct((Mapper)item.map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule2 -> fieldWithMetaNonNegativeQuantitySchedule2 == null ? null : fieldWithMetaNonNegativeQuantitySchedule2.getValue()).mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).map("getValue", datedValue -> datedValue.getValue())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All))).get());
        }
    }
}

