/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCommoditySwap;
import drr.base.qualification.product.functions.IsCommoditySwaption;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.InterestRateLeg2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetUnderlierProductIdentifierLeg2Default.class)
public abstract class GetUnderlierProductIdentifierLeg2
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CommodityLeg2 commodityLeg2;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected InterestRateLeg2 interestRateLeg2;
    @Inject
    protected IsCommoditySwap isCommoditySwap;
    @Inject
    protected IsCommoditySwaption isCommoditySwaption;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public List<? extends ProductIdentifier> evaluate(Product product) {
        List productId;
        List<ProductIdentifier.ProductIdentifierBuilder> productIdBuilder = this.doEvaluate(product);
        if (productIdBuilder == null) {
            productId = null;
        } else {
            productId = productIdBuilder.stream().map(ProductIdentifier::build).collect(Collectors.toList());
            this.objectValidator.validate(ProductIdentifier.class, productId);
        }
        return productId;
    }

    protected abstract List<ProductIdentifier.ProductIdentifierBuilder> doEvaluate(Product var1);

    public static class GetUnderlierProductIdentifierLeg2Default
    extends GetUnderlierProductIdentifierLeg2 {
        @Override
        protected List<ProductIdentifier.ProductIdentifierBuilder> doEvaluate(Product product) {
            ArrayList<ProductIdentifier.ProductIdentifierBuilder> productId = new ArrayList<ProductIdentifier.ProductIdentifierBuilder>();
            return this.assignOutput(productId, product);
        }

        protected List<ProductIdentifier.ProductIdentifierBuilder> assignOutput(List<ProductIdentifier.ProductIdentifierBuilder> productId, Product product) {
            MapperC thenArg0 = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation())).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation()) : (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation())).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).mapC("getReferenceObligation", referenceInformation -> referenceInformation.getReferenceObligation()) : MapperC.ofNull());
            MapperListOfLists thenArg1 = thenArg0.mapItemToList(item -> {
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getSecurity", referenceObligation -> referenceObligation.getSecurity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getSecurity", referenceObligation -> referenceObligation.getSecurity()).mapC("getProductIdentifier", security -> security.getProductIdentifier());
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getLoan", referenceObligation -> referenceObligation.getLoan())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getLoan", referenceObligation -> referenceObligation.getLoan()).mapC("getProductIdentifier", loan -> loan.getProductIdentifier());
                }
                return MapperC.ofNull();
            });
            productId.addAll(this.toBuilder(thenArg1.flattenList().map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti()));
            if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCommoditySwaption.evaluate(product))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.commodityLeg2.evaluate(this.underlierForProduct.evaluate(product))).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity0 -> referenceWithMetaCommodity0 == null ? null : referenceWithMetaCommodity0.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                productId.addAll(this.toBuilder(MapperS.of((Object)this.commodityLeg2.evaluate(this.underlierForProduct.evaluate(product))).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity1 -> referenceWithMetaCommodity1 == null ? null : referenceWithMetaCommodity1.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti()));
            } else if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isCommoditySwap.evaluate(product))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.commodityLeg2.evaluate(product)).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity2 -> referenceWithMetaCommodity2 == null ? null : referenceWithMetaCommodity2.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                productId.addAll(this.toBuilder(MapperS.of((Object)this.commodityLeg2.evaluate(product)).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity3 -> referenceWithMetaCommodity3 == null ? null : referenceWithMetaCommodity3.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti()));
            } else if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.commodityLeg2.evaluate(product)).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getBasket", _product -> _product.getBasket()).mapC("getProductIdentifier", basket -> basket.getProductIdentifier())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                productId.addAll(this.toBuilder(MapperS.of((Object)this.commodityLeg2.evaluate(product)).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getBasket", _product -> _product.getBasket()).mapC("getProductIdentifier", basket -> basket.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti()));
            } else if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.commodityLeg2.evaluate(product)).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getIndex", _product -> _product.getIndex())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                productId.addAll(this.toBuilder(MapperS.of((Object)this.commodityLeg2.evaluate(product)).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier()).map("getIndex", _product -> _product.getIndex()).mapC("getProductIdentifier", index -> index.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti()));
            } else if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.interestRateLeg2.evaluate(product)).map("getBondReference", interestRatePayout -> interestRatePayout.getBondReference()).map("getBond", bondReference -> bondReference.getBond())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                productId.addAll(this.toBuilder(MapperS.of((Object)this.interestRateLeg2.evaluate(product)).map("getBondReference", interestRatePayout -> interestRatePayout.getBondReference()).map("getBond", bondReference -> bondReference.getBond()).getMulti()));
            } else {
                productId.addAll(this.toBuilder(Collections.emptyList()));
            }
            return Optional.ofNullable(productId).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

