/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.EconomicTermsForProduct;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=InterestRateLeg2FixedFloatSingleCurrencyDefault.class)
public abstract class InterestRateLeg2FixedFloatSingleCurrency
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;

    public InterestRatePayout evaluate(Product product) {
        InterestRatePayout interestRateLeg2;
        InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2Builder = this.doEvaluate(product);
        if (interestRateLeg2Builder == null) {
            interestRateLeg2 = null;
        } else {
            interestRateLeg2 = interestRateLeg2Builder.build();
            this.objectValidator.validate(InterestRatePayout.class, (RosettaModelObject)interestRateLeg2);
        }
        return interestRateLeg2;
    }

    protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product var1);

    public static class InterestRateLeg2FixedFloatSingleCurrencyDefault
    extends InterestRateLeg2FixedFloatSingleCurrency {
        @Override
        protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product) {
            InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2 = InterestRatePayout.builder();
            return this.assignOutput(interestRateLeg2, product);
        }

        protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2, Product product) {
            MapperC thenArg = MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.exists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()))).get());
            interestRateLeg2 = (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((InterestRatePayout)thenArg.get())).get());
            return Optional.ofNullable(interestRateLeg2).map(o -> o.prune()).orElse(null);
        }
    }
}

