/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.margin;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.margin.CriticalDataElement;
import drr.regulation.common.margin.meta.CommonMarginReportMeta;
import drr.standards.iso.CollateralisationType3Code;
import drr.standards.iso.MarginActionEnum;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommonMarginReport", builder=CommonMarginReportBuilderImpl.class, version="7.0.0-dev.85")
@RuneDataType(value="CommonMarginReport", model="drr", builder=CommonMarginReportBuilderImpl.class, version="7.0.0-dev.85")
public interface CommonMarginReport
extends CriticalDataElement {
    public static final CommonMarginReportMeta metaData = new CommonMarginReportMeta();

    public ZonedDateTime getCollateralTimestamp();

    public String getVariationMarginCollateralPortfolioCode();

    public String getInitialMarginCollateralPortfolioCode();

    public String getReportSubmittingEntityID();

    public MarginActionEnum getActionType();

    public Date getEventDate();

    public ZonedDateTime getEventTimestamp();

    @Override
    public CommonMarginReport build();

    @Override
    public CommonMarginReportBuilder toBuilder();

    public static CommonMarginReportBuilder builder() {
        return new CommonMarginReportBuilderImpl();
    }

    default public RosettaMetaData<? extends CommonMarginReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommonMarginReport> getType() {
        return CommonMarginReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, (Object)this.getCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uti"), String.class, (Object)this.getUti(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code.class, (Object)this.getCollateralisationCategory(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginPostedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginPostedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginCollectedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PreHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PostHaircut(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginCollectedByCounterparty1Currency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excessCollateralPostedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralPostedByTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, (Object)this.getCurrencyOfTheExcessCollateralPosted(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("excessCollateralCollectedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralCollectedByTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, (Object)this.getCurrencyOfTheExcessCollateralCollected(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, (Object)this.getCollateralTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CommonMarginReportBuilderImpl
    extends CriticalDataElement.CriticalDataElementBuilderImpl
    implements CommonMarginReportBuilder {
        protected ZonedDateTime collateralTimestamp;
        protected String variationMarginCollateralPortfolioCode;
        protected String initialMarginCollateralPortfolioCode;
        protected String reportSubmittingEntityID;
        protected MarginActionEnum actionType;
        protected Date eventDate;
        protected ZonedDateTime eventTimestamp;

        @Override
        @RosettaAttribute(value="collateralTimestamp")
        @RuneAttribute(value="collateralTimestamp")
        public ZonedDateTime getCollateralTimestamp() {
            return this.collateralTimestamp;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public MarginActionEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp")
        @RuneAttribute(value="eventTimestamp")
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public CommonMarginReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public CommonMarginReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType")
        @RuneAttribute(value="counterparty2IdentifierType")
        public CommonMarginReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2")
        @RuneAttribute(value="counterparty2")
        public CommonMarginReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioCode")
        @RuneAttribute(value="collateralPortfolioCode")
        public CommonMarginReportBuilder setCollateralPortfolioCode(String _collateralPortfolioCode) {
            this.collateralPortfolioCode = _collateralPortfolioCode == null ? null : _collateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralPortfolioIndicator")
        @RuneAttribute(value="collateralPortfolioIndicator")
        public CommonMarginReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
            this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="uti")
        @RuneAttribute(value="uti")
        public CommonMarginReportBuilder setUti(String _uti) {
            this.uti = _uti == null ? null : _uti;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralisationCategory")
        @RuneAttribute(value="collateralisationCategory")
        public CommonMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code _collateralisationCategory) {
            this.collateralisationCategory = _collateralisationCategory == null ? null : _collateralisationCategory;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="initialMarginPostedByTheCounterparty1PreHaircut")
        public CommonMarginReportBuilder setInitialMarginPostedByTheCounterparty1PreHaircut(BigDecimal _initialMarginPostedByTheCounterparty1PreHaircut) {
            this.initialMarginPostedByTheCounterparty1PreHaircut = _initialMarginPostedByTheCounterparty1PreHaircut == null ? null : _initialMarginPostedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="initialMarginPostedByTheCounterparty1PostHaircut")
        public CommonMarginReportBuilder setInitialMarginPostedByTheCounterparty1PostHaircut(BigDecimal _initialMarginPostedByTheCounterparty1PostHaircut) {
            this.initialMarginPostedByTheCounterparty1PostHaircut = _initialMarginPostedByTheCounterparty1PostHaircut == null ? null : _initialMarginPostedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginPostedByCounterparty1Currency")
        @RuneAttribute(value="initialMarginPostedByCounterparty1Currency")
        public CommonMarginReportBuilder setInitialMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum _initialMarginPostedByCounterparty1Currency) {
            this.initialMarginPostedByCounterparty1Currency = _initialMarginPostedByCounterparty1Currency == null ? null : _initialMarginPostedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="variationMarginPostedByTheCounterparty1PreHaircut")
        public CommonMarginReportBuilder setVariationMarginPostedByTheCounterparty1PreHaircut(BigDecimal _variationMarginPostedByTheCounterparty1PreHaircut) {
            this.variationMarginPostedByTheCounterparty1PreHaircut = _variationMarginPostedByTheCounterparty1PreHaircut == null ? null : _variationMarginPostedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="variationMarginPostedByTheCounterparty1PostHaircut")
        public CommonMarginReportBuilder setVariationMarginPostedByTheCounterparty1PostHaircut(BigDecimal _variationMarginPostedByTheCounterparty1PostHaircut) {
            this.variationMarginPostedByTheCounterparty1PostHaircut = _variationMarginPostedByTheCounterparty1PostHaircut == null ? null : _variationMarginPostedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginPostedByCounterparty1Currency")
        @RuneAttribute(value="variationMarginPostedByCounterparty1Currency")
        public CommonMarginReportBuilder setVariationMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum _variationMarginPostedByCounterparty1Currency) {
            this.variationMarginPostedByCounterparty1Currency = _variationMarginPostedByCounterparty1Currency == null ? null : _variationMarginPostedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1PreHaircut")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1PreHaircut")
        public CommonMarginReportBuilder setInitialMarginCollectedByCounterparty1PreHaircut(BigDecimal _initialMarginCollectedByCounterparty1PreHaircut) {
            this.initialMarginCollectedByCounterparty1PreHaircut = _initialMarginCollectedByCounterparty1PreHaircut == null ? null : _initialMarginCollectedByCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1PostHaircut")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1PostHaircut")
        public CommonMarginReportBuilder setInitialMarginCollectedByCounterparty1PostHaircut(BigDecimal _initialMarginCollectedByCounterparty1PostHaircut) {
            this.initialMarginCollectedByCounterparty1PostHaircut = _initialMarginCollectedByCounterparty1PostHaircut == null ? null : _initialMarginCollectedByCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollectedByCounterparty1Currency")
        @RuneAttribute(value="initialMarginCollectedByCounterparty1Currency")
        public CommonMarginReportBuilder setInitialMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum _initialMarginCollectedByCounterparty1Currency) {
            this.initialMarginCollectedByCounterparty1Currency = _initialMarginCollectedByCounterparty1Currency == null ? null : _initialMarginCollectedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheCounterparty1PreHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheCounterparty1PreHaircut")
        public CommonMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PreHaircut(BigDecimal _variationMarginCollectedByTheCounterparty1PreHaircut) {
            this.variationMarginCollectedByTheCounterparty1PreHaircut = _variationMarginCollectedByTheCounterparty1PreHaircut == null ? null : _variationMarginCollectedByTheCounterparty1PreHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByTheCounterparty1PostHaircut")
        @RuneAttribute(value="variationMarginCollectedByTheCounterparty1PostHaircut")
        public CommonMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PostHaircut(BigDecimal _variationMarginCollectedByTheCounterparty1PostHaircut) {
            this.variationMarginCollectedByTheCounterparty1PostHaircut = _variationMarginCollectedByTheCounterparty1PostHaircut == null ? null : _variationMarginCollectedByTheCounterparty1PostHaircut;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollectedByCounterparty1Currency")
        @RuneAttribute(value="variationMarginCollectedByCounterparty1Currency")
        public CommonMarginReportBuilder setVariationMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum _variationMarginCollectedByCounterparty1Currency) {
            this.variationMarginCollectedByCounterparty1Currency = _variationMarginCollectedByCounterparty1Currency == null ? null : _variationMarginCollectedByCounterparty1Currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="excessCollateralPostedByTheCounterparty1")
        @RuneAttribute(value="excessCollateralPostedByTheCounterparty1")
        public CommonMarginReportBuilder setExcessCollateralPostedByTheCounterparty1(BigDecimal _excessCollateralPostedByTheCounterparty1) {
            this.excessCollateralPostedByTheCounterparty1 = _excessCollateralPostedByTheCounterparty1 == null ? null : _excessCollateralPostedByTheCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralPosted")
        @RuneAttribute(value="currencyOfTheExcessCollateralPosted")
        public CommonMarginReportBuilder setCurrencyOfTheExcessCollateralPosted(String _currencyOfTheExcessCollateralPosted) {
            this.currencyOfTheExcessCollateralPosted = _currencyOfTheExcessCollateralPosted == null ? null : _currencyOfTheExcessCollateralPosted;
            return this;
        }

        @Override
        @RosettaAttribute(value="excessCollateralCollectedByTheCounterparty1")
        @RuneAttribute(value="excessCollateralCollectedByTheCounterparty1")
        public CommonMarginReportBuilder setExcessCollateralCollectedByTheCounterparty1(BigDecimal _excessCollateralCollectedByTheCounterparty1) {
            this.excessCollateralCollectedByTheCounterparty1 = _excessCollateralCollectedByTheCounterparty1 == null ? null : _excessCollateralCollectedByTheCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="currencyOfTheExcessCollateralCollected")
        @RuneAttribute(value="currencyOfTheExcessCollateralCollected")
        public CommonMarginReportBuilder setCurrencyOfTheExcessCollateralCollected(String _currencyOfTheExcessCollateralCollected) {
            this.currencyOfTheExcessCollateralCollected = _currencyOfTheExcessCollateralCollected == null ? null : _currencyOfTheExcessCollateralCollected;
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralTimestamp")
        @RuneAttribute(value="collateralTimestamp")
        public CommonMarginReportBuilder setCollateralTimestamp(ZonedDateTime _collateralTimestamp) {
            this.collateralTimestamp = _collateralTimestamp == null ? null : _collateralTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public CommonMarginReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public CommonMarginReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public CommonMarginReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public CommonMarginReportBuilder setActionType(MarginActionEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public CommonMarginReportBuilder setEventDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp")
        @RuneAttribute(value="eventTimestamp")
        public CommonMarginReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
            this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
            return this;
        }

        @Override
        public CommonMarginReport build() {
            return new CommonMarginReportImpl(this);
        }

        @Override
        public CommonMarginReportBuilder toBuilder() {
            return this;
        }

        @Override
        public CommonMarginReportBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCollateralTimestamp() != null) {
                return true;
            }
            if (this.getVariationMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getInitialMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getReportSubmittingEntityID() != null) {
                return true;
            }
            if (this.getActionType() != null) {
                return true;
            }
            if (this.getEventDate() != null) {
                return true;
            }
            return this.getEventTimestamp() != null;
        }

        @Override
        public CommonMarginReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommonMarginReportBuilder o = (CommonMarginReportBuilder)other;
            merger.mergeBasic((Object)this.getCollateralTimestamp(), (Object)o.getCollateralTimestamp(), this::setCollateralTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginCollateralPortfolioCode(), (Object)o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginCollateralPortfolioCode(), (Object)o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportSubmittingEntityID(), (Object)o.getReportSubmittingEntityID(), this::setReportSubmittingEntityID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getActionType(), (Object)o.getActionType(), this::setActionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventDate(), (Object)o.getEventDate(), this::setEventDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventTimestamp(), (Object)o.getEventTimestamp(), this::setEventTimestamp, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommonMarginReport _that = (CommonMarginReport)this.getType().cast(o);
            if (!Objects.equals(this.collateralTimestamp, _that.getCollateralTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            return Objects.equals(this.eventTimestamp, _that.getEventTimestamp());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.collateralTimestamp != null ? this.collateralTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommonMarginReportBuilder {collateralTimestamp=" + String.valueOf(this.collateralTimestamp) + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", actionType=" + String.valueOf((Object)this.actionType) + ", eventDate=" + String.valueOf(this.eventDate) + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + "} " + super.toString();
        }
    }

    public static interface CommonMarginReportBuilder
    extends CommonMarginReport,
    CriticalDataElement.CriticalDataElementBuilder {
        @Override
        public CommonMarginReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public CommonMarginReportBuilder setCounterparty1(String var1);

        @Override
        public CommonMarginReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public CommonMarginReportBuilder setCounterparty2(String var1);

        @Override
        public CommonMarginReportBuilder setCollateralPortfolioCode(String var1);

        @Override
        public CommonMarginReportBuilder setCollateralPortfolioIndicator(Boolean var1);

        @Override
        public CommonMarginReportBuilder setUti(String var1);

        @Override
        public CommonMarginReportBuilder setCollateralisationCategory(CollateralisationType3Code var1);

        @Override
        public CommonMarginReportBuilder setInitialMarginPostedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public CommonMarginReportBuilder setInitialMarginPostedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public CommonMarginReportBuilder setInitialMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public CommonMarginReportBuilder setVariationMarginPostedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public CommonMarginReportBuilder setVariationMarginPostedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public CommonMarginReportBuilder setVariationMarginPostedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public CommonMarginReportBuilder setInitialMarginCollectedByCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public CommonMarginReportBuilder setInitialMarginCollectedByCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public CommonMarginReportBuilder setInitialMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public CommonMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PreHaircut(BigDecimal var1);

        @Override
        public CommonMarginReportBuilder setVariationMarginCollectedByTheCounterparty1PostHaircut(BigDecimal var1);

        @Override
        public CommonMarginReportBuilder setVariationMarginCollectedByCounterparty1Currency(ISOCurrencyCodeEnum var1);

        @Override
        public CommonMarginReportBuilder setExcessCollateralPostedByTheCounterparty1(BigDecimal var1);

        @Override
        public CommonMarginReportBuilder setCurrencyOfTheExcessCollateralPosted(String var1);

        @Override
        public CommonMarginReportBuilder setExcessCollateralCollectedByTheCounterparty1(BigDecimal var1);

        @Override
        public CommonMarginReportBuilder setCurrencyOfTheExcessCollateralCollected(String var1);

        public CommonMarginReportBuilder setCollateralTimestamp(ZonedDateTime var1);

        public CommonMarginReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        public CommonMarginReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        public CommonMarginReportBuilder setReportSubmittingEntityID(String var1);

        public CommonMarginReportBuilder setActionType(MarginActionEnum var1);

        public CommonMarginReportBuilder setEventDate(Date var1);

        public CommonMarginReportBuilder setEventTimestamp(ZonedDateTime var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioCode"), String.class, (Object)this.getCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, (Object)this.getCollateralPortfolioIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uti"), String.class, (Object)this.getUti(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralisationCategory"), CollateralisationType3Code.class, (Object)this.getCollateralisationCategory(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginPostedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginPostedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginPostedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginPostedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getInitialMarginCollectedByCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getInitialMarginCollectedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PreHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PreHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByTheCounterparty1PostHaircut"), BigDecimal.class, (Object)this.getVariationMarginCollectedByTheCounterparty1PostHaircut(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollectedByCounterparty1Currency"), ISOCurrencyCodeEnum.class, (Object)this.getVariationMarginCollectedByCounterparty1Currency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excessCollateralPostedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralPostedByTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralPosted"), String.class, (Object)this.getCurrencyOfTheExcessCollateralPosted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("excessCollateralCollectedByTheCounterparty1"), BigDecimal.class, (Object)this.getExcessCollateralCollectedByTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currencyOfTheExcessCollateralCollected"), String.class, (Object)this.getCurrencyOfTheExcessCollateralCollected(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("collateralTimestamp"), ZonedDateTime.class, (Object)this.getCollateralTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), MarginActionEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, (Object)this.getEventTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CommonMarginReportBuilder prune();
    }

    public static class CommonMarginReportImpl
    extends CriticalDataElement.CriticalDataElementImpl
    implements CommonMarginReport {
        private final ZonedDateTime collateralTimestamp;
        private final String variationMarginCollateralPortfolioCode;
        private final String initialMarginCollateralPortfolioCode;
        private final String reportSubmittingEntityID;
        private final MarginActionEnum actionType;
        private final Date eventDate;
        private final ZonedDateTime eventTimestamp;

        protected CommonMarginReportImpl(CommonMarginReportBuilder builder) {
            super(builder);
            this.collateralTimestamp = builder.getCollateralTimestamp();
            this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
            this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
            this.reportSubmittingEntityID = builder.getReportSubmittingEntityID();
            this.actionType = builder.getActionType();
            this.eventDate = builder.getEventDate();
            this.eventTimestamp = builder.getEventTimestamp();
        }

        @Override
        @RosettaAttribute(value="collateralTimestamp")
        @RuneAttribute(value="collateralTimestamp")
        public ZonedDateTime getCollateralTimestamp() {
            return this.collateralTimestamp;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public MarginActionEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="eventTimestamp")
        @RuneAttribute(value="eventTimestamp")
        public ZonedDateTime getEventTimestamp() {
            return this.eventTimestamp;
        }

        @Override
        public CommonMarginReport build() {
            return this;
        }

        @Override
        public CommonMarginReportBuilder toBuilder() {
            CommonMarginReportBuilder builder = CommonMarginReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommonMarginReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCollateralTimestamp()).ifPresent(builder::setCollateralTimestamp);
            Optional.ofNullable(this.getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
            Optional.ofNullable(this.getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
            Optional.ofNullable(this.getReportSubmittingEntityID()).ifPresent(builder::setReportSubmittingEntityID);
            Optional.ofNullable(this.getActionType()).ifPresent(builder::setActionType);
            Optional.ofNullable(this.getEventDate()).ifPresent(builder::setEventDate);
            Optional.ofNullable(this.getEventTimestamp()).ifPresent(builder::setEventTimestamp);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommonMarginReport _that = (CommonMarginReport)this.getType().cast(o);
            if (!Objects.equals(this.collateralTimestamp, _that.getCollateralTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            return Objects.equals(this.eventTimestamp, _that.getEventTimestamp());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.collateralTimestamp != null ? this.collateralTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamp != null ? this.eventTimestamp.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommonMarginReport {collateralTimestamp=" + String.valueOf(this.collateralTimestamp) + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", actionType=" + String.valueOf((Object)this.actionType) + ", eventDate=" + String.valueOf(this.eventDate) + ", eventTimestamp=" + String.valueOf(this.eventTimestamp) + "} " + super.toString();
        }
    }
}

