/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.payment.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.payment.OtherPayment;
import drr.regulation.common.CommonAssetClass;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.PaymentType4Code;
import java.util.Collections;
import java.util.List;

@ImplementedBy(value=OtherPaymentType_02B_ValidationDefault.class)
public abstract class OtherPaymentType_02B_Validation
implements RosettaFunction {
    public Boolean evaluate(ActionTypeEnum actionType, CommonAssetClass assetClass, List<? extends OtherPayment> otherPayment) {
        Boolean result = this.doEvaluate(actionType, assetClass, otherPayment);
        return result;
    }

    protected abstract Boolean doEvaluate(ActionTypeEnum var1, CommonAssetClass var2, List<? extends OtherPayment> var3);

    public static class OtherPaymentType_02B_ValidationDefault
    extends OtherPaymentType_02B_Validation {
        @Override
        protected Boolean doEvaluate(ActionTypeEnum actionType, CommonAssetClass assetClass, List<? extends OtherPayment> otherPayment) {
            if (otherPayment == null) {
                otherPayment = Collections.emptyList();
            }
            Boolean result = null;
            return this.assignOutput(result, actionType, assetClass, otherPayment);
        }

        protected Boolean assignOutput(Boolean result, ActionTypeEnum actionType, CommonAssetClass assetClass, List<? extends OtherPayment> otherPayment) {
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)ActionTypeEnum.TERM)), (Mapper)MapperS.of((Object)((Object)actionType)), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)assetClass)), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.CRDT)), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperC.of(otherPayment).map("getAmount", _otherPayment -> _otherPayment.getAmount())).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperC.of(otherPayment).map("getCurrency", _otherPayment -> _otherPayment.getCurrency()))).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperC.of(otherPayment).map("getPayer", _otherPayment -> _otherPayment.getPayer()))).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperC.of(otherPayment).map("getReceiver", _otherPayment -> _otherPayment.getReceiver())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ComparisonResult ifThenElseResult = ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getPaymentType", _otherPayment -> _otherPayment.getPaymentType()).resultCount()), (Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getAmount", _otherPayment -> _otherPayment.getAmount()).resultCount()), (CardinalityOperator)CardinalityOperator.Any).orNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getPaymentType", _otherPayment -> _otherPayment.getPaymentType()).resultCount()), (Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getCurrency", _otherPayment -> _otherPayment.getCurrency()).resultCount()), (CardinalityOperator)CardinalityOperator.Any)).orNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getPaymentType", _otherPayment -> _otherPayment.getPaymentType()).resultCount()), (Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getDate", _otherPayment -> _otherPayment.getDate()).resultCount()), (CardinalityOperator)CardinalityOperator.Any)).orNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getPaymentType", _otherPayment -> _otherPayment.getPaymentType()).resultCount()), (Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getPayer", _otherPayment -> _otherPayment.getPayer()).resultCount()), (CardinalityOperator)CardinalityOperator.Any)).orNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getPaymentType", _otherPayment -> _otherPayment.getPaymentType()).resultCount()), (Mapper)MapperS.of((Object)MapperC.of(otherPayment).map("getReceiver", _otherPayment -> _otherPayment.getReceiver()).resultCount()), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)) != false ? ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)false)) : ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)true));
                result = ExpressionOperatorsNullSafe.exists((Mapper)MapperC.of(otherPayment).map("getPaymentType", _otherPayment -> _otherPayment.getPaymentType())).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of(otherPayment).map("getPaymentType", _otherPayment -> _otherPayment.getPaymentType()), (Mapper)MapperS.of((Object)((Object)PaymentType4Code.UWIN)), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ifThenElseResult).get();
            } else {
                result = null;
            }
            return result;
        }
    }
}

