/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.underlier.functions;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=GetUnderlierLEIForCreditDefault.class)
public abstract class GetUnderlierLEIForCredit
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public List<String> evaluate(Product product) {
        List<String> lei = this.doEvaluate(product);
        return lei;
    }

    protected abstract List<String> doEvaluate(Product var1);

    public static class GetUnderlierLEIForCreditDefault
    extends GetUnderlierLEIForCredit {
        @Override
        protected List<String> doEvaluate(Product product) {
            ArrayList<String> lei = new ArrayList<String>();
            return this.assignOutput(lei, product);
        }

        protected List<String> assignOutput(List<String> lei, Product product) {
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity()).mapC("getEntityId", legalEntity -> legalEntity.getEntityId())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                lei.addAll(MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity()).mapC("getEntityId", legalEntity -> legalEntity.getEntityId()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti());
            } else if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity()).mapC("getEntityId", legalEntity -> legalEntity.getEntityId())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                lei.addAll(MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate(product))).map("getPayout", economicTerms -> economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getGeneralTerms", creditDefaultPayout -> creditDefaultPayout.getGeneralTerms()).map("getReferenceInformation", generalTerms -> generalTerms.getReferenceInformation()).map("getReferenceEntity", referenceInformation -> referenceInformation.getReferenceEntity()).mapC("getEntityId", legalEntity -> legalEntity.getEntityId()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString.getValue()).getMulti());
            } else {
                lei.addAll(Collections.emptyList());
            }
            return lei;
        }
    }
}

