/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.TechnicalRecordId;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TechnicalRecordIdIsUnique")
@ImplementedBy(value=Default.class)
public interface TechnicalRecordIdIsUnique
extends Validator<TechnicalRecordId> {
    public static final String NAME = "TechnicalRecordIdIsUnique";
    public static final String DEFINITION = "if isUnique exists then id exists";

    public static class NoOp
    implements TechnicalRecordIdIsUnique {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TechnicalRecordId technicalRecordId) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TechnicalRecordIdIsUnique {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, TechnicalRecordId technicalRecordId) {
            ComparisonResult result = this.executeDataRule(technicalRecordId);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TechnicalRecordIdIsUnique.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TechnicalRecordId", (RosettaPath)path, (String)TechnicalRecordIdIsUnique.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TechnicalRecordIdIsUnique.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"TechnicalRecordId", (RosettaPath)path, (String)TechnicalRecordIdIsUnique.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(TechnicalRecordId technicalRecordId) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)technicalRecordId).map("getIsUnique", _technicalRecordId -> _technicalRecordId.getIsUnique())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)technicalRecordId).map("getId", _technicalRecordId -> _technicalRecordId.getId()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

