/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.valuation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.valuation.CriticalDataElement;
import drr.regulation.common.valuation.meta.CommonValuationReportMeta;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CommonValuationReport", builder=CommonValuationReportBuilderImpl.class, version="7.0.0-dev.85")
@RuneDataType(value="CommonValuationReport", model="drr", builder=CommonValuationReportBuilderImpl.class, version="7.0.0-dev.85")
public interface CommonValuationReport
extends CriticalDataElement {
    public static final CommonValuationReportMeta metaData = new CommonValuationReportMeta();

    public String getTechnicalRecordId();

    public String getReportSubmittingEntityID();

    public String getEntityResponsibleForReporting();

    public String getCounterparty2IdentifierSource();

    public Date getNextFloatingReferenceResetDateLeg1();

    public Date getNextFloatingReferenceResetDateLeg2();

    public String getUniqueTransactionIdentifier();

    public String getUniqueTransactionIdentifierProprietary();

    public Date getEventDate();

    public String getVariationMarginCollateralPortfolioCode();

    public String getInitialMarginCollateralPortfolioCode();

    public BigDecimal getLastFloatingReferenceValueLeg1();

    public BigDecimal getLastFloatingReferenceValueLeg2();

    public Date getLastFloatingReferenceResetDateLeg1();

    public Date getLastFloatingReferenceResetDateLeg2();

    @Override
    public CommonValuationReport build();

    @Override
    public CommonValuationReportBuilder toBuilder();

    public static CommonValuationReportBuilder builder() {
        return new CommonValuationReportBuilderImpl();
    }

    default public RosettaMetaData<? extends CommonValuationReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CommonValuationReport> getType() {
        return CommonValuationReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg1"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg2"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class CommonValuationReportBuilderImpl
    extends CriticalDataElement.CriticalDataElementBuilderImpl
    implements CommonValuationReportBuilder {
        protected String technicalRecordId;
        protected String reportSubmittingEntityID;
        protected String entityResponsibleForReporting;
        protected String counterparty2IdentifierSource;
        protected Date nextFloatingReferenceResetDateLeg1;
        protected Date nextFloatingReferenceResetDateLeg2;
        protected String uniqueTransactionIdentifier;
        protected String uniqueTransactionIdentifierProprietary;
        protected Date eventDate;
        protected String variationMarginCollateralPortfolioCode;
        protected String initialMarginCollateralPortfolioCode;
        protected BigDecimal lastFloatingReferenceValueLeg1;
        protected BigDecimal lastFloatingReferenceValueLeg2;
        protected Date lastFloatingReferenceResetDateLeg1;
        protected Date lastFloatingReferenceResetDateLeg2;

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID")
        @RuneAttribute(value="reportSubmittingEntityID")
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public String getEntityResponsibleForReporting() {
            return this.entityResponsibleForReporting;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource")
        @RuneAttribute(value="counterparty2IdentifierSource")
        public String getCounterparty2IdentifierSource() {
            return this.counterparty2IdentifierSource;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public Date getNextFloatingReferenceResetDateLeg1() {
            return this.nextFloatingReferenceResetDateLeg1;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public Date getNextFloatingReferenceResetDateLeg2() {
            return this.nextFloatingReferenceResetDateLeg2;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public String getUniqueTransactionIdentifierProprietary() {
            return this.uniqueTransactionIdentifierProprietary;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg1")
        @RuneAttribute(value="lastFloatingReferenceValueLeg1")
        public BigDecimal getLastFloatingReferenceValueLeg1() {
            return this.lastFloatingReferenceValueLeg1;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg2")
        @RuneAttribute(value="lastFloatingReferenceValueLeg2")
        public BigDecimal getLastFloatingReferenceValueLeg2() {
            return this.lastFloatingReferenceValueLeg2;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg1")
        public Date getLastFloatingReferenceResetDateLeg1() {
            return this.lastFloatingReferenceResetDateLeg1;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg2")
        public Date getLastFloatingReferenceResetDateLeg2() {
            return this.lastFloatingReferenceResetDateLeg2;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public CommonValuationReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public CommonValuationReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType")
        @RuneAttribute(value="counterparty2IdentifierType")
        public CommonValuationReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public CommonValuationReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount", isRequired=true)
        @RuneAttribute(value="valuationAmount", isRequired=true)
        public CommonValuationReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency", isRequired=true)
        @RuneAttribute(value="valuationCurrency", isRequired=true)
        public CommonValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp", isRequired=true)
        @RuneAttribute(value="valuationTimestamp", isRequired=true)
        public CommonValuationReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod", isRequired=true)
        @RuneAttribute(value="valuationMethod", isRequired=true)
        public CommonValuationReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public CommonValuationReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public CommonValuationReportBuilder setActionType(ActionTypeEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public CommonValuationReportBuilder setLevel(ReportLevelEnum _level) {
            this.level = _level == null ? null : _level;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public CommonValuationReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID")
        @RuneAttribute(value="reportSubmittingEntityID")
        public CommonValuationReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public CommonValuationReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource")
        @RuneAttribute(value="counterparty2IdentifierSource")
        public CommonValuationReportBuilder setCounterparty2IdentifierSource(String _counterparty2IdentifierSource) {
            this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public CommonValuationReportBuilder setNextFloatingReferenceResetDateLeg1(Date _nextFloatingReferenceResetDateLeg1) {
            this.nextFloatingReferenceResetDateLeg1 = _nextFloatingReferenceResetDateLeg1 == null ? null : _nextFloatingReferenceResetDateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public CommonValuationReportBuilder setNextFloatingReferenceResetDateLeg2(Date _nextFloatingReferenceResetDateLeg2) {
            this.nextFloatingReferenceResetDateLeg2 = _nextFloatingReferenceResetDateLeg2 == null ? null : _nextFloatingReferenceResetDateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        public CommonValuationReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public CommonValuationReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public CommonValuationReportBuilder setEventDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public CommonValuationReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public CommonValuationReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg1")
        @RuneAttribute(value="lastFloatingReferenceValueLeg1")
        public CommonValuationReportBuilder setLastFloatingReferenceValueLeg1(BigDecimal _lastFloatingReferenceValueLeg1) {
            this.lastFloatingReferenceValueLeg1 = _lastFloatingReferenceValueLeg1 == null ? null : _lastFloatingReferenceValueLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg2")
        @RuneAttribute(value="lastFloatingReferenceValueLeg2")
        public CommonValuationReportBuilder setLastFloatingReferenceValueLeg2(BigDecimal _lastFloatingReferenceValueLeg2) {
            this.lastFloatingReferenceValueLeg2 = _lastFloatingReferenceValueLeg2 == null ? null : _lastFloatingReferenceValueLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg1")
        public CommonValuationReportBuilder setLastFloatingReferenceResetDateLeg1(Date _lastFloatingReferenceResetDateLeg1) {
            this.lastFloatingReferenceResetDateLeg1 = _lastFloatingReferenceResetDateLeg1 == null ? null : _lastFloatingReferenceResetDateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg2")
        public CommonValuationReportBuilder setLastFloatingReferenceResetDateLeg2(Date _lastFloatingReferenceResetDateLeg2) {
            this.lastFloatingReferenceResetDateLeg2 = _lastFloatingReferenceResetDateLeg2 == null ? null : _lastFloatingReferenceResetDateLeg2;
            return this;
        }

        @Override
        public CommonValuationReport build() {
            return new CommonValuationReportImpl(this);
        }

        @Override
        public CommonValuationReportBuilder toBuilder() {
            return this;
        }

        @Override
        public CommonValuationReportBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTechnicalRecordId() != null) {
                return true;
            }
            if (this.getReportSubmittingEntityID() != null) {
                return true;
            }
            if (this.getEntityResponsibleForReporting() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierSource() != null) {
                return true;
            }
            if (this.getNextFloatingReferenceResetDateLeg1() != null) {
                return true;
            }
            if (this.getNextFloatingReferenceResetDateLeg2() != null) {
                return true;
            }
            if (this.getUniqueTransactionIdentifier() != null) {
                return true;
            }
            if (this.getUniqueTransactionIdentifierProprietary() != null) {
                return true;
            }
            if (this.getEventDate() != null) {
                return true;
            }
            if (this.getVariationMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getInitialMarginCollateralPortfolioCode() != null) {
                return true;
            }
            if (this.getLastFloatingReferenceValueLeg1() != null) {
                return true;
            }
            if (this.getLastFloatingReferenceValueLeg2() != null) {
                return true;
            }
            if (this.getLastFloatingReferenceResetDateLeg1() != null) {
                return true;
            }
            return this.getLastFloatingReferenceResetDateLeg2() != null;
        }

        @Override
        public CommonValuationReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            CommonValuationReportBuilder o = (CommonValuationReportBuilder)other;
            merger.mergeBasic((Object)this.getTechnicalRecordId(), (Object)o.getTechnicalRecordId(), this::setTechnicalRecordId, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportSubmittingEntityID(), (Object)o.getReportSubmittingEntityID(), this::setReportSubmittingEntityID, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEntityResponsibleForReporting(), (Object)o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierSource(), (Object)o.getCounterparty2IdentifierSource(), this::setCounterparty2IdentifierSource, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNextFloatingReferenceResetDateLeg1(), (Object)o.getNextFloatingReferenceResetDateLeg1(), this::setNextFloatingReferenceResetDateLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNextFloatingReferenceResetDateLeg2(), (Object)o.getNextFloatingReferenceResetDateLeg2(), this::setNextFloatingReferenceResetDateLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifier(), (Object)o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifierProprietary(), (Object)o.getUniqueTransactionIdentifierProprietary(), this::setUniqueTransactionIdentifierProprietary, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEventDate(), (Object)o.getEventDate(), this::setEventDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getVariationMarginCollateralPortfolioCode(), (Object)o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getInitialMarginCollateralPortfolioCode(), (Object)o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLastFloatingReferenceValueLeg1(), (Object)o.getLastFloatingReferenceValueLeg1(), this::setLastFloatingReferenceValueLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLastFloatingReferenceValueLeg2(), (Object)o.getLastFloatingReferenceValueLeg2(), this::setLastFloatingReferenceValueLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLastFloatingReferenceResetDateLeg1(), (Object)o.getLastFloatingReferenceResetDateLeg1(), this::setLastFloatingReferenceResetDateLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLastFloatingReferenceResetDateLeg2(), (Object)o.getLastFloatingReferenceResetDateLeg2(), this::setLastFloatingReferenceResetDateLeg2, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommonValuationReport _that = (CommonValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg1, _that.getNextFloatingReferenceResetDateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg2, _that.getNextFloatingReferenceResetDateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) {
                return false;
            }
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReferenceValueLeg1, _that.getLastFloatingReferenceValueLeg1())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReferenceValueLeg2, _that.getLastFloatingReferenceValueLeg2())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReferenceResetDateLeg1, _that.getLastFloatingReferenceResetDateLeg1())) {
                return false;
            }
            return Objects.equals(this.lastFloatingReferenceResetDateLeg2, _that.getLastFloatingReferenceResetDateLeg2());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.entityResponsibleForReporting != null ? this.entityResponsibleForReporting.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierSource != null ? this.counterparty2IdentifierSource.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg1 != null ? this.nextFloatingReferenceResetDateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg2 != null ? this.nextFloatingReferenceResetDateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietary != null ? this.uniqueTransactionIdentifierProprietary.hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceValueLeg1 != null ? this.lastFloatingReferenceValueLeg1.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceValueLeg2 != null ? this.lastFloatingReferenceValueLeg2.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceResetDateLeg1 != null ? this.lastFloatingReferenceResetDateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceResetDateLeg2 != null ? this.lastFloatingReferenceResetDateLeg2.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommonValuationReportBuilder {technicalRecordId=" + this.technicalRecordId + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", nextFloatingReferenceResetDateLeg1=" + String.valueOf(this.nextFloatingReferenceResetDateLeg1) + ", nextFloatingReferenceResetDateLeg2=" + String.valueOf(this.nextFloatingReferenceResetDateLeg2) + ", uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", eventDate=" + String.valueOf(this.eventDate) + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", lastFloatingReferenceValueLeg1=" + String.valueOf(this.lastFloatingReferenceValueLeg1) + ", lastFloatingReferenceValueLeg2=" + String.valueOf(this.lastFloatingReferenceValueLeg2) + ", lastFloatingReferenceResetDateLeg1=" + String.valueOf(this.lastFloatingReferenceResetDateLeg1) + ", lastFloatingReferenceResetDateLeg2=" + String.valueOf(this.lastFloatingReferenceResetDateLeg2) + "} " + super.toString();
        }
    }

    public static interface CommonValuationReportBuilder
    extends CommonValuationReport,
    CriticalDataElement.CriticalDataElementBuilder {
        @Override
        public CommonValuationReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public CommonValuationReportBuilder setCounterparty1(String var1);

        @Override
        public CommonValuationReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public CommonValuationReportBuilder setCounterparty2(String var1);

        @Override
        public CommonValuationReportBuilder setValuationAmount(BigDecimal var1);

        @Override
        public CommonValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public CommonValuationReportBuilder setValuationTimestamp(ZonedDateTime var1);

        @Override
        public CommonValuationReportBuilder setValuationMethod(ValuationType1Code var1);

        @Override
        public CommonValuationReportBuilder setDelta(BigDecimal var1);

        @Override
        public CommonValuationReportBuilder setActionType(ActionTypeEnum var1);

        @Override
        public CommonValuationReportBuilder setLevel(ReportLevelEnum var1);

        public CommonValuationReportBuilder setTechnicalRecordId(String var1);

        public CommonValuationReportBuilder setReportSubmittingEntityID(String var1);

        public CommonValuationReportBuilder setEntityResponsibleForReporting(String var1);

        public CommonValuationReportBuilder setCounterparty2IdentifierSource(String var1);

        public CommonValuationReportBuilder setNextFloatingReferenceResetDateLeg1(Date var1);

        public CommonValuationReportBuilder setNextFloatingReferenceResetDateLeg2(Date var1);

        public CommonValuationReportBuilder setUniqueTransactionIdentifier(String var1);

        public CommonValuationReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        public CommonValuationReportBuilder setEventDate(Date var1);

        public CommonValuationReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        public CommonValuationReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        public CommonValuationReportBuilder setLastFloatingReferenceValueLeg1(BigDecimal var1);

        public CommonValuationReportBuilder setLastFloatingReferenceValueLeg2(BigDecimal var1);

        public CommonValuationReportBuilder setLastFloatingReferenceResetDateLeg1(Date var1);

        public CommonValuationReportBuilder setLastFloatingReferenceResetDateLeg2(Date var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg1"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg2"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public CommonValuationReportBuilder prune();
    }

    public static class CommonValuationReportImpl
    extends CriticalDataElement.CriticalDataElementImpl
    implements CommonValuationReport {
        private final String technicalRecordId;
        private final String reportSubmittingEntityID;
        private final String entityResponsibleForReporting;
        private final String counterparty2IdentifierSource;
        private final Date nextFloatingReferenceResetDateLeg1;
        private final Date nextFloatingReferenceResetDateLeg2;
        private final String uniqueTransactionIdentifier;
        private final String uniqueTransactionIdentifierProprietary;
        private final Date eventDate;
        private final String variationMarginCollateralPortfolioCode;
        private final String initialMarginCollateralPortfolioCode;
        private final BigDecimal lastFloatingReferenceValueLeg1;
        private final BigDecimal lastFloatingReferenceValueLeg2;
        private final Date lastFloatingReferenceResetDateLeg1;
        private final Date lastFloatingReferenceResetDateLeg2;

        protected CommonValuationReportImpl(CommonValuationReportBuilder builder) {
            super(builder);
            this.technicalRecordId = builder.getTechnicalRecordId();
            this.reportSubmittingEntityID = builder.getReportSubmittingEntityID();
            this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
            this.counterparty2IdentifierSource = builder.getCounterparty2IdentifierSource();
            this.nextFloatingReferenceResetDateLeg1 = builder.getNextFloatingReferenceResetDateLeg1();
            this.nextFloatingReferenceResetDateLeg2 = builder.getNextFloatingReferenceResetDateLeg2();
            this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
            this.uniqueTransactionIdentifierProprietary = builder.getUniqueTransactionIdentifierProprietary();
            this.eventDate = builder.getEventDate();
            this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
            this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
            this.lastFloatingReferenceValueLeg1 = builder.getLastFloatingReferenceValueLeg1();
            this.lastFloatingReferenceValueLeg2 = builder.getLastFloatingReferenceValueLeg2();
            this.lastFloatingReferenceResetDateLeg1 = builder.getLastFloatingReferenceResetDateLeg1();
            this.lastFloatingReferenceResetDateLeg2 = builder.getLastFloatingReferenceResetDateLeg2();
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID")
        @RuneAttribute(value="reportSubmittingEntityID")
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public String getEntityResponsibleForReporting() {
            return this.entityResponsibleForReporting;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource")
        @RuneAttribute(value="counterparty2IdentifierSource")
        public String getCounterparty2IdentifierSource() {
            return this.counterparty2IdentifierSource;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public Date getNextFloatingReferenceResetDateLeg1() {
            return this.nextFloatingReferenceResetDateLeg1;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public Date getNextFloatingReferenceResetDateLeg2() {
            return this.nextFloatingReferenceResetDateLeg2;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public String getUniqueTransactionIdentifierProprietary() {
            return this.uniqueTransactionIdentifierProprietary;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public Date getEventDate() {
            return this.eventDate;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public String getVariationMarginCollateralPortfolioCode() {
            return this.variationMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public String getInitialMarginCollateralPortfolioCode() {
            return this.initialMarginCollateralPortfolioCode;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg1")
        @RuneAttribute(value="lastFloatingReferenceValueLeg1")
        public BigDecimal getLastFloatingReferenceValueLeg1() {
            return this.lastFloatingReferenceValueLeg1;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg2")
        @RuneAttribute(value="lastFloatingReferenceValueLeg2")
        public BigDecimal getLastFloatingReferenceValueLeg2() {
            return this.lastFloatingReferenceValueLeg2;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg1")
        public Date getLastFloatingReferenceResetDateLeg1() {
            return this.lastFloatingReferenceResetDateLeg1;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg2")
        public Date getLastFloatingReferenceResetDateLeg2() {
            return this.lastFloatingReferenceResetDateLeg2;
        }

        @Override
        public CommonValuationReport build() {
            return this;
        }

        @Override
        public CommonValuationReportBuilder toBuilder() {
            CommonValuationReportBuilder builder = CommonValuationReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CommonValuationReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
            Optional.ofNullable(this.getReportSubmittingEntityID()).ifPresent(builder::setReportSubmittingEntityID);
            Optional.ofNullable(this.getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReporting);
            Optional.ofNullable(this.getCounterparty2IdentifierSource()).ifPresent(builder::setCounterparty2IdentifierSource);
            Optional.ofNullable(this.getNextFloatingReferenceResetDateLeg1()).ifPresent(builder::setNextFloatingReferenceResetDateLeg1);
            Optional.ofNullable(this.getNextFloatingReferenceResetDateLeg2()).ifPresent(builder::setNextFloatingReferenceResetDateLeg2);
            Optional.ofNullable(this.getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
            Optional.ofNullable(this.getUniqueTransactionIdentifierProprietary()).ifPresent(builder::setUniqueTransactionIdentifierProprietary);
            Optional.ofNullable(this.getEventDate()).ifPresent(builder::setEventDate);
            Optional.ofNullable(this.getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
            Optional.ofNullable(this.getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
            Optional.ofNullable(this.getLastFloatingReferenceValueLeg1()).ifPresent(builder::setLastFloatingReferenceValueLeg1);
            Optional.ofNullable(this.getLastFloatingReferenceValueLeg2()).ifPresent(builder::setLastFloatingReferenceValueLeg2);
            Optional.ofNullable(this.getLastFloatingReferenceResetDateLeg1()).ifPresent(builder::setLastFloatingReferenceResetDateLeg1);
            Optional.ofNullable(this.getLastFloatingReferenceResetDateLeg2()).ifPresent(builder::setLastFloatingReferenceResetDateLeg2);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CommonValuationReport _that = (CommonValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg1, _that.getNextFloatingReferenceResetDateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg2, _that.getNextFloatingReferenceResetDateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) {
                return false;
            }
            if (!Objects.equals(this.eventDate, _that.getEventDate())) {
                return false;
            }
            if (!Objects.equals(this.variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReferenceValueLeg1, _that.getLastFloatingReferenceValueLeg1())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReferenceValueLeg2, _that.getLastFloatingReferenceValueLeg2())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReferenceResetDateLeg1, _that.getLastFloatingReferenceResetDateLeg1())) {
                return false;
            }
            return Objects.equals(this.lastFloatingReferenceResetDateLeg2, _that.getLastFloatingReferenceResetDateLeg2());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.entityResponsibleForReporting != null ? this.entityResponsibleForReporting.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierSource != null ? this.counterparty2IdentifierSource.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg1 != null ? this.nextFloatingReferenceResetDateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg2 != null ? this.nextFloatingReferenceResetDateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietary != null ? this.uniqueTransactionIdentifierProprietary.hashCode() : 0);
            _result = 31 * _result + (this.eventDate != null ? this.eventDate.hashCode() : 0);
            _result = 31 * _result + (this.variationMarginCollateralPortfolioCode != null ? this.variationMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.initialMarginCollateralPortfolioCode != null ? this.initialMarginCollateralPortfolioCode.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceValueLeg1 != null ? this.lastFloatingReferenceValueLeg1.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceValueLeg2 != null ? this.lastFloatingReferenceValueLeg2.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceResetDateLeg1 != null ? this.lastFloatingReferenceResetDateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReferenceResetDateLeg2 != null ? this.lastFloatingReferenceResetDateLeg2.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "CommonValuationReport {technicalRecordId=" + this.technicalRecordId + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", nextFloatingReferenceResetDateLeg1=" + String.valueOf(this.nextFloatingReferenceResetDateLeg1) + ", nextFloatingReferenceResetDateLeg2=" + String.valueOf(this.nextFloatingReferenceResetDateLeg2) + ", uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", eventDate=" + String.valueOf(this.eventDate) + ", variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode + ", initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", lastFloatingReferenceValueLeg1=" + String.valueOf(this.lastFloatingReferenceValueLeg1) + ", lastFloatingReferenceValueLeg2=" + String.valueOf(this.lastFloatingReferenceValueLeg2) + ", lastFloatingReferenceResetDateLeg1=" + String.valueOf(this.lastFloatingReferenceResetDateLeg1) + ", lastFloatingReferenceResetDateLeg2=" + String.valueOf(this.lastFloatingReferenceResetDateLeg2) + "} " + super.toString();
        }
    }
}

