/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.functions;

import cdm.base.datetime.PeriodEnum;
import cdm.base.staticdata.asset.rates.FloatingRateIndexEnum;
import cdm.product.asset.InterestRatePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.PeriodCalculation;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=InterestRateLeg2BasisDefault.class)
public abstract class InterestRateLeg2Basis
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected PeriodCalculation periodCalculation;

    public InterestRatePayout evaluate(Product product) {
        InterestRatePayout interestRateLeg2;
        InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2Builder = this.doEvaluate(product);
        if (interestRateLeg2Builder == null) {
            interestRateLeg2 = null;
        } else {
            interestRateLeg2 = interestRateLeg2Builder.build();
            this.objectValidator.validate(InterestRatePayout.class, (RosettaModelObject)interestRateLeg2);
        }
        return interestRateLeg2;
    }

    protected abstract InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> interestRatePayouts(Product var1);

    public static class InterestRateLeg2BasisDefault
    extends InterestRateLeg2Basis {
        @Override
        protected InterestRatePayout.InterestRatePayoutBuilder doEvaluate(Product product) {
            InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2 = InterestRatePayout.builder();
            return this.assignOutput(interestRateLeg2, product);
        }

        protected InterestRatePayout.InterestRatePayoutBuilder assignOutput(InterestRatePayout.InterestRatePayoutBuilder interestRateLeg2, Product product) {
            interestRateLeg2 = ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)ExpressionOperatorsNullSafe.distinct((Mapper)this.interestRatePayouts(product).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRatePayouts(product).max(item -> item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption == null ? null : referenceWithMetaFloatingRateOption.getValue()).map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex()).map("Type coercion", fieldWithMetaFloatingRateIndexEnum -> fieldWithMetaFloatingRateIndexEnum == null ? null : fieldWithMetaFloatingRateIndexEnum.getValue()).map("to-string", FloatingRateIndexEnum::toDisplayString)).get()) : (ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)this.interestRatePayouts(product).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex()).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)ExpressionOperatorsNullSafe.distinct((Mapper)this.interestRatePayouts(product).map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).map("Type coercion", referenceWithMetaFloatingRateOption -> referenceWithMetaFloatingRateOption.getValue()).map("getFloatingRateIndex", floatingRateOption -> floatingRateOption.getFloatingRateIndex())).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? (InterestRatePayout.InterestRatePayoutBuilder)this.toBuilder((RosettaModelObject)this.interestRatePayouts(product).max(item -> MapperS.of((Object)this.periodCalculation.evaluate((PeriodEnum)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).map("Type coercion", referenceWithMetaFloatingRateOption0 -> referenceWithMetaFloatingRateOption0 == null ? null : referenceWithMetaFloatingRateOption0.getValue()).map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).map("getPeriod", period -> period.getPeriod()).get(), (Integer)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate()).map("getRateOption", floatingRateSpecification -> floatingRateSpecification.getRateOption()).map("Type coercion", referenceWithMetaFloatingRateOption1 -> referenceWithMetaFloatingRateOption1 == null ? null : referenceWithMetaFloatingRateOption1.getValue()).map("getIndexTenor", floatingRateOption -> floatingRateOption.getIndexTenor()).map("getPeriodMultiplier", period -> period.getPeriodMultiplier()).get()))).get()) : null);
            return Optional.ofNullable(interestRateLeg2).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperC<? extends InterestRatePayout> interestRatePayouts(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
        }
    }
}

