/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.standards.iosco.cde.version3.party.reports.Direction1BuyerIdentifierRule;
import javax.inject.Inject;

@ImplementedBy(value=BuyerIdentifierRuleDefault.class)
public abstract class BuyerIdentifierRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected Direction1BuyerIdentifierRule direction1BuyerIdentifierRule;
    @Inject
    protected IsAllowableActionForCSA isAllowableActionForCSA;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class BuyerIdentifierRuleDefault
    extends BuyerIdentifierRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCSA.evaluate((ReportableEventBase)item.get()));
            output = (String)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.direction1BuyerIdentifierRule.evaluate((TransactionReportInstruction)item.get()))).get();
            return output;
        }
    }
}

