/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.reports;

import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForEvent;
import drr.base.trade.price.PricePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.csa.rewrite.trade.functions.IsAllowableActionForCSA;
import drr.regulation.csa.rewrite.trade.reports.PriceNotationRule;
import drr.standards.iosco.cde.version3.price.functions.GetReportablePricePeriod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=ContractPriceScheduleRuleDefault.class)
public abstract class ContractPriceScheduleRule
implements ReportFunction<TransactionReportInstruction, List<? extends PricePeriod>> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected GetReportablePricePeriod getReportablePricePeriod;
    @Inject
    protected IsAllowableActionForCSA isAllowableActionForCSA;
    @Inject
    protected PriceNotationRule priceNotationRule;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
    @Inject
    protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;

    public List<? extends PricePeriod> evaluate(TransactionReportInstruction input) {
        List output;
        List<PricePeriod.PricePeriodBuilder> outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.stream().map(PricePeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(PricePeriod.class, output);
        }
        return output;
    }

    protected abstract List<PricePeriod.PricePeriodBuilder> doEvaluate(TransactionReportInstruction var1);

    public static class ContractPriceScheduleRuleDefault
    extends ContractPriceScheduleRule {
        @Override
        protected List<PricePeriod.PricePeriodBuilder> doEvaluate(TransactionReportInstruction input) {
            ArrayList<PricePeriod.PricePeriodBuilder> output = new ArrayList<PricePeriod.PricePeriodBuilder>();
            return this.assignOutput(output, input);
        }

        protected List<PricePeriod.PricePeriodBuilder> assignOutput(List<PricePeriod.PricePeriodBuilder> output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCSA.evaluate((ReportableEventBase)item.get()));
            MapperS thenArg1 = thenArg0.filterSingleNullSafe(item -> ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_AssetClass_Commodity.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate((ReportableEventBase)item.get()))))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_AssetClass_Equity.evaluate(this.economicTermsForProduct.evaluate(this.productForEvent.evaluate((ReportableEventBase)item.get())))))).get());
            output = this.toBuilder(thenArg1.mapSingleToList(item -> MapperC.of(this.getReportablePricePeriod.evaluate((ReportableEventBase)item.get(), this.priceNotationRule.evaluate((TransactionReportInstruction)item.get())))).getMulti());
            return Optional.ofNullable(output).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

