/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.trade.CSATransactionReportTrade;
import drr.standards.iosco.upi.AnnaDsbAssetClassEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CSATransactionReportTradeCSA_VR_0130_01")
@ImplementedBy(value=Default.class)
public interface CSATransactionReportTradeCSA_VR_0130_01
extends Validator<CSATransactionReportTrade> {
    public static final String NAME = "CSATransactionReportTradeCSA_VR_0130_01";
    public static final String DEFINITION = "if (nonReportable -> postUpiData -> Header -> AssetClass exists and [AnnaDsbAssetClassEnum -> Equity, AnnaDsbAssetClassEnum -> Credit] any <> nonReportable -> postUpiData -> Header -> AssetClass) or [AssetClassEnum -> Equity, AssetClassEnum -> Credit] any <> dtccAdditionalFields -> primaryAssetClass then leg1 -> underlyingAssetTradingPlatformIdentifier is absent and leg2 -> underlyingAssetTradingPlatformIdentifier is absent";

    public static class NoOp
    implements CSATransactionReportTradeCSA_VR_0130_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReportTrade cSATransactionReportTrade) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CSATransactionReportTradeCSA_VR_0130_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReportTrade cSATransactionReportTrade) {
            ComparisonResult result = this.executeDataRule(cSATransactionReportTrade);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CSATransactionReportTradeCSA_VR_0130_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReportTrade", (RosettaPath)path, (String)CSATransactionReportTradeCSA_VR_0130_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CSATransactionReportTradeCSA_VR_0130_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReportTrade", (RosettaPath)path, (String)CSATransactionReportTradeCSA_VR_0130_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CSATransactionReportTrade cSATransactionReportTrade) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cSATransactionReportTrade).map("getNonReportable", _cSATransactionReportTrade -> _cSATransactionReportTrade.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass())).andNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.EQUITY)), MapperS.of((Object)((Object)AnnaDsbAssetClassEnum.CREDIT))}), (Mapper)MapperS.of((Object)cSATransactionReportTrade).map("getNonReportable", _cSATransactionReportTrade -> _cSATransactionReportTrade.getNonReportable()).map("getPostUpiData", cSANonReportable -> cSANonReportable.getPostUpiData()).map("getHeader", annaDsbUpiRecord -> annaDsbUpiRecord.getHeader()).map("getAssetClass", annaDsbHeader -> annaDsbHeader.getAssetClass()), (CardinalityOperator)CardinalityOperator.Any)).orNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)AssetClassEnum.EQUITY), MapperS.of((Object)AssetClassEnum.CREDIT)}), (Mapper)MapperS.of((Object)cSATransactionReportTrade).map("getDtccAdditionalFields", _cSATransactionReportTrade -> _cSATransactionReportTrade.getDtccAdditionalFields()).map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cSATransactionReportTrade).map("getLeg1", _cSATransactionReportTrade -> _cSATransactionReportTrade.getLeg1()).map("getUnderlyingAssetTradingPlatformIdentifier", cSALeg -> cSALeg.getUnderlyingAssetTradingPlatformIdentifier())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cSATransactionReportTrade).map("getLeg2", _cSATransactionReportTrade -> _cSATransactionReportTrade.getLeg2()).map("getUnderlyingAssetTradingPlatformIdentifier", cSALeg -> cSALeg.getUnderlyingAssetTradingPlatformIdentifier())));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

