/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.qualification.event.functions.IsAllowableAction;
import drr.base.trade.ReportableEventBase;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.esma.emir.refit.trade.reports.ISINRule;
import drr.standards.iosco.upi.reports.UniqueProductIdentifierRule;
import javax.inject.Inject;

@ImplementedBy(value=UPIRuleDefault.class)
public abstract class UPIRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected ISINRule iSINRule;
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected UniqueProductIdentifierRule uniqueProductIdentifierRule;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class UPIRuleDefault
    extends UPIRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isAllowableAction.evaluate((ReportableEventBase)item.get()))).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)this.iSINRule.evaluate((TransactionReportInstruction)item.get())))).get());
            FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)thenArg.mapSingleToItem(item -> {
                String string = this.uniqueProductIdentifierRule.evaluate((TransactionReportInstruction)item.get());
                return string == null ? MapperS.ofNull() : MapperS.of((Object)FieldWithMetaString.builder().setValue(string).build());
            }).get();
            output = fieldWithMetaString == null ? null : fieldWithMetaString.getValue();
            return output;
        }
    }
}

