/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.base.qualification.event.functions.IsVRAllowedForActionType;
import drr.regulation.common.functions.IsEU;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.MicMarketCategoryEnum;
import drr.standards.iso.functions.GetOrFetchMicData;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@RosettaDataRule(value="ESMAEMIRTransactionReportEMIR_VR_2008_03")
@ImplementedBy(value=Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2008_03
extends Validator<ESMAEMIRTransactionReport> {
    public static final String NAME = "ESMAEMIRTransactionReportEMIR_VR_2008_03";
    public static final String DEFINITION = "if IsVRAllowedForActionType(actionType) then if isin is absent and (venueOfExecution exists and GetOrFetchMicData( nonReportable -> enrichment -> micData, venueOfExecution ) extract marketCategory = MicMarketCategoryEnum -> OTFS and IsEU(countryCode) = False) = True then (uniqueProductIdentifier exists or uniqueProductIdentifier is absent)";

    public static class NoOp
    implements ESMAEMIRTransactionReportEMIR_VR_2008_03 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ESMAEMIRTransactionReportEMIR_VR_2008_03 {
        @Inject
        protected GetOrFetchMicData getOrFetchMicData;
        @Inject
        protected IsEU isEU;
        @Inject
        protected IsVRAllowedForActionType isVRAllowedForActionType;

        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            ComparisonResult result = this.executeDataRule(eSMAEMIRTransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ESMAEMIRTransactionReportEMIR_VR_2008_03.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_2008_03.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ESMAEMIRTransactionReportEMIR_VR_2008_03.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ESMAEMIRTransactionReport", (RosettaPath)path, (String)ESMAEMIRTransactionReportEMIR_VR_2008_03.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
            try {
                Boolean _boolean = this.isVRAllowedForActionType.evaluate((ActionTypeEnum)((Object)MapperS.of((Object)eSMAEMIRTransactionReport).map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get()));
                if (_boolean != null && _boolean.booleanValue()) {
                    if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getIsin", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getIsin())).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getVenueOfExecution", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getVenueOfExecution())).andNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.getOrFetchMicData.evaluate(MapperS.of((Object)eSMAEMIRTransactionReport).map("getNonReportable", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getNonReportable()).map("getEnrichment", nonReportable -> nonReportable.getEnrichment()).mapC("getMicData", enrichmentData -> enrichmentData.getMicData()).getMulti(), (String)MapperS.of((Object)eSMAEMIRTransactionReport).map("getVenueOfExecution", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getVenueOfExecution()).get())).mapSingleToItem(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getMarketCategory", micData -> micData.getMarketCategory()), (Mapper)MapperS.of((Object)((Object)MicMarketCategoryEnum.OTFS)), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.isEU.evaluate((String)item.map("getCountryCode", micData -> micData.getCountryCode()).get())), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).asMapper()))), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getUniqueProductIdentifier", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getUniqueProductIdentifier())).orNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)eSMAEMIRTransactionReport).map("getUniqueProductIdentifier", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getUniqueProductIdentifier())));
                    }
                    return ComparisonResult.ofEmpty();
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

