/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.trade.reports;

import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.util.party.functions.CounterpartiesForEvent;
import drr.base.util.party.functions.PartyLeiAndPersonByRoles;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.reports.PayoutLeg2Rule;
import drr.standards.iosco.cde.version3.party.functions.PayerParty;
import javax.inject.Inject;

@ImplementedBy(value=PayerIdentifierLeg2RuleDefault.class)
public abstract class PayerIdentifierLeg2Rule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected CounterpartiesForEvent counterpartiesForEvent;
    @Inject
    protected PartyLeiAndPersonByRoles partyLeiAndPersonByRoles;
    @Inject
    protected PayerParty payerParty;
    @Inject
    protected PayoutLeg2Rule payoutLeg2Rule;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class PayerIdentifierLeg2RuleDefault
    extends PayerIdentifierLeg2Rule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            output = (String)MapperS.of((Object)input).mapSingleToItem(item -> {
                ReferenceWithMetaParty referenceWithMetaParty = (ReferenceWithMetaParty)item.map("getReportingSide", transactionReportInstruction -> transactionReportInstruction.getReportingSide()).map("getReportingParty", reportingSide -> reportingSide.getReportingParty()).get();
                return MapperS.of((Object)this.partyLeiAndPersonByRoles.evaluate(this.payerParty.evaluate(this.payoutLeg2Rule.evaluate((ReportableEventBase)item.get()), this.counterpartiesForEvent.evaluate((ReportableEventBase)item.get())), referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue()));
            }).get();
            return output;
        }
    }
}

