/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.valuation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneIgnore;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.base.util.party.PartyIdentifierFormat2Enum;
import drr.regulation.common.HKTRPartyScheme;
import drr.regulation.common.UTIProprietarySchemeNameEnum;
import drr.regulation.common.valuation.CommonValuationReport;
import drr.regulation.hkma.rewrite.valuation.meta.HKMAValuationReportMeta;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="HKMAValuationReport", builder=HKMAValuationReportBuilderImpl.class, version="7.0.0-dev.85")
@RuneDataType(value="HKMAValuationReport", model="drr", builder=HKMAValuationReportBuilderImpl.class, version="7.0.0-dev.85")
public interface HKMAValuationReport
extends CommonValuationReport {
    public static final HKMAValuationReportMeta metaData = new HKMAValuationReportMeta();

    @Override
    public Boolean getCounterparty2IdentifierType();

    @Override
    public String getTechnicalRecordId();

    @Override
    public String getReportSubmittingEntityID();

    public String getCounterparty2Name();

    public String getSubmitterIdentifier();

    public BigDecimal getNumberRecords();

    public String getRemarks();

    public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat();

    public HKTRPartyScheme getCounterparty2SchemeName();

    public UTIProprietarySchemeNameEnum getUniqueTransactionIdentifierProprietarySchemeName();

    @Override
    public HKMAValuationReport build();

    @Override
    public HKMAValuationReportBuilder toBuilder();

    public static HKMAValuationReportBuilder builder() {
        return new HKMAValuationReportBuilderImpl();
    }

    default public RosettaMetaData<? extends HKMAValuationReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends HKMAValuationReport> getType() {
        return HKMAValuationReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg1"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg2"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, (Object)this.getSubmitterIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("numberRecords"), BigDecimal.class, (Object)this.getNumberRecords(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("remarks"), String.class, (Object)this.getRemarks(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierFormat"), PartyIdentifierFormat2Enum.class, (Object)this.getCounterparty2IdentifierFormat(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2SchemeName"), HKTRPartyScheme.class, (Object)this.getCounterparty2SchemeName(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietarySchemeName"), UTIProprietarySchemeNameEnum.class, (Object)this.getUniqueTransactionIdentifierProprietarySchemeName(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class HKMAValuationReportBuilderImpl
    extends CommonValuationReport.CommonValuationReportBuilderImpl
    implements HKMAValuationReportBuilder {
        protected Boolean counterparty2IdentifierType;
        protected String technicalRecordId;
        protected String reportSubmittingEntityID;
        protected String counterparty2Name;
        protected String submitterIdentifier;
        protected BigDecimal numberRecords;
        protected String remarks;
        protected PartyIdentifierFormat2Enum counterparty2IdentifierFormat;
        protected HKTRPartyScheme counterparty2SchemeName;
        protected UTIProprietarySchemeNameEnum uniqueTransactionIdentifierProprietarySchemeName;

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name", isRequired=true)
        @RuneAttribute(value="counterparty2Name", isRequired=true)
        public String getCounterparty2Name() {
            return this.counterparty2Name;
        }

        @Override
        @RosettaAttribute(value="submitterIdentifier", isRequired=true)
        @RuneAttribute(value="submitterIdentifier", isRequired=true)
        public String getSubmitterIdentifier() {
            return this.submitterIdentifier;
        }

        @Override
        @RosettaAttribute(value="numberRecords", isRequired=true)
        @RuneAttribute(value="numberRecords", isRequired=true)
        public BigDecimal getNumberRecords() {
            return this.numberRecords;
        }

        @Override
        @RosettaAttribute(value="remarks")
        @RuneAttribute(value="remarks")
        public String getRemarks() {
            return this.remarks;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierFormat")
        @RuneAttribute(value="counterparty2IdentifierFormat")
        public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat() {
            return this.counterparty2IdentifierFormat;
        }

        @Override
        @RosettaAttribute(value="counterparty2SchemeName")
        @RuneAttribute(value="counterparty2SchemeName")
        public HKTRPartyScheme getCounterparty2SchemeName() {
            return this.counterparty2SchemeName;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        public UTIProprietarySchemeNameEnum getUniqueTransactionIdentifierProprietarySchemeName() {
            return this.uniqueTransactionIdentifierProprietarySchemeName;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public HKMAValuationReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public HKMAValuationReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public HKMAValuationReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public HKMAValuationReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            return this.setCounterparty2IdentifierTypeOverriddenAsBoolean(_counterparty2IdentifierType);
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public HKMAValuationReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount", isRequired=true)
        @RuneAttribute(value="valuationAmount", isRequired=true)
        public HKMAValuationReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency", isRequired=true)
        @RuneAttribute(value="valuationCurrency", isRequired=true)
        public HKMAValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp", isRequired=true)
        @RuneAttribute(value="valuationTimestamp", isRequired=true)
        public HKMAValuationReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod", isRequired=true)
        @RuneAttribute(value="valuationMethod", isRequired=true)
        public HKMAValuationReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public HKMAValuationReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public HKMAValuationReportBuilder setActionType(ActionTypeEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public HKMAValuationReportBuilder setLevel(ReportLevelEnum _level) {
            this.level = _level == null ? null : _level;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public HKMAValuationReportBuilder setTechnicalRecordIdOverriddenAsString(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public HKMAValuationReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            return this.setTechnicalRecordIdOverriddenAsString(_technicalRecordId);
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public HKMAValuationReportBuilder setReportSubmittingEntityIDOverriddenAsString(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public HKMAValuationReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            return this.setReportSubmittingEntityIDOverriddenAsString(_reportSubmittingEntityID);
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public HKMAValuationReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource")
        @RuneAttribute(value="counterparty2IdentifierSource")
        public HKMAValuationReportBuilder setCounterparty2IdentifierSource(String _counterparty2IdentifierSource) {
            this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public HKMAValuationReportBuilder setNextFloatingReferenceResetDateLeg1(Date _nextFloatingReferenceResetDateLeg1) {
            this.nextFloatingReferenceResetDateLeg1 = _nextFloatingReferenceResetDateLeg1 == null ? null : _nextFloatingReferenceResetDateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public HKMAValuationReportBuilder setNextFloatingReferenceResetDateLeg2(Date _nextFloatingReferenceResetDateLeg2) {
            this.nextFloatingReferenceResetDateLeg2 = _nextFloatingReferenceResetDateLeg2 == null ? null : _nextFloatingReferenceResetDateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        public HKMAValuationReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public HKMAValuationReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public HKMAValuationReportBuilder setEventDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public HKMAValuationReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public HKMAValuationReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg1")
        @RuneAttribute(value="lastFloatingReferenceValueLeg1")
        public HKMAValuationReportBuilder setLastFloatingReferenceValueLeg1(BigDecimal _lastFloatingReferenceValueLeg1) {
            this.lastFloatingReferenceValueLeg1 = _lastFloatingReferenceValueLeg1 == null ? null : _lastFloatingReferenceValueLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg2")
        @RuneAttribute(value="lastFloatingReferenceValueLeg2")
        public HKMAValuationReportBuilder setLastFloatingReferenceValueLeg2(BigDecimal _lastFloatingReferenceValueLeg2) {
            this.lastFloatingReferenceValueLeg2 = _lastFloatingReferenceValueLeg2 == null ? null : _lastFloatingReferenceValueLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg1")
        public HKMAValuationReportBuilder setLastFloatingReferenceResetDateLeg1(Date _lastFloatingReferenceResetDateLeg1) {
            this.lastFloatingReferenceResetDateLeg1 = _lastFloatingReferenceResetDateLeg1 == null ? null : _lastFloatingReferenceResetDateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg2")
        public HKMAValuationReportBuilder setLastFloatingReferenceResetDateLeg2(Date _lastFloatingReferenceResetDateLeg2) {
            this.lastFloatingReferenceResetDateLeg2 = _lastFloatingReferenceResetDateLeg2 == null ? null : _lastFloatingReferenceResetDateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name", isRequired=true)
        @RuneAttribute(value="counterparty2Name", isRequired=true)
        public HKMAValuationReportBuilder setCounterparty2Name(String _counterparty2Name) {
            this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
            return this;
        }

        @Override
        @RosettaAttribute(value="submitterIdentifier", isRequired=true)
        @RuneAttribute(value="submitterIdentifier", isRequired=true)
        public HKMAValuationReportBuilder setSubmitterIdentifier(String _submitterIdentifier) {
            this.submitterIdentifier = _submitterIdentifier == null ? null : _submitterIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="numberRecords", isRequired=true)
        @RuneAttribute(value="numberRecords", isRequired=true)
        public HKMAValuationReportBuilder setNumberRecords(BigDecimal _numberRecords) {
            this.numberRecords = _numberRecords == null ? null : _numberRecords;
            return this;
        }

        @Override
        @RosettaAttribute(value="remarks")
        @RuneAttribute(value="remarks")
        public HKMAValuationReportBuilder setRemarks(String _remarks) {
            this.remarks = _remarks == null ? null : _remarks;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierFormat")
        @RuneAttribute(value="counterparty2IdentifierFormat")
        public HKMAValuationReportBuilder setCounterparty2IdentifierFormat(PartyIdentifierFormat2Enum _counterparty2IdentifierFormat) {
            this.counterparty2IdentifierFormat = _counterparty2IdentifierFormat == null ? null : _counterparty2IdentifierFormat;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2SchemeName")
        @RuneAttribute(value="counterparty2SchemeName")
        public HKMAValuationReportBuilder setCounterparty2SchemeName(HKTRPartyScheme _counterparty2SchemeName) {
            this.counterparty2SchemeName = _counterparty2SchemeName == null ? null : _counterparty2SchemeName;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        public HKMAValuationReportBuilder setUniqueTransactionIdentifierProprietarySchemeName(UTIProprietarySchemeNameEnum _uniqueTransactionIdentifierProprietarySchemeName) {
            this.uniqueTransactionIdentifierProprietarySchemeName = _uniqueTransactionIdentifierProprietarySchemeName == null ? null : _uniqueTransactionIdentifierProprietarySchemeName;
            return this;
        }

        @Override
        public HKMAValuationReport build() {
            return new HKMAValuationReportImpl(this);
        }

        @Override
        public HKMAValuationReportBuilder toBuilder() {
            return this;
        }

        @Override
        public HKMAValuationReportBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCounterparty2IdentifierType() != null) {
                return true;
            }
            if (this.getTechnicalRecordId() != null) {
                return true;
            }
            if (this.getReportSubmittingEntityID() != null) {
                return true;
            }
            if (this.getCounterparty2Name() != null) {
                return true;
            }
            if (this.getSubmitterIdentifier() != null) {
                return true;
            }
            if (this.getNumberRecords() != null) {
                return true;
            }
            if (this.getRemarks() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierFormat() != null) {
                return true;
            }
            if (this.getCounterparty2SchemeName() != null) {
                return true;
            }
            return this.getUniqueTransactionIdentifierProprietarySchemeName() != null;
        }

        @Override
        public HKMAValuationReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            HKMAValuationReportBuilder o = (HKMAValuationReportBuilder)other;
            merger.mergeBasic((Object)this.getCounterparty2IdentifierType(), (Object)o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierTypeOverriddenAsBoolean, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTechnicalRecordId(), (Object)o.getTechnicalRecordId(), this::setTechnicalRecordIdOverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportSubmittingEntityID(), (Object)o.getReportSubmittingEntityID(), this::setReportSubmittingEntityIDOverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2Name(), (Object)o.getCounterparty2Name(), this::setCounterparty2Name, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSubmitterIdentifier(), (Object)o.getSubmitterIdentifier(), this::setSubmitterIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNumberRecords(), (Object)o.getNumberRecords(), this::setNumberRecords, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRemarks(), (Object)o.getRemarks(), this::setRemarks, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierFormat(), (Object)o.getCounterparty2IdentifierFormat(), this::setCounterparty2IdentifierFormat, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2SchemeName(), (Object)o.getCounterparty2SchemeName(), this::setCounterparty2SchemeName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifierProprietarySchemeName(), (Object)o.getUniqueTransactionIdentifierProprietarySchemeName(), this::setUniqueTransactionIdentifierProprietarySchemeName, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            HKMAValuationReport _that = (HKMAValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2Name, _that.getCounterparty2Name())) {
                return false;
            }
            if (!Objects.equals(this.submitterIdentifier, _that.getSubmitterIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.numberRecords, _that.getNumberRecords())) {
                return false;
            }
            if (!Objects.equals(this.remarks, _that.getRemarks())) {
                return false;
            }
            if (!Objects.equals((Object)this.counterparty2IdentifierFormat, (Object)_that.getCounterparty2IdentifierFormat())) {
                return false;
            }
            if (!Objects.equals((Object)this.counterparty2SchemeName, (Object)_that.getCounterparty2SchemeName())) {
                return false;
            }
            return Objects.equals((Object)this.uniqueTransactionIdentifierProprietarySchemeName, (Object)_that.getUniqueTransactionIdentifierProprietarySchemeName());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2Name != null ? this.counterparty2Name.hashCode() : 0);
            _result = 31 * _result + (this.submitterIdentifier != null ? this.submitterIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.numberRecords != null ? this.numberRecords.hashCode() : 0);
            _result = 31 * _result + (this.remarks != null ? this.remarks.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierFormat != null ? ((Object)((Object)this.counterparty2IdentifierFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.counterparty2SchemeName != null ? ((Object)((Object)this.counterparty2SchemeName)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietarySchemeName != null ? ((Object)((Object)this.uniqueTransactionIdentifierProprietarySchemeName)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "HKMAValuationReportBuilder {counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", technicalRecordId=" + this.technicalRecordId + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", counterparty2Name=" + this.counterparty2Name + ", submitterIdentifier=" + this.submitterIdentifier + ", numberRecords=" + String.valueOf(this.numberRecords) + ", remarks=" + this.remarks + ", counterparty2IdentifierFormat=" + String.valueOf((Object)this.counterparty2IdentifierFormat) + ", counterparty2SchemeName=" + String.valueOf((Object)this.counterparty2SchemeName) + ", uniqueTransactionIdentifierProprietarySchemeName=" + String.valueOf((Object)this.uniqueTransactionIdentifierProprietarySchemeName) + "} " + super.toString();
        }
    }

    public static interface HKMAValuationReportBuilder
    extends HKMAValuationReport,
    CommonValuationReport.CommonValuationReportBuilder {
        @Override
        public HKMAValuationReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public HKMAValuationReportBuilder setCounterparty1(String var1);

        @Override
        public HKMAValuationReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public HKMAValuationReportBuilder setCounterparty2(String var1);

        @Override
        public HKMAValuationReportBuilder setValuationAmount(BigDecimal var1);

        @Override
        public HKMAValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public HKMAValuationReportBuilder setValuationTimestamp(ZonedDateTime var1);

        @Override
        public HKMAValuationReportBuilder setValuationMethod(ValuationType1Code var1);

        @Override
        public HKMAValuationReportBuilder setDelta(BigDecimal var1);

        @Override
        public HKMAValuationReportBuilder setActionType(ActionTypeEnum var1);

        @Override
        public HKMAValuationReportBuilder setLevel(ReportLevelEnum var1);

        @Override
        public HKMAValuationReportBuilder setTechnicalRecordId(String var1);

        @Override
        public HKMAValuationReportBuilder setReportSubmittingEntityID(String var1);

        @Override
        public HKMAValuationReportBuilder setEntityResponsibleForReporting(String var1);

        @Override
        public HKMAValuationReportBuilder setCounterparty2IdentifierSource(String var1);

        @Override
        public HKMAValuationReportBuilder setNextFloatingReferenceResetDateLeg1(Date var1);

        @Override
        public HKMAValuationReportBuilder setNextFloatingReferenceResetDateLeg2(Date var1);

        @Override
        public HKMAValuationReportBuilder setUniqueTransactionIdentifier(String var1);

        @Override
        public HKMAValuationReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        @Override
        public HKMAValuationReportBuilder setEventDate(Date var1);

        @Override
        public HKMAValuationReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        @Override
        public HKMAValuationReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        @Override
        public HKMAValuationReportBuilder setLastFloatingReferenceValueLeg1(BigDecimal var1);

        @Override
        public HKMAValuationReportBuilder setLastFloatingReferenceValueLeg2(BigDecimal var1);

        @Override
        public HKMAValuationReportBuilder setLastFloatingReferenceResetDateLeg1(Date var1);

        @Override
        public HKMAValuationReportBuilder setLastFloatingReferenceResetDateLeg2(Date var1);

        public HKMAValuationReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean var1);

        public HKMAValuationReportBuilder setTechnicalRecordIdOverriddenAsString(String var1);

        public HKMAValuationReportBuilder setReportSubmittingEntityIDOverriddenAsString(String var1);

        public HKMAValuationReportBuilder setCounterparty2Name(String var1);

        public HKMAValuationReportBuilder setSubmitterIdentifier(String var1);

        public HKMAValuationReportBuilder setNumberRecords(BigDecimal var1);

        public HKMAValuationReportBuilder setRemarks(String var1);

        public HKMAValuationReportBuilder setCounterparty2IdentifierFormat(PartyIdentifierFormat2Enum var1);

        public HKMAValuationReportBuilder setCounterparty2SchemeName(HKTRPartyScheme var1);

        public HKMAValuationReportBuilder setUniqueTransactionIdentifierProprietarySchemeName(UTIProprietarySchemeNameEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg1"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg2"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, (Object)this.getSubmitterIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("numberRecords"), BigDecimal.class, (Object)this.getNumberRecords(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("remarks"), String.class, (Object)this.getRemarks(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierFormat"), PartyIdentifierFormat2Enum.class, (Object)this.getCounterparty2IdentifierFormat(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2SchemeName"), HKTRPartyScheme.class, (Object)this.getCounterparty2SchemeName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietarySchemeName"), UTIProprietarySchemeNameEnum.class, (Object)this.getUniqueTransactionIdentifierProprietarySchemeName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public HKMAValuationReportBuilder prune();
    }

    public static class HKMAValuationReportImpl
    extends CommonValuationReport.CommonValuationReportImpl
    implements HKMAValuationReport {
        private final Boolean counterparty2IdentifierType;
        private final String technicalRecordId;
        private final String reportSubmittingEntityID;
        private final String counterparty2Name;
        private final String submitterIdentifier;
        private final BigDecimal numberRecords;
        private final String remarks;
        private final PartyIdentifierFormat2Enum counterparty2IdentifierFormat;
        private final HKTRPartyScheme counterparty2SchemeName;
        private final UTIProprietarySchemeNameEnum uniqueTransactionIdentifierProprietarySchemeName;

        protected HKMAValuationReportImpl(HKMAValuationReportBuilder builder) {
            super(builder);
            this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
            this.technicalRecordId = builder.getTechnicalRecordId();
            this.reportSubmittingEntityID = builder.getReportSubmittingEntityID();
            this.counterparty2Name = builder.getCounterparty2Name();
            this.submitterIdentifier = builder.getSubmitterIdentifier();
            this.numberRecords = builder.getNumberRecords();
            this.remarks = builder.getRemarks();
            this.counterparty2IdentifierFormat = builder.getCounterparty2IdentifierFormat();
            this.counterparty2SchemeName = builder.getCounterparty2SchemeName();
            this.uniqueTransactionIdentifierProprietarySchemeName = builder.getUniqueTransactionIdentifierProprietarySchemeName();
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name", isRequired=true)
        @RuneAttribute(value="counterparty2Name", isRequired=true)
        public String getCounterparty2Name() {
            return this.counterparty2Name;
        }

        @Override
        @RosettaAttribute(value="submitterIdentifier", isRequired=true)
        @RuneAttribute(value="submitterIdentifier", isRequired=true)
        public String getSubmitterIdentifier() {
            return this.submitterIdentifier;
        }

        @Override
        @RosettaAttribute(value="numberRecords", isRequired=true)
        @RuneAttribute(value="numberRecords", isRequired=true)
        public BigDecimal getNumberRecords() {
            return this.numberRecords;
        }

        @Override
        @RosettaAttribute(value="remarks")
        @RuneAttribute(value="remarks")
        public String getRemarks() {
            return this.remarks;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierFormat")
        @RuneAttribute(value="counterparty2IdentifierFormat")
        public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat() {
            return this.counterparty2IdentifierFormat;
        }

        @Override
        @RosettaAttribute(value="counterparty2SchemeName")
        @RuneAttribute(value="counterparty2SchemeName")
        public HKTRPartyScheme getCounterparty2SchemeName() {
            return this.counterparty2SchemeName;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        public UTIProprietarySchemeNameEnum getUniqueTransactionIdentifierProprietarySchemeName() {
            return this.uniqueTransactionIdentifierProprietarySchemeName;
        }

        @Override
        public HKMAValuationReport build() {
            return this;
        }

        @Override
        public HKMAValuationReportBuilder toBuilder() {
            HKMAValuationReportBuilder builder = HKMAValuationReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(HKMAValuationReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierTypeOverriddenAsBoolean);
            Optional.ofNullable(this.getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordIdOverriddenAsString);
            Optional.ofNullable(this.getReportSubmittingEntityID()).ifPresent(builder::setReportSubmittingEntityIDOverriddenAsString);
            Optional.ofNullable(this.getCounterparty2Name()).ifPresent(builder::setCounterparty2Name);
            Optional.ofNullable(this.getSubmitterIdentifier()).ifPresent(builder::setSubmitterIdentifier);
            Optional.ofNullable(this.getNumberRecords()).ifPresent(builder::setNumberRecords);
            Optional.ofNullable(this.getRemarks()).ifPresent(builder::setRemarks);
            Optional.ofNullable(this.getCounterparty2IdentifierFormat()).ifPresent(builder::setCounterparty2IdentifierFormat);
            Optional.ofNullable(this.getCounterparty2SchemeName()).ifPresent(builder::setCounterparty2SchemeName);
            Optional.ofNullable(this.getUniqueTransactionIdentifierProprietarySchemeName()).ifPresent(builder::setUniqueTransactionIdentifierProprietarySchemeName);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            HKMAValuationReport _that = (HKMAValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2Name, _that.getCounterparty2Name())) {
                return false;
            }
            if (!Objects.equals(this.submitterIdentifier, _that.getSubmitterIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.numberRecords, _that.getNumberRecords())) {
                return false;
            }
            if (!Objects.equals(this.remarks, _that.getRemarks())) {
                return false;
            }
            if (!Objects.equals((Object)this.counterparty2IdentifierFormat, (Object)_that.getCounterparty2IdentifierFormat())) {
                return false;
            }
            if (!Objects.equals((Object)this.counterparty2SchemeName, (Object)_that.getCounterparty2SchemeName())) {
                return false;
            }
            return Objects.equals((Object)this.uniqueTransactionIdentifierProprietarySchemeName, (Object)_that.getUniqueTransactionIdentifierProprietarySchemeName());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2Name != null ? this.counterparty2Name.hashCode() : 0);
            _result = 31 * _result + (this.submitterIdentifier != null ? this.submitterIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.numberRecords != null ? this.numberRecords.hashCode() : 0);
            _result = 31 * _result + (this.remarks != null ? this.remarks.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierFormat != null ? ((Object)((Object)this.counterparty2IdentifierFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.counterparty2SchemeName != null ? ((Object)((Object)this.counterparty2SchemeName)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietarySchemeName != null ? ((Object)((Object)this.uniqueTransactionIdentifierProprietarySchemeName)).getClass().getName().hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "HKMAValuationReport {counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", technicalRecordId=" + this.technicalRecordId + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", counterparty2Name=" + this.counterparty2Name + ", submitterIdentifier=" + this.submitterIdentifier + ", numberRecords=" + String.valueOf(this.numberRecords) + ", remarks=" + this.remarks + ", counterparty2IdentifierFormat=" + String.valueOf((Object)this.counterparty2IdentifierFormat) + ", counterparty2SchemeName=" + String.valueOf((Object)this.counterparty2SchemeName) + ", uniqueTransactionIdentifierProprietarySchemeName=" + String.valueOf((Object)this.uniqueTransactionIdentifierProprietarySchemeName) + "} " + super.toString();
        }
    }
}

