/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.valuation.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ValuationReportInstruction;
import drr.regulation.common.valuation.datetime.reports.ReportingTimestampRule;
import drr.regulation.common.valuation.datetime.reports.ValuationTimestampRule;
import drr.regulation.common.valuation.event.reports.ActionTypeRule;
import drr.regulation.common.valuation.event.reports.LevelRule;
import drr.regulation.common.valuation.party.reports.Counterparty1Rule;
import drr.regulation.common.valuation.party.reports.Counterparty2IdentifierTypeRule;
import drr.regulation.common.valuation.party.reports.Counterparty2Rule;
import drr.regulation.common.valuation.party.reports.EntityResponsibleForReportingRule;
import drr.regulation.common.valuation.quantity.reports.DeltaRule;
import drr.regulation.common.valuation.valuation.reports.ValuationAmountRule;
import drr.regulation.common.valuation.valuation.reports.ValuationCurrencyRule;
import drr.regulation.common.valuation.valuation.reports.ValuationMethodRule;
import drr.regulation.hkma.rewrite.valuation.HKMAValuationReport;
import drr.regulation.hkma.rewrite.valuation.labels.HKMAValuationLabelProvider;
import drr.regulation.hkma.rewrite.valuation.reports.Counterparty2IdentifierFormatRule;
import drr.regulation.hkma.rewrite.valuation.reports.Counterparty2NameRule;
import drr.regulation.hkma.rewrite.valuation.reports.Counterparty2SchemeNameRule;
import drr.regulation.hkma.rewrite.valuation.reports.NumberRecordsRule;
import drr.regulation.hkma.rewrite.valuation.reports.RemarksRule;
import drr.regulation.hkma.rewrite.valuation.reports.SubmitterIdentifierRule;
import drr.regulation.hkma.rewrite.valuation.reports.TechnicalRecordIdRule;
import drr.regulation.hkma.rewrite.valuation.reports.UniqueTransactionIdentifierProprietaryRule;
import drr.regulation.hkma.rewrite.valuation.reports.UniqueTransactionIdentifierProprietarySchemeNameRule;
import drr.regulation.hkma.rewrite.valuation.reports.UniqueTransactionIdentifierRule;
import java.util.Optional;
import javax.inject.Inject;

@RosettaReport(namespace="drr.regulation.hkma.rewrite.valuation", body="HKMA", corpusList={"Valuation"})
@RuneLabelProvider(labelProvider=HKMAValuationLabelProvider.class)
@ImplementedBy(value=HKMAValuationReportFunctionDefault.class)
public abstract class HKMAValuationReportFunction
implements ReportFunction<ValuationReportInstruction, HKMAValuationReport> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ActionTypeRule actionTypeRule;
    @Inject
    protected Counterparty1Rule counterparty1Rule;
    @Inject
    protected Counterparty2IdentifierFormatRule counterparty2IdentifierFormatRule;
    @Inject
    protected Counterparty2IdentifierTypeRule counterparty2IdentifierTypeRule;
    @Inject
    protected Counterparty2NameRule counterparty2NameRule;
    @Inject
    protected Counterparty2Rule counterparty2Rule;
    @Inject
    protected Counterparty2SchemeNameRule counterparty2SchemeNameRule;
    @Inject
    protected DeltaRule deltaRule;
    @Inject
    protected EntityResponsibleForReportingRule entityResponsibleForReportingRule;
    @Inject
    protected LevelRule levelRule;
    @Inject
    protected NumberRecordsRule numberRecordsRule;
    @Inject
    protected RemarksRule remarksRule;
    @Inject
    protected ReportingTimestampRule reportingTimestampRule;
    @Inject
    protected SubmitterIdentifierRule submitterIdentifierRule;
    @Inject
    protected TechnicalRecordIdRule technicalRecordIdRule;
    @Inject
    protected UniqueTransactionIdentifierProprietaryRule uniqueTransactionIdentifierProprietaryRule;
    @Inject
    protected UniqueTransactionIdentifierProprietarySchemeNameRule uniqueTransactionIdentifierProprietarySchemeNameRule;
    @Inject
    protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
    @Inject
    protected ValuationAmountRule valuationAmountRule;
    @Inject
    protected ValuationCurrencyRule valuationCurrencyRule;
    @Inject
    protected ValuationMethodRule valuationMethodRule;
    @Inject
    protected ValuationTimestampRule valuationTimestampRule;

    public HKMAValuationReport evaluate(ValuationReportInstruction input) {
        HKMAValuationReport output;
        HKMAValuationReport.HKMAValuationReportBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(HKMAValuationReport.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract HKMAValuationReport.HKMAValuationReportBuilder doEvaluate(ValuationReportInstruction var1);

    public static class HKMAValuationReportFunctionDefault
    extends HKMAValuationReportFunction {
        @Override
        protected HKMAValuationReport.HKMAValuationReportBuilder doEvaluate(ValuationReportInstruction input) {
            HKMAValuationReport.HKMAValuationReportBuilder output = HKMAValuationReport.builder();
            return this.assignOutput(output, input);
        }

        protected HKMAValuationReport.HKMAValuationReportBuilder assignOutput(HKMAValuationReport.HKMAValuationReportBuilder output, ValuationReportInstruction input) {
            output.setReportingTimestamp(this.reportingTimestampRule.evaluate(input));
            output.setCounterparty1(this.counterparty1Rule.evaluate(input));
            output.setCounterparty2IdentifierTypeOverriddenAsBoolean(this.counterparty2IdentifierTypeRule.evaluate(input));
            output.setCounterparty2(this.counterparty2Rule.evaluate(input));
            output.setValuationAmount(this.valuationAmountRule.evaluate(input));
            output.setValuationCurrency(this.valuationCurrencyRule.evaluate(input));
            output.setValuationTimestamp(this.valuationTimestampRule.evaluate(input));
            output.setValuationMethod(this.valuationMethodRule.evaluate(input));
            output.setDelta(this.deltaRule.evaluate(input));
            output.setActionType(this.actionTypeRule.evaluate(input));
            output.setLevel(this.levelRule.evaluate(input));
            output.setTechnicalRecordIdOverriddenAsString(this.technicalRecordIdRule.evaluate(input));
            output.setEntityResponsibleForReporting(this.entityResponsibleForReportingRule.evaluate(input));
            output.setUniqueTransactionIdentifier(this.uniqueTransactionIdentifierRule.evaluate(input));
            output.setUniqueTransactionIdentifierProprietary(this.uniqueTransactionIdentifierProprietaryRule.evaluate(input));
            output.setCounterparty2Name(this.counterparty2NameRule.evaluate(input));
            output.setSubmitterIdentifier(this.submitterIdentifierRule.evaluate(input));
            output.setNumberRecords(null);
            output.setRemarks(null);
            output.setCounterparty2IdentifierFormat(this.counterparty2IdentifierFormatRule.evaluate(input));
            output.setCounterparty2SchemeName(this.counterparty2SchemeNameRule.evaluate(input));
            output.setUniqueTransactionIdentifierProprietarySchemeName(this.uniqueTransactionIdentifierProprietarySchemeNameRule.evaluate(input));
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

