/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.valuation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneIgnore;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.valuation.CommonValuationReport;
import drr.regulation.mas.rewrite.valuation.meta.MASValuationReportMeta;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ReportLevelEnum;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="MASValuationReport", builder=MASValuationReportBuilderImpl.class, version="7.0.0-dev.85")
@RuneDataType(value="MASValuationReport", model="drr", builder=MASValuationReportBuilderImpl.class, version="7.0.0-dev.85")
public interface MASValuationReport
extends CommonValuationReport {
    public static final MASValuationReportMeta metaData = new MASValuationReportMeta();

    @Override
    public Boolean getCounterparty2IdentifierType();

    @Override
    public String getReportSubmittingEntityID();

    public String getExecutionAgentOfTheCounterparty1();

    public String getExecutionAgentOfTheCounterparty2();

    @Override
    public MASValuationReport build();

    @Override
    public MASValuationReportBuilder toBuilder();

    public static MASValuationReportBuilder builder() {
        return new MASValuationReportBuilderImpl();
    }

    default public RosettaMetaData<? extends MASValuationReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends MASValuationReport> getType() {
        return MASValuationReport.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg1"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg2"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty1"), String.class, (Object)this.getExecutionAgentOfTheCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty2"), String.class, (Object)this.getExecutionAgentOfTheCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class MASValuationReportBuilderImpl
    extends CommonValuationReport.CommonValuationReportBuilderImpl
    implements MASValuationReportBuilder {
        protected Boolean counterparty2IdentifierType;
        protected String reportSubmittingEntityID;
        protected String executionAgentOfTheCounterparty1;
        protected String executionAgentOfTheCounterparty2;

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty1")
        @RuneAttribute(value="executionAgentOfTheCounterparty1")
        public String getExecutionAgentOfTheCounterparty1() {
            return this.executionAgentOfTheCounterparty1;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty2")
        @RuneAttribute(value="executionAgentOfTheCounterparty2")
        public String getExecutionAgentOfTheCounterparty2() {
            return this.executionAgentOfTheCounterparty2;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public MASValuationReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public MASValuationReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public MASValuationReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean _counterparty2IdentifierType) {
            this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASValuationReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
            return this.setCounterparty2IdentifierTypeOverriddenAsBoolean(_counterparty2IdentifierType);
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public MASValuationReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount", isRequired=true)
        @RuneAttribute(value="valuationAmount", isRequired=true)
        public MASValuationReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency", isRequired=true)
        @RuneAttribute(value="valuationCurrency", isRequired=true)
        public MASValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp", isRequired=true)
        @RuneAttribute(value="valuationTimestamp", isRequired=true)
        public MASValuationReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod", isRequired=true)
        @RuneAttribute(value="valuationMethod", isRequired=true)
        public MASValuationReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public MASValuationReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public MASValuationReportBuilder setActionType(ActionTypeEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public MASValuationReportBuilder setLevel(ReportLevelEnum _level) {
            this.level = _level == null ? null : _level;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId")
        @RuneAttribute(value="technicalRecordId")
        public MASValuationReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public MASValuationReportBuilder setReportSubmittingEntityIDOverriddenAsString(String _reportSubmittingEntityID) {
            this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
            return this;
        }

        @Override
        @RosettaIgnore
        @RuneIgnore
        public MASValuationReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
            return this.setReportSubmittingEntityIDOverriddenAsString(_reportSubmittingEntityID);
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public MASValuationReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierSource")
        @RuneAttribute(value="counterparty2IdentifierSource")
        public MASValuationReportBuilder setCounterparty2IdentifierSource(String _counterparty2IdentifierSource) {
            this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public MASValuationReportBuilder setNextFloatingReferenceResetDateLeg1(Date _nextFloatingReferenceResetDateLeg1) {
            this.nextFloatingReferenceResetDateLeg1 = _nextFloatingReferenceResetDateLeg1 == null ? null : _nextFloatingReferenceResetDateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public MASValuationReportBuilder setNextFloatingReferenceResetDateLeg2(Date _nextFloatingReferenceResetDateLeg2) {
            this.nextFloatingReferenceResetDateLeg2 = _nextFloatingReferenceResetDateLeg2 == null ? null : _nextFloatingReferenceResetDateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        public MASValuationReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary")
        public MASValuationReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventDate")
        @RuneAttribute(value="eventDate")
        public MASValuationReportBuilder setEventDate(Date _eventDate) {
            this.eventDate = _eventDate == null ? null : _eventDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="variationMarginCollateralPortfolioCode")
        @RuneAttribute(value="variationMarginCollateralPortfolioCode")
        public MASValuationReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
            this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="initialMarginCollateralPortfolioCode")
        @RuneAttribute(value="initialMarginCollateralPortfolioCode")
        public MASValuationReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
            this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg1")
        @RuneAttribute(value="lastFloatingReferenceValueLeg1")
        public MASValuationReportBuilder setLastFloatingReferenceValueLeg1(BigDecimal _lastFloatingReferenceValueLeg1) {
            this.lastFloatingReferenceValueLeg1 = _lastFloatingReferenceValueLeg1 == null ? null : _lastFloatingReferenceValueLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceValueLeg2")
        @RuneAttribute(value="lastFloatingReferenceValueLeg2")
        public MASValuationReportBuilder setLastFloatingReferenceValueLeg2(BigDecimal _lastFloatingReferenceValueLeg2) {
            this.lastFloatingReferenceValueLeg2 = _lastFloatingReferenceValueLeg2 == null ? null : _lastFloatingReferenceValueLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg1")
        public MASValuationReportBuilder setLastFloatingReferenceResetDateLeg1(Date _lastFloatingReferenceResetDateLeg1) {
            this.lastFloatingReferenceResetDateLeg1 = _lastFloatingReferenceResetDateLeg1 == null ? null : _lastFloatingReferenceResetDateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="lastFloatingReferenceResetDateLeg2")
        public MASValuationReportBuilder setLastFloatingReferenceResetDateLeg2(Date _lastFloatingReferenceResetDateLeg2) {
            this.lastFloatingReferenceResetDateLeg2 = _lastFloatingReferenceResetDateLeg2 == null ? null : _lastFloatingReferenceResetDateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty1")
        @RuneAttribute(value="executionAgentOfTheCounterparty1")
        public MASValuationReportBuilder setExecutionAgentOfTheCounterparty1(String _executionAgentOfTheCounterparty1) {
            this.executionAgentOfTheCounterparty1 = _executionAgentOfTheCounterparty1 == null ? null : _executionAgentOfTheCounterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty2")
        @RuneAttribute(value="executionAgentOfTheCounterparty2")
        public MASValuationReportBuilder setExecutionAgentOfTheCounterparty2(String _executionAgentOfTheCounterparty2) {
            this.executionAgentOfTheCounterparty2 = _executionAgentOfTheCounterparty2 == null ? null : _executionAgentOfTheCounterparty2;
            return this;
        }

        @Override
        public MASValuationReport build() {
            return new MASValuationReportImpl(this);
        }

        @Override
        public MASValuationReportBuilder toBuilder() {
            return this;
        }

        @Override
        public MASValuationReportBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getCounterparty2IdentifierType() != null) {
                return true;
            }
            if (this.getReportSubmittingEntityID() != null) {
                return true;
            }
            if (this.getExecutionAgentOfTheCounterparty1() != null) {
                return true;
            }
            return this.getExecutionAgentOfTheCounterparty2() != null;
        }

        @Override
        public MASValuationReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            MASValuationReportBuilder o = (MASValuationReportBuilder)other;
            merger.mergeBasic((Object)this.getCounterparty2IdentifierType(), (Object)o.getCounterparty2IdentifierType(), this::setCounterparty2IdentifierTypeOverriddenAsBoolean, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getReportSubmittingEntityID(), (Object)o.getReportSubmittingEntityID(), this::setReportSubmittingEntityIDOverriddenAsString, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionAgentOfTheCounterparty1(), (Object)o.getExecutionAgentOfTheCounterparty1(), this::setExecutionAgentOfTheCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExecutionAgentOfTheCounterparty2(), (Object)o.getExecutionAgentOfTheCounterparty2(), this::setExecutionAgentOfTheCounterparty2, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MASValuationReport _that = (MASValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfTheCounterparty1, _that.getExecutionAgentOfTheCounterparty1())) {
                return false;
            }
            return Objects.equals(this.executionAgentOfTheCounterparty2, _that.getExecutionAgentOfTheCounterparty2());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfTheCounterparty1 != null ? this.executionAgentOfTheCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfTheCounterparty2 != null ? this.executionAgentOfTheCounterparty2.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MASValuationReportBuilder {counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", executionAgentOfTheCounterparty1=" + this.executionAgentOfTheCounterparty1 + ", executionAgentOfTheCounterparty2=" + this.executionAgentOfTheCounterparty2 + "} " + super.toString();
        }
    }

    public static interface MASValuationReportBuilder
    extends MASValuationReport,
    CommonValuationReport.CommonValuationReportBuilder {
        @Override
        public MASValuationReportBuilder setReportingTimestamp(ZonedDateTime var1);

        @Override
        public MASValuationReportBuilder setCounterparty1(String var1);

        @Override
        public MASValuationReportBuilder setCounterparty2IdentifierType(Boolean var1);

        @Override
        public MASValuationReportBuilder setCounterparty2(String var1);

        @Override
        public MASValuationReportBuilder setValuationAmount(BigDecimal var1);

        @Override
        public MASValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public MASValuationReportBuilder setValuationTimestamp(ZonedDateTime var1);

        @Override
        public MASValuationReportBuilder setValuationMethod(ValuationType1Code var1);

        @Override
        public MASValuationReportBuilder setDelta(BigDecimal var1);

        @Override
        public MASValuationReportBuilder setActionType(ActionTypeEnum var1);

        @Override
        public MASValuationReportBuilder setLevel(ReportLevelEnum var1);

        @Override
        public MASValuationReportBuilder setTechnicalRecordId(String var1);

        @Override
        public MASValuationReportBuilder setReportSubmittingEntityID(String var1);

        @Override
        public MASValuationReportBuilder setEntityResponsibleForReporting(String var1);

        @Override
        public MASValuationReportBuilder setCounterparty2IdentifierSource(String var1);

        @Override
        public MASValuationReportBuilder setNextFloatingReferenceResetDateLeg1(Date var1);

        @Override
        public MASValuationReportBuilder setNextFloatingReferenceResetDateLeg2(Date var1);

        @Override
        public MASValuationReportBuilder setUniqueTransactionIdentifier(String var1);

        @Override
        public MASValuationReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        @Override
        public MASValuationReportBuilder setEventDate(Date var1);

        @Override
        public MASValuationReportBuilder setVariationMarginCollateralPortfolioCode(String var1);

        @Override
        public MASValuationReportBuilder setInitialMarginCollateralPortfolioCode(String var1);

        @Override
        public MASValuationReportBuilder setLastFloatingReferenceValueLeg1(BigDecimal var1);

        @Override
        public MASValuationReportBuilder setLastFloatingReferenceValueLeg2(BigDecimal var1);

        @Override
        public MASValuationReportBuilder setLastFloatingReferenceResetDateLeg1(Date var1);

        @Override
        public MASValuationReportBuilder setLastFloatingReferenceResetDateLeg2(Date var1);

        public MASValuationReportBuilder setCounterparty2IdentifierTypeOverriddenAsBoolean(Boolean var1);

        public MASValuationReportBuilder setReportSubmittingEntityIDOverriddenAsString(String var1);

        public MASValuationReportBuilder setExecutionAgentOfTheCounterparty1(String var1);

        public MASValuationReportBuilder setExecutionAgentOfTheCounterparty2(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, (Object)this.getCounterparty2IdentifierType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("level"), ReportLevelEnum.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, (Object)this.getReportSubmittingEntityID(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), String.class, (Object)this.getCounterparty2IdentifierSource(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("eventDate"), Date.class, (Object)this.getEventDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, (Object)this.getVariationMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, (Object)this.getInitialMarginCollateralPortfolioCode(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg1"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceValueLeg2"), BigDecimal.class, (Object)this.getLastFloatingReferenceValueLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("lastFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getLastFloatingReferenceResetDateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty1"), String.class, (Object)this.getExecutionAgentOfTheCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("executionAgentOfTheCounterparty2"), String.class, (Object)this.getExecutionAgentOfTheCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public MASValuationReportBuilder prune();
    }

    public static class MASValuationReportImpl
    extends CommonValuationReport.CommonValuationReportImpl
    implements MASValuationReport {
        private final Boolean counterparty2IdentifierType;
        private final String reportSubmittingEntityID;
        private final String executionAgentOfTheCounterparty1;
        private final String executionAgentOfTheCounterparty2;

        protected MASValuationReportImpl(MASValuationReportBuilder builder) {
            super(builder);
            this.counterparty2IdentifierType = builder.getCounterparty2IdentifierType();
            this.reportSubmittingEntityID = builder.getReportSubmittingEntityID();
            this.executionAgentOfTheCounterparty1 = builder.getExecutionAgentOfTheCounterparty1();
            this.executionAgentOfTheCounterparty2 = builder.getExecutionAgentOfTheCounterparty2();
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierType", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierType", isRequired=true)
        public Boolean getCounterparty2IdentifierType() {
            return this.counterparty2IdentifierType;
        }

        @Override
        @RosettaAttribute(value="reportSubmittingEntityID", isRequired=true)
        @RuneAttribute(value="reportSubmittingEntityID", isRequired=true)
        public String getReportSubmittingEntityID() {
            return this.reportSubmittingEntityID;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty1")
        @RuneAttribute(value="executionAgentOfTheCounterparty1")
        public String getExecutionAgentOfTheCounterparty1() {
            return this.executionAgentOfTheCounterparty1;
        }

        @Override
        @RosettaAttribute(value="executionAgentOfTheCounterparty2")
        @RuneAttribute(value="executionAgentOfTheCounterparty2")
        public String getExecutionAgentOfTheCounterparty2() {
            return this.executionAgentOfTheCounterparty2;
        }

        @Override
        public MASValuationReport build() {
            return this;
        }

        @Override
        public MASValuationReportBuilder toBuilder() {
            MASValuationReportBuilder builder = MASValuationReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(MASValuationReportBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getCounterparty2IdentifierType()).ifPresent(builder::setCounterparty2IdentifierTypeOverriddenAsBoolean);
            Optional.ofNullable(this.getReportSubmittingEntityID()).ifPresent(builder::setReportSubmittingEntityIDOverriddenAsString);
            Optional.ofNullable(this.getExecutionAgentOfTheCounterparty1()).ifPresent(builder::setExecutionAgentOfTheCounterparty1);
            Optional.ofNullable(this.getExecutionAgentOfTheCounterparty2()).ifPresent(builder::setExecutionAgentOfTheCounterparty2);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            MASValuationReport _that = (MASValuationReport)this.getType().cast(o);
            if (!Objects.equals(this.counterparty2IdentifierType, _that.getCounterparty2IdentifierType())) {
                return false;
            }
            if (!Objects.equals(this.reportSubmittingEntityID, _that.getReportSubmittingEntityID())) {
                return false;
            }
            if (!Objects.equals(this.executionAgentOfTheCounterparty1, _that.getExecutionAgentOfTheCounterparty1())) {
                return false;
            }
            return Objects.equals(this.executionAgentOfTheCounterparty2, _that.getExecutionAgentOfTheCounterparty2());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.counterparty2IdentifierType != null ? this.counterparty2IdentifierType.hashCode() : 0);
            _result = 31 * _result + (this.reportSubmittingEntityID != null ? this.reportSubmittingEntityID.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfTheCounterparty1 != null ? this.executionAgentOfTheCounterparty1.hashCode() : 0);
            _result = 31 * _result + (this.executionAgentOfTheCounterparty2 != null ? this.executionAgentOfTheCounterparty2.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "MASValuationReport {counterparty2IdentifierType=" + this.counterparty2IdentifierType + ", reportSubmittingEntityID=" + this.reportSubmittingEntityID + ", executionAgentOfTheCounterparty1=" + this.executionAgentOfTheCounterparty1 + ", executionAgentOfTheCounterparty2=" + this.executionAgentOfTheCounterparty2 + "} " + super.toString();
        }
    }
}

