/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.sec.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.TransactionReportInstructionBase;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.sec.rewrite.trade.functions.IsAllowableActionForSEC;
import drr.standards.iosco.cde.version3.price.reports.OptionPremiumAmountRule;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=PremiumAmountRuleDefault.class)
public abstract class PremiumAmountRule
implements ReportFunction<TransactionReportInstruction, BigDecimal> {
    @Inject
    protected IsAllowableActionForSEC isAllowableActionForSEC;
    @Inject
    protected OptionPremiumAmountRule optionPremiumAmountRule;

    public BigDecimal evaluate(TransactionReportInstruction input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstruction var1);

    public static class PremiumAmountRuleDefault
    extends PremiumAmountRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstruction input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForSEC.evaluate((ReportableEventBase)item.get()));
            output = (BigDecimal)thenArg.mapSingleToItem(item -> MapperS.of((Object)this.optionPremiumAmountRule.evaluate((TransactionReportInstructionBase)item.get()))).get();
            return output;
        }
    }
}

