/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.execution.functions;

import cdm.base.datetime.AdjustableDate;
import cdm.product.asset.CommodityPayout;
import cdm.product.asset.InterestRatePayout;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperListOfLists;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.underlier.functions.UnderlierForProduct;
import drr.base.util.datetime.functions.AdjustableDateResolution;
import drr.base.util.datetime.functions.MaxAdjustableDate;
import drr.standards.iosco.cde.version1.execution.functions.CommoditySettlementDate;
import drr.standards.iosco.cde.version1.execution.functions.FixedPriceSettlementDate;
import drr.standards.iosco.cde.version1.execution.functions.ForwardSettlementDate;
import drr.standards.iosco.cde.version1.execution.functions.InterestRateSettlementDate;
import drr.standards.iosco.cde.version1.execution.functions.OptionSettlementDate;
import drr.standards.iosco.cde.version1.execution.functions.PerformanceSettlementDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=ExtractFinalContractualSettlementDateDefault.class)
public abstract class ExtractFinalContractualSettlementDate
implements RosettaFunction {
    @Inject
    protected AdjustableDateResolution adjustableDateResolution;
    @Inject
    protected CommoditySettlementDate commoditySettlementDate;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected ExtractFinalContractualSettlementDate extractFinalContractualSettlementDate;
    @Inject
    protected FixedPriceSettlementDate fixedPriceSettlementDate;
    @Inject
    protected ForwardSettlementDate forwardSettlementDate;
    @Inject
    protected InterestRateSettlementDate interestRateSettlementDate;
    @Inject
    protected MaxAdjustableDate maxAdjustableDate;
    @Inject
    protected OptionSettlementDate optionSettlementDate;
    @Inject
    protected PerformanceSettlementDate performanceSettlementDate;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public List<Date> evaluate(Product product) {
        List<Date> date = this.doEvaluate(product);
        return date;
    }

    protected abstract List<Date> doEvaluate(Product var1);

    protected abstract MapperC<? extends FixedPricePayout> fixedPricePayout(Product var1);

    protected abstract MapperC<? extends CommodityPayout> commodityPayout(Product var1);

    protected abstract MapperC<? extends OptionPayout> optionPayout(Product var1);

    protected abstract MapperC<? extends InterestRatePayout> interestRatePayout(Product var1);

    protected abstract MapperC<? extends PerformancePayout> performancePayout(Product var1);

    protected abstract MapperC<? extends ForwardPayout> forwardPayout(Product var1);

    public static class ExtractFinalContractualSettlementDateDefault
    extends ExtractFinalContractualSettlementDate {
        @Override
        protected List<Date> doEvaluate(Product product) {
            ArrayList<Date> date = new ArrayList<Date>();
            return this.assignOutput(date, product);
        }

        protected List<Date> assignOutput(List<Date> date, Product product) {
            MapperListOfLists thenArg0 = this.fixedPricePayout(product).mapItemToList(item -> MapperC.of(this.fixedPriceSettlementDate.evaluate((FixedPricePayout)item.get())));
            date.addAll(thenArg0.flattenList().getMulti());
            MapperListOfLists thenArg1 = this.optionPayout(product).mapItemToList(item -> MapperC.of(this.optionSettlementDate.evaluate((OptionPayout)item.get())));
            date.addAll(thenArg1.flattenList().getMulti());
            MapperListOfLists thenArg2 = this.commodityPayout(product).mapItemToList(item -> MapperC.of(this.commoditySettlementDate.evaluate((CommodityPayout)item.get())));
            date.addAll(thenArg2.flattenList().getMulti());
            MapperListOfLists thenArg3 = this.interestRatePayout(product).mapItemToList(item -> MapperC.of(this.interestRateSettlementDate.evaluate((InterestRatePayout)item.get())));
            date.addAll(thenArg3.flattenList().getMulti());
            MapperListOfLists thenArg4 = this.performancePayout(product).mapItemToList(item -> MapperC.of(this.performanceSettlementDate.evaluate((PerformancePayout)item.get())));
            date.addAll(thenArg4.flattenList().getMulti());
            MapperListOfLists thenArg5 = this.forwardPayout(product).mapItemToList(item -> MapperC.of(this.forwardSettlementDate.evaluate((ForwardPayout)item.get())));
            date.addAll(thenArg5.flattenList().getMulti());
            if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(this.underlierForProduct.evaluate(product)))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                date.addAll(this.extractFinalContractualSettlementDate.evaluate(this.underlierForProduct.evaluate(product)));
            } else {
                date.addAll(Collections.emptyList());
            }
            Date date0 = this.adjustableDateResolution.evaluate((AdjustableDate)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getTerminationDate", economicTerms -> economicTerms.getTerminationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get());
            if (date0 == null) {
                date.addAll(Collections.emptyList());
            } else {
                date.addAll(Collections.singletonList(date0));
            }
            Date date1 = this.maxAdjustableDate.evaluate((AdjustableDate)this.performancePayout(product).map("getValuationDates", _performancePayout -> _performancePayout.getValuationDates()).map("getValuationDatesFinal", valuationDates -> valuationDates.getValuationDatesFinal()).map("getValuationDate", performanceValuationDates -> performanceValuationDates.getValuationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get(), (AdjustableDate)this.interestRatePayout(product).map("getCalculationPeriodDates", _interestRatePayout -> _interestRatePayout.getCalculationPeriodDates()).map("getTerminationDate", calculationPeriodDates -> calculationPeriodDates.getTerminationDate()).map("getAdjustableDate", adjustableOrRelativeDate -> adjustableOrRelativeDate.getAdjustableDate()).get());
            if (date1 == null) {
                date.addAll(Collections.emptyList());
            } else {
                date.addAll(Collections.singletonList(date1));
            }
            return date;
        }

        @Override
        protected MapperC<? extends FixedPricePayout> fixedPricePayout(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getFixedPricePayout", payout -> payout.getFixedPricePayout());
        }

        @Override
        protected MapperC<? extends CommodityPayout> commodityPayout(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout());
        }

        @Override
        protected MapperC<? extends OptionPayout> optionPayout(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout());
        }

        @Override
        protected MapperC<? extends InterestRatePayout> interestRatePayout(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout());
        }

        @Override
        protected MapperC<? extends PerformancePayout> performancePayout(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getPerformancePayout", payout -> payout.getPerformancePayout());
        }

        @Override
        protected MapperC<? extends ForwardPayout> forwardPayout(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout());
        }
    }
}

