/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.execution.reports;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.product.common.settlement.SettlementTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.PayoutLegWithAuxiliary;
import drr.standards.iosco.cde.version1.execution.reports.SettlementTermsRule;
import javax.inject.Inject;

@ImplementedBy(value=SettlementLocationRuleDefault.class)
public abstract class SettlementLocationRule
implements ReportFunction<PayoutLegWithAuxiliary, ISOCountryCodeEnum> {
    @Inject
    protected SettlementTermsRule settlementTermsRule;

    public ISOCountryCodeEnum evaluate(PayoutLegWithAuxiliary input) {
        ISOCountryCodeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ISOCountryCodeEnum doEvaluate(PayoutLegWithAuxiliary var1);

    public static class SettlementLocationRuleDefault
    extends SettlementLocationRule {
        @Override
        protected ISOCountryCodeEnum doEvaluate(PayoutLegWithAuxiliary input) {
            ISOCountryCodeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ISOCountryCodeEnum assignOutput(ISOCountryCodeEnum output, PayoutLegWithAuxiliary input) {
            output = (ISOCountryCodeEnum)MapperS.of((Object)this.settlementTermsRule.evaluate(input)).mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), (Mapper)MapperS.of((Object)SettlementTypeEnum.CASH), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)item.mapC("getCashSettlementTerms", settlementTerms -> settlementTerms.getCashSettlementTerms()))).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getSettlementCurrency", settlementTerms -> settlementTerms.getSettlementCurrency()).map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue()), (Mapper)MapperS.of((Object)"CNH"), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)ISOCountryCodeEnum.HK);
                }
                return MapperS.ofNull();
            }).get();
            return output;
        }
    }
}

