/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.payment.functions;

import cdm.event.common.TransferExpression;
import cdm.event.common.TransferState;
import cdm.observable.asset.FeeTypeEnum;
import cdm.product.common.settlement.ScheduledTransferEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;

@ImplementedBy(value=IsOtherPaymentDefault.class)
public abstract class IsOtherPayment
implements RosettaFunction {
    public Boolean evaluate(TransferState transferState) {
        Boolean result = this.doEvaluate(transferState);
        return result;
    }

    protected abstract Boolean doEvaluate(TransferState var1);

    protected abstract MapperS<? extends TransferExpression> transferExpression(TransferState var1);

    public static class IsOtherPaymentDefault
    extends IsOtherPayment {
        @Override
        protected Boolean doEvaluate(TransferState transferState) {
            Boolean result = null;
            return this.assignOutput(result, transferState);
        }

        protected Boolean assignOutput(Boolean result, TransferState transferState) {
            result = ExpressionOperatorsNullSafe.areEqual((Mapper)this.transferExpression(transferState).map("getPriceTransfer", _transferExpression -> _transferExpression.getPriceTransfer()), (Mapper)MapperS.of((Object)FeeTypeEnum.UPFRONT), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)this.transferExpression(transferState).map("getPriceTransfer", _transferExpression -> _transferExpression.getPriceTransfer()), (Mapper)MapperS.of((Object)FeeTypeEnum.TERMINATION), (CardinalityOperator)CardinalityOperator.All)).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)this.transferExpression(transferState).map("getPriceTransfer", _transferExpression -> _transferExpression.getPriceTransfer()), (Mapper)MapperS.of((Object)FeeTypeEnum.PARTIAL_TERMINATION), (CardinalityOperator)CardinalityOperator.All)).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)this.transferExpression(transferState).map("getScheduledTransfer", _transferExpression -> _transferExpression.getScheduledTransfer()).map("getTransferType", scheduledTransfer -> scheduledTransfer.getTransferType()), (Mapper)MapperS.of((Object)ScheduledTransferEnum.PRINCIPAL_PAYMENT), (CardinalityOperator)CardinalityOperator.All)).get();
            return result;
        }

        @Override
        protected MapperS<? extends TransferExpression> transferExpression(TransferState transferState) {
            return MapperS.of((Object)transferState).map("getTransfer", _transferState -> _transferState.getTransfer()).map("getTransferExpression", transfer -> transfer.getTransferExpression());
        }
    }
}

