/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.price.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.TransactionReportInstructionBase;
import drr.standards.iosco.cde.version1.price.reports.PackageTransactionSpreadRule;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=PackageTransactionSpreadValueRuleDefault.class)
public abstract class PackageTransactionSpreadValueRule
implements ReportFunction<TransactionReportInstructionBase, BigDecimal> {
    @Inject
    protected PackageTransactionSpreadRule packageTransactionSpreadRule;

    public BigDecimal evaluate(TransactionReportInstructionBase input) {
        BigDecimal output = this.doEvaluate(input);
        return output;
    }

    protected abstract BigDecimal doEvaluate(TransactionReportInstructionBase var1);

    public static class PackageTransactionSpreadValueRuleDefault
    extends PackageTransactionSpreadValueRule {
        @Override
        protected BigDecimal doEvaluate(TransactionReportInstructionBase input) {
            BigDecimal output = null;
            return this.assignOutput(output, input);
        }

        protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstructionBase input) {
            MapperS thenArg = MapperS.of((Object)this.packageTransactionSpreadRule.evaluate(input));
            output = (BigDecimal)thenArg.map("getValue", price -> price.getValue()).get();
            return output;
        }
    }
}

