/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.quantity.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.product.template.OptionPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.standards.iso.OptionTypeCode;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=OptionAmountAndCurrencyDefault.class)
public abstract class OptionAmountAndCurrency
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public NonNegativeQuantitySchedule evaluate(OptionPayout optionPayout, OptionTypeCode optionType) {
        NonNegativeQuantitySchedule quantitySchedule;
        NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantityScheduleBuilder = this.doEvaluate(optionPayout, optionType);
        if (quantityScheduleBuilder == null) {
            quantitySchedule = null;
        } else {
            quantitySchedule = quantityScheduleBuilder.build();
            this.objectValidator.validate(NonNegativeQuantitySchedule.class, (RosettaModelObject)quantitySchedule);
        }
        return quantitySchedule;
    }

    protected abstract NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(OptionPayout var1, OptionTypeCode var2);

    protected abstract MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> FXOptionCall(OptionPayout var1, OptionTypeCode var2);

    protected abstract MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> FXOptionPut(OptionPayout var1, OptionTypeCode var2);

    public static class OptionAmountAndCurrencyDefault
    extends OptionAmountAndCurrency {
        @Override
        protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(OptionPayout optionPayout, OptionTypeCode optionType) {
            NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantitySchedule = NonNegativeQuantitySchedule.builder();
            return this.assignOutput(quantitySchedule, optionPayout, optionType);
        }

        protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder assignOutput(NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantitySchedule, OptionPayout optionPayout, OptionTypeCode optionType) {
            ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule1;
            ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule0;
            quantitySchedule = ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)optionType)), (Mapper)MapperS.of((Object)((Object)OptionTypeCode.CALL)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue() ? ((referenceWithMetaNonNegativeQuantitySchedule0 = (ReferenceWithMetaNonNegativeQuantitySchedule)this.FXOptionCall(optionPayout, optionType).get()) == null ? null : (NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder)this.toBuilder((RosettaModelObject)referenceWithMetaNonNegativeQuantitySchedule0.getValue())) : ((referenceWithMetaNonNegativeQuantitySchedule1 = (ReferenceWithMetaNonNegativeQuantitySchedule)this.FXOptionPut(optionPayout, optionType).get()) == null ? null : (NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder)this.toBuilder((RosettaModelObject)referenceWithMetaNonNegativeQuantitySchedule1.getValue()));
            return Optional.ofNullable(quantitySchedule).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> FXOptionCall(OptionPayout optionPayout, OptionTypeCode optionType) {
            MapperS thenArg = MapperS.of((Object)optionPayout);
            MapperS ifThenElseResult = ExpressionOperatorsNullSafe.areEqual((Mapper)thenArg.map("getBuyerSeller", _optionPayout -> _optionPayout.getBuyerSeller()).map("getBuyer", buyerSeller -> buyerSeller.getBuyer()), (Mapper)thenArg.map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange()).map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).map("getPayerReceiver", cashflow -> cashflow.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? thenArg.map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange()).map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()) : thenArg.map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange()).map("getExchangedCurrency2", foreignExchange -> foreignExchange.getExchangedCurrency2()).map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
            return ifThenElseResult;
        }

        @Override
        protected MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> FXOptionPut(OptionPayout optionPayout, OptionTypeCode optionType) {
            MapperS thenArg = MapperS.of((Object)optionPayout);
            MapperS ifThenElseResult = ExpressionOperatorsNullSafe.areEqual((Mapper)thenArg.map("getBuyerSeller", _optionPayout -> _optionPayout.getBuyerSeller()).map("getBuyer", buyerSeller -> buyerSeller.getBuyer()), (Mapper)thenArg.map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange()).map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).map("getPayerReceiver", cashflow -> cashflow.getPayerReceiver()).map("getReceiver", payerReceiver -> payerReceiver.getReceiver()), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? thenArg.map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange()).map("getExchangedCurrency2", foreignExchange -> foreignExchange.getExchangedCurrency2()).map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule()) : thenArg.map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange()).map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
            return ifThenElseResult;
        }
    }
}

