/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version1.valuation.functions;

import cdm.base.math.RoundingDirectionEnum;
import cdm.base.math.functions.RoundToPrecision;
import cdm.event.common.Valuation;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.standards.iso.functions.FormatToShortFraction5DecimalNumber;
import java.math.BigDecimal;
import javax.inject.Inject;

@ImplementedBy(value=ValuationAmountFromValuationDefault.class)
public abstract class ValuationAmountFromValuation
implements RosettaFunction {
    @Inject
    protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
    @Inject
    protected RoundToPrecision roundToPrecision;

    public BigDecimal evaluate(Valuation valuation) {
        BigDecimal valuationAmount = this.doEvaluate(valuation);
        return valuationAmount;
    }

    protected abstract BigDecimal doEvaluate(Valuation var1);

    public static class ValuationAmountFromValuationDefault
    extends ValuationAmountFromValuation {
        @Override
        protected BigDecimal doEvaluate(Valuation valuation) {
            BigDecimal valuationAmount = null;
            return this.assignOutput(valuationAmount, valuation);
        }

        protected BigDecimal assignOutput(BigDecimal valuationAmount, Valuation valuation) {
            MapperS thenArg0 = MapperS.of((Object)valuation).map("getAmount", _valuation -> _valuation.getAmount()).map("getValue", money -> money.getValue());
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.roundToPrecision.evaluate((BigDecimal)item.get(), Integer.valueOf(5), RoundingDirectionEnum.NEAREST)));
            valuationAmount = (BigDecimal)MapperS.of((Object)this.formatToShortFraction5DecimalNumber.evaluate((BigDecimal)thenArg1.get())).get();
            return valuationAmount;
        }
    }
}

