/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version2.price.functions;

import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.base.trade.ReportableEventBase;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=StrikePriceDefault.class)
public abstract class StrikePrice
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected drr.standards.iosco.cde.version1.price.functions.StrikePrice strikePrice;

    public PriceSchedule evaluate(ReportableEventBase reportableEvent) {
        PriceSchedule prices;
        PriceSchedule.PriceScheduleBuilder pricesBuilder = this.doEvaluate(reportableEvent);
        if (pricesBuilder == null) {
            prices = null;
        } else {
            prices = pricesBuilder.build();
            this.objectValidator.validate(PriceSchedule.class, (RosettaModelObject)prices);
        }
        return prices;
    }

    protected abstract PriceSchedule.PriceScheduleBuilder doEvaluate(ReportableEventBase var1);

    public static class StrikePriceDefault
    extends StrikePrice {
        @Override
        protected PriceSchedule.PriceScheduleBuilder doEvaluate(ReportableEventBase reportableEvent) {
            PriceSchedule.PriceScheduleBuilder prices = PriceSchedule.builder();
            return this.assignOutput(prices, reportableEvent);
        }

        protected PriceSchedule.PriceScheduleBuilder assignOutput(PriceSchedule.PriceScheduleBuilder prices, ReportableEventBase reportableEvent) {
            prices = (PriceSchedule.PriceScheduleBuilder)this.toBuilder((RosettaModelObject)this.strikePrice.evaluate(reportableEvent));
            return Optional.ofNullable(prices).map(o -> o.prune()).orElse(null);
        }
    }
}

