/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version2.quantity.functions;

import cdm.base.math.Measure;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.base.trade.PayoutLegWithAuxiliary;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=NotionalDefault.class)
public abstract class Notional
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected drr.standards.iosco.cde.version1.quantity.functions.Notional notional;

    public Measure evaluate(PayoutLegWithAuxiliary payoutLeg) {
        Measure measure;
        Measure.MeasureBuilder measureBuilder = this.doEvaluate(payoutLeg);
        if (measureBuilder == null) {
            measure = null;
        } else {
            measure = measureBuilder.build();
            this.objectValidator.validate(Measure.class, (RosettaModelObject)measure);
        }
        return measure;
    }

    protected abstract Measure.MeasureBuilder doEvaluate(PayoutLegWithAuxiliary var1);

    public static class NotionalDefault
    extends Notional {
        @Override
        protected Measure.MeasureBuilder doEvaluate(PayoutLegWithAuxiliary payoutLeg) {
            Measure.MeasureBuilder measure = Measure.builder();
            return this.assignOutput(measure, payoutLeg);
        }

        protected Measure.MeasureBuilder assignOutput(Measure.MeasureBuilder measure, PayoutLegWithAuxiliary payoutLeg) {
            measure = (Measure.MeasureBuilder)this.toBuilder((RosettaModelObject)this.notional.evaluate(payoutLeg));
            return Optional.ofNullable(measure).map(o -> o.prune()).orElse(null);
        }
    }
}

