/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version3;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.base.trade.payment.PeriodicPayment;
import drr.base.trade.price.PriceFormat;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.quantity.NotionalPeriod;
import drr.standards.iosco.cde.version2.LegV2;
import drr.standards.iosco.cde.version3.meta.LegMeta;
import drr.standards.iso.Direction2Enum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RosettaDataType(value="Leg", builder=LegBuilderImpl.class, version="7.0.0-dev.85")
@RuneDataType(value="Leg", model="drr", builder=LegBuilderImpl.class, version="7.0.0-dev.85")
public interface Leg
extends LegV2 {
    public static final LegMeta metaData = new LegMeta();

    @Override
    public Leg build();

    @Override
    public LegBuilder toBuilder();

    public static LegBuilder builder() {
        return new LegBuilderImpl();
    }

    default public RosettaMetaData<? extends Leg> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Leg> getType() {
        return Leg.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("periodicPayment"), processor, PeriodicPayment.class, this.getPeriodicPayment(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmountSchedule"), processor, NotionalPeriod.class, this.getNotionalAmountSchedule(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalQuantitySchedule"), processor, NotionalPeriod.class, this.getNotionalQuantitySchedule(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("notionalCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("totalNotionalQuantity"), BigDecimal.class, (Object)this.getTotalNotionalQuantity(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spread"), processor, PriceFormat.class, this.getSpread(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadNotation"), PriceNotationEnum.class, (Object)this.getSpreadNotation(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSpreadCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("quantityUnitOfMeasure"), String.class, (Object)this.getQuantityUnitOfMeasure(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("direction2"), Direction2Enum.class, (Object)this.getDirection2(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class LegBuilderImpl
    extends LegV2.LegV2BuilderImpl
    implements LegBuilder {
        @Override
        @RosettaAttribute(value="periodicPayment")
        @RuneAttribute(value="periodicPayment")
        public LegBuilder setPeriodicPayment(PeriodicPayment _periodicPayment) {
            this.periodicPayment = _periodicPayment == null ? null : _periodicPayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount")
        @RuneAttribute(value="notionalAmount")
        public LegBuilder setNotionalAmount(BigDecimal _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmountSchedule")
        @RuneAttribute(value="notionalAmountSchedule")
        public LegBuilder addNotionalAmountSchedule(NotionalPeriod _notionalAmountSchedule) {
            if (_notionalAmountSchedule != null) {
                this.notionalAmountSchedule.add(_notionalAmountSchedule.toBuilder());
            }
            return this;
        }

        @Override
        public LegBuilder addNotionalAmountSchedule(NotionalPeriod _notionalAmountSchedule, int idx) {
            this.getIndex(this.notionalAmountSchedule, idx, () -> _notionalAmountSchedule.toBuilder());
            return this;
        }

        @Override
        public LegBuilder addNotionalAmountSchedule(List<? extends NotionalPeriod> notionalAmountSchedules) {
            if (notionalAmountSchedules != null) {
                for (NotionalPeriod notionalPeriod : notionalAmountSchedules) {
                    this.notionalAmountSchedule.add(notionalPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalAmountSchedule")
        public LegBuilder setNotionalAmountSchedule(List<? extends NotionalPeriod> notionalAmountSchedules) {
            this.notionalAmountSchedule = notionalAmountSchedules == null ? new ArrayList() : (List)notionalAmountSchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalQuantitySchedule")
        @RuneAttribute(value="notionalQuantitySchedule")
        public LegBuilder addNotionalQuantitySchedule(NotionalPeriod _notionalQuantitySchedule) {
            if (_notionalQuantitySchedule != null) {
                this.notionalQuantitySchedule.add(_notionalQuantitySchedule.toBuilder());
            }
            return this;
        }

        @Override
        public LegBuilder addNotionalQuantitySchedule(NotionalPeriod _notionalQuantitySchedule, int idx) {
            this.getIndex(this.notionalQuantitySchedule, idx, () -> _notionalQuantitySchedule.toBuilder());
            return this;
        }

        @Override
        public LegBuilder addNotionalQuantitySchedule(List<? extends NotionalPeriod> notionalQuantitySchedules) {
            if (notionalQuantitySchedules != null) {
                for (NotionalPeriod notionalPeriod : notionalQuantitySchedules) {
                    this.notionalQuantitySchedule.add(notionalPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="notionalQuantitySchedule")
        public LegBuilder setNotionalQuantitySchedule(List<? extends NotionalPeriod> notionalQuantitySchedules) {
            this.notionalQuantitySchedule = notionalQuantitySchedules == null ? new ArrayList() : (List)notionalQuantitySchedules.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalCurrency")
        @RuneAttribute(value="notionalCurrency")
        public LegBuilder setNotionalCurrency(ISOCurrencyCodeEnum _notionalCurrency) {
            this.notionalCurrency = _notionalCurrency == null ? null : _notionalCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="totalNotionalQuantity")
        @RuneAttribute(value="totalNotionalQuantity")
        public LegBuilder setTotalNotionalQuantity(BigDecimal _totalNotionalQuantity) {
            this.totalNotionalQuantity = _totalNotionalQuantity == null ? null : _totalNotionalQuantity;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRate")
        @RuneAttribute(value="fixedRate")
        public LegBuilder setFixedRate(BigDecimal _fixedRate) {
            this.fixedRate = _fixedRate == null ? null : _fixedRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public LegBuilder setSettlementCurrency(ISOCurrencyCodeEnum _settlementCurrency) {
            this.settlementCurrency = _settlementCurrency == null ? null : _settlementCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="spread")
        @RuneAttribute(value="spread")
        public LegBuilder setSpread(PriceFormat _spread) {
            this.spread = _spread == null ? null : _spread.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadNotation")
        @RuneAttribute(value="spreadNotation")
        public LegBuilder setSpreadNotation(PriceNotationEnum _spreadNotation) {
            this.spreadNotation = _spreadNotation == null ? null : _spreadNotation;
            return this;
        }

        @Override
        @RosettaAttribute(value="spreadCurrency")
        @RuneAttribute(value="spreadCurrency")
        public LegBuilder setSpreadCurrency(ISOCurrencyCodeEnum _spreadCurrency) {
            this.spreadCurrency = _spreadCurrency == null ? null : _spreadCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="quantityUnitOfMeasure")
        @RuneAttribute(value="quantityUnitOfMeasure")
        public LegBuilder setQuantityUnitOfMeasure(String _quantityUnitOfMeasure) {
            this.quantityUnitOfMeasure = _quantityUnitOfMeasure == null ? null : _quantityUnitOfMeasure;
            return this;
        }

        @Override
        @RosettaAttribute(value="direction2")
        @RuneAttribute(value="direction2")
        public LegBuilder setDirection2(Direction2Enum _direction2) {
            this.direction2 = _direction2 == null ? null : _direction2;
            return this;
        }

        @Override
        public Leg build() {
            return new LegImpl(this);
        }

        @Override
        public LegBuilder toBuilder() {
            return this;
        }

        @Override
        public LegBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            return super.hasData();
        }

        @Override
        public LegBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LegBuilder o = (LegBuilder)other;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "LegBuilder {} " + super.toString();
        }
    }

    public static interface LegBuilder
    extends Leg,
    LegV2.LegV2Builder {
        @Override
        public LegBuilder setPeriodicPayment(PeriodicPayment var1);

        @Override
        public LegBuilder setNotionalAmount(BigDecimal var1);

        @Override
        public LegBuilder addNotionalAmountSchedule(NotionalPeriod var1);

        @Override
        public LegBuilder addNotionalAmountSchedule(NotionalPeriod var1, int var2);

        @Override
        public LegBuilder addNotionalAmountSchedule(List<? extends NotionalPeriod> var1);

        @Override
        public LegBuilder setNotionalAmountSchedule(List<? extends NotionalPeriod> var1);

        @Override
        public LegBuilder addNotionalQuantitySchedule(NotionalPeriod var1);

        @Override
        public LegBuilder addNotionalQuantitySchedule(NotionalPeriod var1, int var2);

        @Override
        public LegBuilder addNotionalQuantitySchedule(List<? extends NotionalPeriod> var1);

        @Override
        public LegBuilder setNotionalQuantitySchedule(List<? extends NotionalPeriod> var1);

        @Override
        public LegBuilder setNotionalCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public LegBuilder setTotalNotionalQuantity(BigDecimal var1);

        @Override
        public LegBuilder setFixedRate(BigDecimal var1);

        @Override
        public LegBuilder setSettlementCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public LegBuilder setSpread(PriceFormat var1);

        @Override
        public LegBuilder setSpreadNotation(PriceNotationEnum var1);

        @Override
        public LegBuilder setSpreadCurrency(ISOCurrencyCodeEnum var1);

        @Override
        public LegBuilder setQuantityUnitOfMeasure(String var1);

        @Override
        public LegBuilder setDirection2(Direction2Enum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("periodicPayment"), processor, PeriodicPayment.PeriodicPaymentBuilder.class, (RosettaModelObjectBuilder)this.getPeriodicPayment(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalAmount"), BigDecimal.class, (Object)this.getNotionalAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmountSchedule"), processor, NotionalPeriod.NotionalPeriodBuilder.class, this.getNotionalAmountSchedule(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalQuantitySchedule"), processor, NotionalPeriod.NotionalPeriodBuilder.class, this.getNotionalQuantitySchedule(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("notionalCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getNotionalCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("totalNotionalQuantity"), BigDecimal.class, (Object)this.getTotalNotionalQuantity(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixedRate"), BigDecimal.class, (Object)this.getFixedRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSettlementCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spread"), processor, PriceFormat.PriceFormatBuilder.class, (RosettaModelObjectBuilder)this.getSpread(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadNotation"), PriceNotationEnum.class, (Object)this.getSpreadNotation(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spreadCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getSpreadCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("quantityUnitOfMeasure"), String.class, (Object)this.getQuantityUnitOfMeasure(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("direction2"), Direction2Enum.class, (Object)this.getDirection2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public LegBuilder prune();
    }

    public static class LegImpl
    extends LegV2.LegV2Impl
    implements Leg {
        protected LegImpl(LegBuilder builder) {
            super(builder);
        }

        @Override
        public Leg build() {
            return this;
        }

        @Override
        public LegBuilder toBuilder() {
            LegBuilder builder = Leg.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LegBuilder builder) {
            super.setBuilderFields(builder);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "Leg {} " + super.toString();
        }
    }
}

